-----------------------------------------------
-- TraitModifiers
-----------------------------------------------
INSERT OR REPLACE INTO TraitModifiers (TraitType, 			ModifierID) VALUES	
('TRAIT_CIVILIZATION_THREE_KINGDOMS',	'GOLDEN_TRAIT_FARM_ADJACENT_FARM_FOOD'),
('TRAIT_CIVILIZATION_THREE_KINGDOMS',	'GOLDEN_TRAIT_FISHERY_ADJACENT_FISHERY_FOOD'),
('TRAIT_CIVILIZATION_THREE_KINGDOMS',	'GOLDEN_TRAIT_MINE_ADJACENT_MINE_PRODUCTION'),
('TRAIT_CIVILIZATION_THREE_KINGDOMS',	'GOLDEN_TRAIT_LUMBERMILL_ADJACENT_LUMBERMILL_PRODUCTION'),
('TRAIT_LEADER_HWARANG',	'GOLDEN_TRAIT_ADJUST_CITY_FOOD_PER_GOVERNOR_TITLE_MODIFIER'),
('TRAIT_LEADER_HWARANG',	'GOLDEN_TRAIT_ADJUST_CITY_PRODUCTION_PER_GOVERNOR_TITLE_MODIFIER'),
('TRAIT_LEADER_HWARANG',	'GOLDEN_TRAIT_ADJUST_CITY_GOLD_PER_GOVERNOR_TITLE_MODIFIER'),
('TRAIT_LEADER_HWARANG',	'GOLDEN_TRAIT_ADJUST_CITY_FAITH_PER_GOVERNOR_TITLE_MODIFIER');
INSERT OR REPLACE INTO TraitModifiers (TraitType,									ModifierId)
SELECT	'TRAIT_LEADER_HWARANG',	'GOLDEN_TRAIT_CITY_WITHOUT_GOVERNOR_DEBUFF' || YieldType FROM	Yields WHERE YieldType IN ('YIELD_FOOD', 'YIELD_PRODUCTION', 'YIELD_GOLD', 'YIELD_SCIENCE', 'YIELD_CULTURE', 'YIELD_FAITH');	
DELETE FROM TraitModifiers WHERE TraitType = 'TRAIT_CIVILIZATION_THREE_KINGDOMS' AND ModifierId = 'TRAIT_MINES_SCIENCE_SEOWON';
DELETE FROM TraitModifiers WHERE TraitType = 'TRAIT_CIVILIZATION_THREE_KINGDOMS' AND ModifierId = 'TRAIT_FARMS_FOOD_SEOWON';
-----------------------------------------------
-- Modifiers
-----------------------------------------------
INSERT OR REPLACE INTO Modifiers (ModifierId,						            ModifierType,								                                    SubjectRequirementSetId) VALUES	
('GOLDEN_TRAIT_FARM_ADJACENT_FARM_FOOD',			                'MODIFIER_PLAYER_ADJUST_PLOT_YIELD',		                                    'GOLDEN_KOREA_PLOT_HAS_FARM_ADJACENT_FARM_REQUIREMENTS'),
('GOLDEN_TRAIT_FISHERY_ADJACENT_FISHERY_FOOD',			            'MODIFIER_PLAYER_ADJUST_PLOT_YIELD',		                                    'GOLDEN_KOREA_PLOT_HAS_FISHERY_ADJACENT_FISHERY_REQUIREMENTS'),
('GOLDEN_TRAIT_MINE_ADJACENT_MINE_PRODUCTION',			            'MODIFIER_PLAYER_ADJUST_PLOT_YIELD',		                                    'GOLDEN_KOREA_PLOT_HAS_MINE_ADJACENT_MINE_REQUIREMENTS'),
('GOLDEN_TRAIT_LUMBERMILL_ADJACENT_LUMBERMILL_PRODUCTION',			'MODIFIER_PLAYER_ADJUST_PLOT_YIELD',		                                    'GOLDEN_KOREA_PLOT_HAS_LUMBERMILL_ADJACENT_LUMBERMILL_REQUIREMENTS'),
('GOLDEN_TRAIT_ADJUST_CITY_FOOD_PER_GOVERNOR_TITLE_MODIFIER',			            'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER_PER_GOVERNOR_TITLE',		                                    NULL),
('GOLDEN_TRAIT_ADJUST_CITY_PRODUCTION_PER_GOVERNOR_TITLE_MODIFIER',			        'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER_PER_GOVERNOR_TITLE',		                                    NULL),
('GOLDEN_TRAIT_ADJUST_CITY_GOLD_PER_GOVERNOR_TITLE_MODIFIER',			            'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER_PER_GOVERNOR_TITLE',		                                    NULL),
('GOLDEN_TRAIT_ADJUST_CITY_FAITH_PER_GOVERNOR_TITLE_MODIFIER',			            'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER_PER_GOVERNOR_TITLE',		                                    NULL);
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'GOLDEN_TRAIT_CITY_WITHOUT_GOVERNOR_DEBUFF' || YieldType,	'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER', 'CITY_HAS_NO_GOVERNOR_REQUIREMENTS' FROM Yields WHERE YieldType IN ('YIELD_FOOD', 'YIELD_PRODUCTION', 'YIELD_GOLD', 'YIELD_SCIENCE', 'YIELD_CULTURE', 'YIELD_FAITH');		
-----------------------------------------------
-- ModifierArguments
-----------------------------------------------
INSERT OR REPLACE INTO ModifierArguments (ModifierId,			Name,		        Value) VALUES
('GOLDEN_TRAIT_FARM_ADJACENT_FARM_FOOD',					            'YieldType',	    'YIELD_FOOD'),
('GOLDEN_TRAIT_FARM_ADJACENT_FARM_FOOD',					            'Amount',	        1),
('GOLDEN_TRAIT_FISHERY_ADJACENT_FISHERY_FOOD',					        'YieldType',	    'YIELD_FOOD'),
('GOLDEN_TRAIT_FISHERY_ADJACENT_FISHERY_FOOD',					        'Amount',	        1),
('GOLDEN_TRAIT_MINE_ADJACENT_MINE_PRODUCTION',					        'YieldType',	    'YIELD_PRODUCTION'),
('GOLDEN_TRAIT_MINE_ADJACENT_MINE_PRODUCTION',					        'Amount',	        1),
('GOLDEN_TRAIT_LUMBERMILL_ADJACENT_LUMBERMILL_PRODUCTION',		        'YieldType',	    'YIELD_PRODUCTION'),
('GOLDEN_TRAIT_LUMBERMILL_ADJACENT_LUMBERMILL_PRODUCTION',		        'Amount',	        1),
('GOLDEN_TRAIT_ADJUST_CITY_FOOD_PER_GOVERNOR_TITLE_MODIFIER',			'YieldType',	    'YIELD_FOOD'),
('GOLDEN_TRAIT_ADJUST_CITY_FOOD_PER_GOVERNOR_TITLE_MODIFIER',			'Amount',	        5),
('GOLDEN_TRAIT_ADJUST_CITY_PRODUCTION_PER_GOVERNOR_TITLE_MODIFIER',		'YieldType',	    'YIELD_PRODUCTION'),
('GOLDEN_TRAIT_ADJUST_CITY_PRODUCTION_PER_GOVERNOR_TITLE_MODIFIER',		'Amount',	        5),
('GOLDEN_TRAIT_ADJUST_CITY_GOLD_PER_GOVERNOR_TITLE_MODIFIER',			'YieldType',	    'YIELD_GOLD'),
('GOLDEN_TRAIT_ADJUST_CITY_GOLD_PER_GOVERNOR_TITLE_MODIFIER',			'Amount',	        5),
('GOLDEN_TRAIT_ADJUST_CITY_FAITH_PER_GOVERNOR_TITLE_MODIFIER',		    'YieldType',	    'YIELD_FAITH'),
('GOLDEN_TRAIT_ADJUST_CITY_FAITH_PER_GOVERNOR_TITLE_MODIFIER',		    'Amount',	        5);
UPDATE ModifierArguments SET  Value = 5
WHERE ModifierId = 'TRAIT_ADJUST_CITY_CULTURE_PER_GOVERNOR_TITLE_MODIFIER' AND Name = 'Amount';
UPDATE ModifierArguments SET  Value = 5
WHERE ModifierId = 'TRAIT_ADJUST_CITY_SCIENCE_PER_GOVERNOR_TITLE_MODIFIER' AND Name = 'Amount';
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_CITY_WITHOUT_GOVERNOR_DEBUFF' || YieldType,	'YieldType', YieldType FROM	Yields WHERE YieldType IN ('YIELD_FOOD', 'YIELD_PRODUCTION', 'YIELD_GOLD', 'YIELD_SCIENCE', 'YIELD_CULTURE', 'YIELD_FAITH');		
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_CITY_WITHOUT_GOVERNOR_DEBUFF' || YieldType,	'Amount', -10 FROM Yields WHERE YieldType IN ('YIELD_FOOD', 'YIELD_PRODUCTION', 'YIELD_GOLD', 'YIELD_SCIENCE', 'YIELD_CULTURE', 'YIELD_FAITH');	
---------------------------------------------------------------------------------------------------------------
-- RequirementSets
---------------------------------------------------------------------------------------------------------------
INSERT OR REPLACE INTO RequirementSets 				(RequirementSetId ,         RequirementSetType) 	VALUES 	
('GOLDEN_KOREA_PLOT_HAS_FARM_ADJACENT_FARM_REQUIREMENTS' , 		            'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_KOREA_PLOT_HAS_FISHERY_ADJACENT_FISHERY_REQUIREMENTS' , 		    'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_KOREA_PLOT_HAS_MINE_ADJACENT_MINE_REQUIREMENTS' , 		            'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_KOREA_PLOT_HAS_LUMBERMILL_ADJACENT_LUMBERMILL_REQUIREMENTS' , 		'REQUIREMENTSET_TEST_ALL');
---------------------------------------------------------------------------------------------------------------
-- RequirementSetRequirements
---------------------------------------------------------------------------------------------------------------
INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId ,         RequirementId) 			VALUES 	
('GOLDEN_KOREA_PLOT_HAS_FARM_ADJACENT_FARM_REQUIREMENTS' , 		            'GOLDEN_REQUIRES_PLOT_HAS_IMPROVEMENT_FARM'),
('GOLDEN_KOREA_PLOT_HAS_FARM_ADJACENT_FARM_REQUIREMENTS' , 		            'GOLDEN_REQUIRES_PLOT_IS_ADJACENT_TO_IMPROVEMENT_FARM'),
('GOLDEN_KOREA_PLOT_HAS_FISHERY_ADJACENT_FISHERY_REQUIREMENTS' , 		    'GOLDEN_REQUIRES_PLOT_HAS_IMPROVEMENT_FISHERY'),
('GOLDEN_KOREA_PLOT_HAS_FISHERY_ADJACENT_FISHERY_REQUIREMENTS' , 		    'GOLDEN_REQUIRES_PLOT_IS_ADJACENT_TO_IMPROVEMENT_FISHERY'),
('GOLDEN_KOREA_PLOT_HAS_MINE_ADJACENT_MINE_REQUIREMENTS' , 		            'GOLDEN_REQUIRES_PLOT_HAS_IMPROVEMENT_MINE'),
('GOLDEN_KOREA_PLOT_HAS_MINE_ADJACENT_MINE_REQUIREMENTS' , 		            'GOLDEN_REQUIRES_PLOT_IS_ADJACENT_TO_IMPROVEMENT_MINE'),
('GOLDEN_KOREA_PLOT_HAS_LUMBERMILL_ADJACENT_LUMBERMILL_REQUIREMENTS' , 		'GOLDEN_REQUIRES_PLOT_HAS_IMPROVEMENT_LUMBER_MILL'),
('GOLDEN_KOREA_PLOT_HAS_LUMBERMILL_ADJACENT_LUMBERMILL_REQUIREMENTS' , 		'GOLDEN_REQUIRES_PLOT_IS_ADJACENT_TO_IMPROVEMENT_LUMBER_MILL');