-----------------------------------------------
-- StartBias
-----------------------------------------------
INSERT OR REPLACE INTO StartBiasTerrains (CivilizationType,						TerrainType, Tier) VALUES	
('CIVILIZATION_MONGOLIA',			'TERRAIN_GRASS', 5),
('CIVILIZATION_MONGOLIA',			'TERRAIN_PLAINS', 5);
UPDATE StartBiasResources SET  Tier = 5
WHERE CivilizationType = 'CIVILIZATION_MONGOLIA' AND ResourceType = 'RESOURCE_HORSES';
-----------------------------------------------
-- TraitModifiers
-----------------------------------------------
INSERT OR REPLACE INTO TraitModifiers (TraitType, 			ModifierID) VALUES	
('TRAIT_CIVILIZATION_MONGOLIAN_ORTOO',	        'GOLDEN_TRAIT_PRODUCTION_FROM_DOMESTIC_TRADING_POSTS'),
('TRAIT_LEADER_GENGHIS_KHAN_ABILITY',	        'GOLDEN_TRAIT_GENGHIS_KHAN_TECH_STIRRUPS'),
('TRAIT_LEADER_GENGHIS_KHAN_ABILITY',	        'GOLDEN_TRAIT_GENGHIS_KHAN_TECH_HORSEBACK_RIDING'),
('TRAIT_LEADER_GENGHIS_KHAN_ABILITY',	        'GOLDEN_TRAIT_ALL_ECONOMIC_POLICY_ARE_MILITARY'),
('TRAIT_LEADER_GENGHIS_KHAN_ABILITY',	        'GOLDEN_TRAIT_CAVALRY_MOVE_AFTER_ATTACK_ABILITY'),
('TRAIT_LEADER_GENGHIS_KHAN_ABILITY',	        'GOLDEN_TRAIT_GENGHIS_KHAN_HEAL_ON_TWO_DISTRICT_CAPTURE'),
('TRAIT_LEADER_GENGHIS_KHAN_ABILITY',	        'GOLDEN_TRAIT_GENGHIS_KHAN_HEAL_ON_FOUR_DISTRICT_CAPTURE'),
('TRAIT_LEADER_GENGHIS_KHAN_ABILITY',	        'GOLDEN_TRAIT_GENGHIS_KHAN_HEAL_ON_SIX_DISTRICT_CAPTURE');

DELETE FROM TraitModifiers WHERE TraitType = 'TRAIT_CIVILIZATION_MONGOLIAN_ORTOO' AND ModifierId = 'TRAIT_EACH_DIPLO_VISIBILITY_COMBAT_MODIFIER';
-----------------------------------------------
-- Modifiers
-----------------------------------------------
INSERT OR REPLACE INTO Modifiers (ModifierId,						                ModifierType,								                                SubjectRequirementSetId) VALUES	
('GOLDEN_TRAIT_PRODUCTION_FROM_DOMESTIC_TRADING_POSTS',			        'MODIFIER_PLAYER_ADJUST_TRADE_ROUTE_YIELD_PER_POST_IN_OWN_CITY',		    NULL),
('GOLDEN_TRAIT_ALL_ECONOMIC_POLICY_ARE_MILITARY',			            'MODIFIER_PLAYER_CULTURE_REPLACE_GOVERNMENT_SLOTS',		                    NULL),
('GOLDEN_TRAIT_CAVALRY_MOVE_AFTER_ATTACK_ABILITY',			            'MODIFIER_PLAYER_UNITS_GRANT_ABILITY',		                                NULL),
('GOLDEN_TRAIT_GENGHIS_KHAN_HEAL_ON_TWO_DISTRICT_CAPTURE',			    'MODIFIER_PLAYER_CAPTURED_CITY_ATTACH_MODIFIER',		                    'GOLDEN_CITY_HAS_2_SPECIALTY_DISTRICTS_REQUIREMENTS'),
('GOLDEN_TRAIT_GENGHIS_KHAN_HEAL_ON_FOUR_DISTRICT_CAPTURE',			    'MODIFIER_PLAYER_CAPTURED_CITY_ATTACH_MODIFIER',		                    'GOLDEN_CITY_HAS_4_SPECIALTY_DISTRICTS_REQUIREMENTS'),
('GOLDEN_TRAIT_GENGHIS_KHAN_HEAL_ON_SIX_DISTRICT_CAPTURE',			    'MODIFIER_PLAYER_CAPTURED_CITY_ATTACH_MODIFIER',		                    'GOLDEN_CITY_HAS_6_SPECIALTY_DISTRICTS_REQUIREMENTS');

INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, RunOnce, Permanent, SubjectRequirementSetId) VALUES	
('GOLDEN_TRAIT_GENGHIS_KHAN_TECH_STIRRUPS',	                         'MODIFIER_PLAYER_GRANT_SPECIFIC_TECHNOLOGY', 1, 1, 'GOLDEN_PLAYER_HAS_TECH_MILITARY_TACTICS_REQUIREMENTS'),
('GOLDEN_TRAIT_GENGHIS_KHAN_TECH_HORSEBACK_RIDING',	                 'MODIFIER_PLAYER_GRANT_SPECIFIC_TECHNOLOGY', 1, 1, 'GOLDEN_PLAYER_HAS_TECH_THE_WHEEL_REQUIREMENTS'),
('GOLDEN_TRAIT_GENGHIS_KHAN_HEAL_ON_TWO_DISTRICT_CAPTURE_MODIFIER',  'MODIFIER_PLAYER_UNITS_ADJUST_DAMAGE',       1, 1, NULL),
('GOLDEN_TRAIT_GENGHIS_KHAN_HEAL_ON_FOUR_DISTRICT_CAPTURE_MODIFIER', 'MODIFIER_PLAYER_UNITS_ADJUST_DAMAGE',       1, 1, NULL),
('GOLDEN_TRAIT_GENGHIS_KHAN_HEAL_ON_SIX_DISTRICT_CAPTURE_MODIFIER',  'MODIFIER_PLAYER_UNITS_ADJUST_DAMAGE',       1, 1, NULL);
-----------------------------------------------
-- ModifierArguments
-----------------------------------------------
INSERT OR REPLACE INTO ModifierArguments (ModifierId,			                        Name,		                        Value) VALUES
('GOLDEN_TRAIT_PRODUCTION_FROM_DOMESTIC_TRADING_POSTS',					    'YieldType',	                    'YIELD_PRODUCTION'),
('GOLDEN_TRAIT_PRODUCTION_FROM_DOMESTIC_TRADING_POSTS',					    'Amount',	                        1),
('GOLDEN_TRAIT_GENGHIS_KHAN_TECH_STIRRUPS',		                            'TechType',	                        'TECH_STIRRUPS'),
('GOLDEN_TRAIT_GENGHIS_KHAN_TECH_HORSEBACK_RIDING',		                    'TechType',	                        'TECH_HORSEBACK_RIDING'),
('GOLDEN_TRAIT_ALL_ECONOMIC_POLICY_ARE_MILITARY',		                    'ReplacedGovernmentSlotType',	    'SLOT_ECONOMIC'),
('GOLDEN_TRAIT_ALL_ECONOMIC_POLICY_ARE_MILITARY',		                    'AddedGovernmentSlotType',	        'SLOT_MILITARY'),
('GOLDEN_TRAIT_CAVALRY_MOVE_AFTER_ATTACK_ABILITY',		                    'AbilityType',	                    'ABILITY_GENGHIS_KHAN_CAVALRY_MOVE_AFTER_ATTACK'),
('GOLDEN_TRAIT_GENGHIS_KHAN_HEAL_ON_TWO_DISTRICT_CAPTURE',					'ModifierId',	                    'GOLDEN_TRAIT_GENGHIS_KHAN_HEAL_ON_TWO_DISTRICT_CAPTURE_MODIFIER'),
('GOLDEN_TRAIT_GENGHIS_KHAN_HEAL_ON_TWO_DISTRICT_CAPTURE_MODIFIER',			'Amount',	                        -30),
('GOLDEN_TRAIT_GENGHIS_KHAN_HEAL_ON_FOUR_DISTRICT_CAPTURE',					'ModifierId',	                    'GOLDEN_TRAIT_GENGHIS_KHAN_HEAL_ON_FOUR_DISTRICT_CAPTURE_MODIFIER'),
('GOLDEN_TRAIT_GENGHIS_KHAN_HEAL_ON_FOUR_DISTRICT_CAPTURE_MODIFIER',		'Amount',	                        -30),
('GOLDEN_TRAIT_GENGHIS_KHAN_HEAL_ON_SIX_DISTRICT_CAPTURE',					'ModifierId',	                    'GOLDEN_TRAIT_GENGHIS_KHAN_HEAL_ON_SIX_DISTRICT_CAPTURE_MODIFIER'),
('GOLDEN_TRAIT_GENGHIS_KHAN_HEAL_ON_SIX_DISTRICT_CAPTURE_MODIFIER',			'Amount',	                        -30);

UPDATE ModifierArguments SET  Value = 6
WHERE ModifierId = 'GENGHIS_KHAN_CAVALRY_BONUS' AND Name = 'Amount';
UPDATE ModifierArguments SET  Value = 50
WHERE ModifierId = 'ORDU_TRAINED_XP' AND Name = 'Amount';
-----------------------------------------------
-- Types
-----------------------------------------------
INSERT OR REPLACE INTO Types (Type,						Kind) VALUES
('ABILITY_GENGHIS_KHAN_CAVALRY_MOVE_AFTER_ATTACK',					'KIND_ABILITY');
-----------------------------------------------
-- TypeTags
-----------------------------------------------		
INSERT OR REPLACE INTO TypeTags (Type,									Tag) VALUES	
('ABILITY_GENGHIS_KHAN_CAVALRY_MOVE_AFTER_ATTACK',				'CLASS_LIGHT_CAVALRY'),
('ABILITY_GENGHIS_KHAN_CAVALRY_MOVE_AFTER_ATTACK',			    'CLASS_HEAVY_CAVALRY');
-----------------------------------------------
-- UnitAbilities
-----------------------------------------------
INSERT OR REPLACE INTO UnitAbilities
(UnitAbilityType,						Name,									Description, Inactive) VALUES	
('ABILITY_GENGHIS_KHAN_CAVALRY_MOVE_AFTER_ATTACK',			'LOC_ABILITY_GENGHIS_KHAN_CAVALRY_MOVE_AFTER_ATTACK_NAME',	'LOC_ABILITY_GENGHIS_KHAN_CAVALRY_MOVE_AFTER_ATTACK_DESCRIPTION', 1);
-----------------------------------------------
-- UnitAbilityModifiers
-----------------------------------------------
INSERT OR REPLACE INTO UnitAbilityModifiers (UnitAbilityType,						ModifierId) VALUES	
('ABILITY_GENGHIS_KHAN_CAVALRY_MOVE_AFTER_ATTACK',			            'MOD_MOVE_AFTER_ATTACKING');