-----------------------------------------------
-- TraitModifiers
-----------------------------------------------
--Agricultural
DELETE FROM TraitModifiers WHERE ModifierId = 'MODIFIER_CSE_AGRICULTURAL_SHOPPING_MALL_FOOD' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType='MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
--Consular
INSERT OR REPLACE INTO TraitModifiers (TraitType, ModifierId)
SELECT	'MINOR_CIV_CSE_CONSULAR_TRAIT',	'MODIFIER_CSE_CONSULAR_INFLUENCEPOINTS_SMALL' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO TraitModifiers (TraitType, ModifierId)
SELECT	'MINOR_CIV_CSE_CONSULAR_TRAIT',	'MODIFIER_CSE_CONSULAR_INFLUENCEPOINTS_MEDIUM' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO TraitModifiers (TraitType, ModifierId)
SELECT	'MINOR_CIV_CSE_CONSULAR_TRAIT',	'MODIFIER_CSE_CONSULAR_INFLUENCEPOINTS_LARGE' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO TraitModifiers (TraitType, ModifierId)
SELECT	'MINOR_CIV_CSE_CONSULAR_TRAIT',	'MODIFIER_CSE_CONSULAR_INFLUENCEPOINTS_LARGEST' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
--Maritime
INSERT OR REPLACE INTO TraitModifiers (TraitType, ModifierId)
SELECT	'MINOR_CIV_CSE_MARITIME_TRAIT',	'MODIFIER_CSE_MARITIME_CAPITAL_GOLD' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO TraitModifiers (TraitType, ModifierId)
SELECT	'MINOR_CIV_CSE_MARITIME_TRAIT',	'MODIFIER_CSE_MARITIME_LIGHTHOUSE_GOLD' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO TraitModifiers (TraitType, ModifierId)
SELECT	'MINOR_CIV_CSE_MARITIME_TRAIT',	'MODIFIER_CSE_MARITIME_SHIPYARD_GOLD' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO TraitModifiers (TraitType, ModifierId)
SELECT	'MINOR_CIV_CSE_MARITIME_TRAIT',	'MODIFIER_CSE_MARITIME_SEAPORT_GOLD' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
-----------------------------------------------
-- Modifiers
-----------------------------------------------
--Agricultural
UPDATE Modifiers SET ModifierType = 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_CHANGE'
WHERE ModifierId = 'MODIFIER_CSE_AGRICULTURAL_GRANARY_FOOD_MOD' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE Modifiers SET ModifierType = 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_CHANGE', SubjectRequirementSetId = 'GOLDEN_CITY_HAS_TEN_POPULATION_REQUIREMENTS'
WHERE ModifierId = 'MODIFIER_CSE_AGRICULTURAL_SEWER_FOOD_MOD' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE Modifiers SET ModifierType = 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_CHANGE', SubjectRequirementSetId = 'GOLDEN_CITY_HAS_TWENTY_POPULATION_REQUIREMENTS'
WHERE ModifierId = 'MODIFIER_CSE_AGRICULTURAL_FOOD_MARKET_FOOD_MOD' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
--Cultural
UPDATE Modifiers SET SubjectRequirementSetId = 'GOLDEN_CITY_HAS_TEN_POPULATION_REQUIREMENTS'
WHERE ModifierId = 'MODIFIER_CSE_CULTURAL_MUSEUM_ART_CULTURE_MOD' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE Modifiers SET SubjectRequirementSetId = 'GOLDEN_CITY_HAS_TEN_POPULATION_REQUIREMENTS'
WHERE ModifierId = 'MODIFIER_CSE_CULTURAL_MUSEUM_ARTIFACT_CULTURE_MOD' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE Modifiers SET SubjectRequirementSetId = 'GOLDEN_CITY_HAS_TWENTY_POPULATION_REQUIREMENTS'
WHERE ModifierId = 'MODIFIER_CSE_CULTURAL_BROADCAST_CENTER_CULTURE_MOD' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
-- Scientific
UPDATE Modifiers SET SubjectRequirementSetId = 'GOLDEN_CITY_HAS_TEN_POPULATION_REQUIREMENTS'
WHERE ModifierId = 'MODIFIER_CSE_SCIENTIFIC_UNIVERSITY_SCIENCE_MOD' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE Modifiers SET SubjectRequirementSetId = 'GOLDEN_CITY_HAS_TWENTY_POPULATION_REQUIREMENTS'
WHERE ModifierId = 'MODIFIER_CSE_SCIENTIFIC_RESEARCH_LAB_SCIENCE_MOD' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
-- Trade
UPDATE Modifiers SET SubjectRequirementSetId = 'GOLDEN_CITY_HAS_TEN_POPULATION_REQUIREMENTS'
WHERE ModifierId = 'MODIFIER_CSE_TRADE_BANK_GOLD_MOD' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE Modifiers SET SubjectRequirementSetId = 'GOLDEN_CITY_HAS_TWENTY_POPULATION_REQUIREMENTS'
WHERE ModifierId = 'MODIFIER_CSE_TRADE_STOCK_EXCHANGE_GOLD_MOD' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
-- Religious
UPDATE Modifiers SET SubjectRequirementSetId = 'GOLDEN_CITY_HAS_TEN_POPULATION_REQUIREMENTS'
WHERE ModifierId = 'MODIFIER_CSE_RELIGIOUS_TEMPLE_FAITH_MOD' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE Modifiers SET SubjectRequirementSetId = 'GOLDEN_CITY_HAS_TWENTY_POPULATION_REQUIREMENTS'
WHERE ModifierId = 'MODIFIER_CSE_RELIGIOUS_CATHEDRAL_FAITH_MOD' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE Modifiers SET SubjectRequirementSetId = 'GOLDEN_CITY_HAS_TWENTY_POPULATION_REQUIREMENTS'
WHERE ModifierId = 'MODIFIER_CSE_RELIGIOUS_DAR_E_MEHR_FAITH_MOD' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE Modifiers SET SubjectRequirementSetId = 'GOLDEN_CITY_HAS_TWENTY_POPULATION_REQUIREMENTS'
WHERE ModifierId = 'MODIFIER_CSE_RELIGIOUS_GURDWARA_FAITH_MOD' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE Modifiers SET SubjectRequirementSetId = 'GOLDEN_CITY_HAS_TWENTY_POPULATION_REQUIREMENTS'
WHERE ModifierId = 'MODIFIER_CSE_RELIGIOUS_MEETING_HOUSE_FAITH_MOD' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE Modifiers SET SubjectRequirementSetId = 'GOLDEN_CITY_HAS_TWENTY_POPULATION_REQUIREMENTS'
WHERE ModifierId = 'MODIFIER_CSE_RELIGIOUS_MOSQUE_FAITH_MOD' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE Modifiers SET SubjectRequirementSetId = 'GOLDEN_CITY_HAS_TWENTY_POPULATION_REQUIREMENTS'
WHERE ModifierId = 'MODIFIER_CSE_RELIGIOUS_PAGODA_FAITH_MOD' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE Modifiers SET SubjectRequirementSetId = 'GOLDEN_CITY_HAS_TWENTY_POPULATION_REQUIREMENTS'
WHERE ModifierId = 'MODIFIER_CSE_RELIGIOUS_STUPA_FAITH_MOD' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE Modifiers SET SubjectRequirementSetId = 'GOLDEN_CITY_HAS_TWENTY_POPULATION_REQUIREMENTS'
WHERE ModifierId = 'MODIFIER_CSE_RELIGIOUS_SYNAGOGUE_FAITH_MOD' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE Modifiers SET SubjectRequirementSetId = 'GOLDEN_CITY_HAS_TWENTY_POPULATION_REQUIREMENTS'
WHERE ModifierId = 'MODIFIER_CSE_RELIGIOUS_WAT_FAITH_MOD' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
--Consular
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'MODIFIER_CSE_CONSULAR_INFLUENCEPOINTS_SMALL',	'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 'PLAYER_HAS_SMALL_INFLUENCE' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'MODIFIER_CSE_CONSULAR_INFLUENCEPOINTS_SMALL_MOD',	'MODIFIER_PLAYER_ADJUST_INFLUENCE_POINTS_PER_TURN', NULL WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'MODIFIER_CSE_CONSULAR_INFLUENCEPOINTS_MEDIUM',	'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 'PLAYER_HAS_MEDIUM_INFLUENCE' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'MODIFIER_CSE_CONSULAR_INFLUENCEPOINTS_MEDIUM_MOD',	'MODIFIER_PLAYER_ADJUST_INFLUENCE_POINTS_PER_TURN', 'REQSET_CSE_PLAYER_HAS_GOV_TIER_1' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'MODIFIER_CSE_CONSULAR_INFLUENCEPOINTS_LARGE',	'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 'PLAYER_HAS_LARGE_INFLUENCE' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'MODIFIER_CSE_CONSULAR_INFLUENCEPOINTS_LARGE_MOD',	'MODIFIER_PLAYER_ADJUST_INFLUENCE_POINTS_PER_TURN', 'REQSET_CSE_PLAYER_HAS_GOV_TIER_2' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'MODIFIER_CSE_CONSULAR_INFLUENCEPOINTS_LARGEST',	'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 'PLAYER_HAS_LARGEST_INFLUENCE' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'MODIFIER_CSE_CONSULAR_INFLUENCEPOINTS_LARGEST_MOD',	'MODIFIER_PLAYER_ADJUST_INFLUENCE_POINTS_PER_TURN', 'REQSET_CSE_PLAYER_HAS_GOV_TIER_3' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
--Maritime
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'MODIFIER_CSE_MARITIME_CAPITAL_GOLD',	'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 'PLAYER_HAS_SMALL_INFLUENCE' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'MODIFIER_CSE_MARITIME_CAPITAL_GOLD_MOD',	'MODIFIER_PLAYER_CAPITAL_CITY_ADJUST_CITY_YIELD_CHANGE', NULL WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'MODIFIER_CSE_MARITIME_LIGHTHOUSE_GOLD',	'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 'PLAYER_HAS_MEDIUM_INFLUENCE' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'MODIFIER_CSE_MARITIME_LIGHTHOUSE_GOLD_MOD',	'MODIFIER_PLAYER_CITIES_ADJUST_BUILDING_YIELD_CHANGE', NULL WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'MODIFIER_CSE_MARITIME_SHIPYARD_GOLD',	'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 'PLAYER_HAS_LARGE_INFLUENCE' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'MODIFIER_CSE_MARITIME_SHIPYARD_GOLD_MOD',	'MODIFIER_PLAYER_CITIES_ADJUST_BUILDING_YIELD_CHANGE', NULL WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'MODIFIER_CSE_MARITIME_SEAPORT_GOLD',	'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 'PLAYER_HAS_LARGEST_INFLUENCE' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'MODIFIER_CSE_MARITIME_SEAPORT_GOLD_MOD',	'MODIFIER_PLAYER_CITIES_ADJUST_BUILDING_YIELD_CHANGE', NULL WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');

-----------------------------------------------
-- ModifierArguments
-----------------------------------------------
--Agricultural
DELETE FROM ModifierArguments WHERE ModifierId = 'MODIFIER_CSE_AGRICULTURAL_GRANARY_FOOD_MOD' AND Name = 'BuildingType' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType='MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
DELETE FROM ModifierArguments WHERE ModifierId = 'MODIFIER_CSE_AGRICULTURAL_SEWER_FOOD_MOD' AND Name = 'BuildingType' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType='MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
DELETE FROM ModifierArguments WHERE ModifierId = 'MODIFIER_CSE_AGRICULTURAL_FOOD_MARKET_FOOD_MOD' AND Name = 'BuildingType' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType='MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE ModifierArguments SET Value = 1
WHERE ModifierId = 'MODIFIER_CSE_AGRICULTURAL_GRANARY_FOOD_MOD' AND Name = 'Amount' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE ModifierArguments SET Value = 2
WHERE ModifierId = 'MODIFIER_CSE_AGRICULTURAL_SEWER_FOOD_MOD' AND Name = 'Amount' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE ModifierArguments SET Value = 3
WHERE ModifierId = 'MODIFIER_CSE_AGRICULTURAL_FOOD_MARKET_FOOD_MOD' AND Name = 'Amount' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
--Religious
UPDATE ModifierArguments SET Value = 1
WHERE ModifierId = 'MODIFIER_CSE_RELIGIOUS_SEND_TRADE_BONUS' AND Name = 'Amount' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE ModifierArguments SET Value = 2
WHERE ModifierId = 'MODIFIER_CSE_RELIGIOUS_CAPITAL_FAITH_MOD' AND Name = 'Amount' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE ModifierArguments SET Value = 2
WHERE ModifierId = 'MODIFIER_CSE_RELIGIOUS_SHRINE_FAITH_MOD' AND Name = 'Amount' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE ModifierArguments SET Value = 2
WHERE ModifierId = 'MODIFIER_CSE_RELIGIOUS_TEMPLE_FAITH_MOD' AND Name = 'Amount' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE ModifierArguments SET Value = 2
WHERE ModifierId = 'MODIFIER_CSE_RELIGIOUS_CATHEDRAL_FAITH_MOD' AND Name = 'Amount' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE ModifierArguments SET Value = 2
WHERE ModifierId = 'MODIFIER_CSE_RELIGIOUS_DAR_E_MEHR_FAITH_MOD' AND Name = 'Amount' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE ModifierArguments SET Value = 2
WHERE ModifierId = 'MODIFIER_CSE_RELIGIOUS_GURDWARA_FAITH_MOD' AND Name = 'Amount' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE ModifierArguments SET Value = 2
WHERE ModifierId = 'MODIFIER_CSE_RELIGIOUS_MEETING_HOUSE_FAITH_MOD' AND Name = 'Amount' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE ModifierArguments SET Value = 2
WHERE ModifierId = 'MODIFIER_CSE_RELIGIOUS_MOSQUE_FAITH_MOD' AND Name = 'Amount' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE ModifierArguments SET Value = 2
WHERE ModifierId = 'MODIFIER_CSE_RELIGIOUS_PAGODA_FAITH_MOD' AND Name = 'Amount' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE ModifierArguments SET Value = 2
WHERE ModifierId = 'MODIFIER_CSE_RELIGIOUS_SYNAGOGUE_FAITH_MOD' AND Name = 'Amount' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE ModifierArguments SET Value = 2
WHERE ModifierId = 'MODIFIER_CSE_RELIGIOUS_STUPA_FAITH_MOD' AND Name = 'Amount' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE ModifierArguments SET Value = 2
WHERE ModifierId = 'MODIFIER_CSE_RELIGIOUS_WAT_FAITH_MOD' AND Name = 'Amount' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
--Consular
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'MODIFIER_CSE_CONSULAR_INFLUENCEPOINTS_SMALL',	'ModifierId', 'MODIFIER_CSE_CONSULAR_INFLUENCEPOINTS_SMALL_MOD' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'MODIFIER_CSE_CONSULAR_INFLUENCEPOINTS_SMALL_MOD',	'Amount', 1 WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'MODIFIER_CSE_CONSULAR_INFLUENCEPOINTS_MEDIUM',	'ModifierId', 'MODIFIER_CSE_CONSULAR_INFLUENCEPOINTS_MEDIUM_MOD' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'MODIFIER_CSE_CONSULAR_INFLUENCEPOINTS_MEDIUM_MOD',	'Amount', 1 WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'MODIFIER_CSE_CONSULAR_INFLUENCEPOINTS_LARGE',	'ModifierId', 'MODIFIER_CSE_CONSULAR_INFLUENCEPOINTS_LARGE_MOD' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'MODIFIER_CSE_CONSULAR_INFLUENCEPOINTS_LARGE_MOD',	'Amount', 1 WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'MODIFIER_CSE_CONSULAR_INFLUENCEPOINTS_LARGEST',	'ModifierId', 'MODIFIER_CSE_CONSULAR_INFLUENCEPOINTS_LARGEST_MOD' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'MODIFIER_CSE_CONSULAR_INFLUENCEPOINTS_LARGEST_MOD',	'Amount', 1 WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
--Maritime
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'MODIFIER_CSE_MARITIME_CAPITAL_GOLD',	'ModifierId', 'MODIFIER_CSE_MARITIME_CAPITAL_GOLD_MOD' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'MODIFIER_CSE_MARITIME_CAPITAL_GOLD_MOD',	'Amount', 1 WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'MODIFIER_CSE_MARITIME_CAPITAL_GOLD_MOD',	'YieldType', 'YIELD_GOLD' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'MODIFIER_CSE_MARITIME_LIGHTHOUSE_GOLD',	'ModifierId', 'MODIFIER_CSE_MARITIME_LIGHTHOUSE_GOLD_MOD' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'MODIFIER_CSE_MARITIME_LIGHTHOUSE_GOLD_MOD',	'Amount', 1 WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'MODIFIER_CSE_MARITIME_LIGHTHOUSE_GOLD_MOD',	'YieldType', 'YIELD_GOLD' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'MODIFIER_CSE_MARITIME_LIGHTHOUSE_GOLD_MOD',	'BuildingType', 'BUILDING_LIGHTHOUSE' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'MODIFIER_CSE_MARITIME_SHIPYARD_GOLD',	'ModifierId', 'MODIFIER_CSE_MARITIME_SHIPYARD_GOLD_MOD' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'MODIFIER_CSE_MARITIME_SHIPYARD_GOLD_MOD',	'Amount', 1 WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'MODIFIER_CSE_MARITIME_SHIPYARD_GOLD_MOD',	'YieldType', 'YIELD_GOLD' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'MODIFIER_CSE_MARITIME_SHIPYARD_GOLD_MOD',	'BuildingType', 'BUILDING_SHIPYARD' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'MODIFIER_CSE_MARITIME_SEAPORT_GOLD',	'ModifierId', 'MODIFIER_CSE_MARITIME_SEAPORT_GOLD_MOD' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'MODIFIER_CSE_MARITIME_SEAPORT_GOLD_MOD',	'Amount', 1 WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'MODIFIER_CSE_MARITIME_SEAPORT_GOLD_MOD',	'YieldType', 'YIELD_GOLD' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'MODIFIER_CSE_MARITIME_SEAPORT_GOLD_MOD',	'BuildingType', 'BUILDING_SEAPORT' WHERE EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
--Trade
UPDATE ModifierArguments SET Value = 1
WHERE ModifierId = 'MODIFIER_CSE_TRADE_SEND_TRADE_BONUS' AND Name = 'Amount' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE ModifierArguments SET Value = 2
WHERE ModifierId = 'MODIFIER_CSE_TRADE_CAPITAL_GOLD_MOD' AND Name = 'Amount' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE ModifierArguments SET Value = 2
WHERE ModifierId = 'MODIFIER_CSE_TRADE_MARKET_GOLD_MOD' AND Name = 'Amount' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE ModifierArguments SET Value = 2
WHERE ModifierId = 'MODIFIER_CSE_TRADE_BANK_GOLD_MOD' AND Name = 'Amount' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');
UPDATE ModifierArguments SET Value = 2
WHERE ModifierId = 'MODIFIER_CSE_TRADE_STOCK_EXCHANGE_GOLD_MOD' AND Name = 'Amount' AND EXISTS (SELECT TraitType FROM TraitModifiers WHERE TraitType = 'MINOR_CIV_CSE_AGRICULTURAL_TRAIT');