--------------------------------------------------------------
-- TechnologyPrereqs
--------------------------------------------------------------
DELETE FROM TechnologyPrereqs WHERE Technology = 'TECH_ASTRONOMY' AND PrereqTech = 'TECH_MASS_PRODUCTION' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_COMPOSITE_BOWMAN');
--------------------------------------------------------------
-- UnitUpgrades
--------------------------------------------------------------
UPDATE UnitUpgrades SET UpgradeUnit = 'UNIT_IRONCLAD'
WHERE Unit = 'UNIT_CARAVEL' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
DELETE FROM UnitUpgrades WHERE Unit = 'UNIT_CORVETTE' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_COMPOSITE_BOWMAN');
--------------------------------------------------------------
-- UnitReplaces
--------------------------------------------------------------
INSERT OR REPLACE INTO UnitReplaces (CivUniqueUnitType, ReplacesUnitType)
SELECT	'UNIT_INDIAN_VARU',	'UNIT_ARMORED_HORSEMAN' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
--------------------------------------------------------------
-- Types
--------------------------------------------------------------
DELETE FROM Types WHERE Type = 'UNIT_UAV' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_COMPOSITE_BOWMAN') AND NOT EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_STRADIOT');
DELETE FROM Types WHERE Type = 'UNIT_INDUSTRIAL_MARINE' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_COMPOSITE_BOWMAN');
DELETE FROM Types WHERE Type = 'UNIT_WW2_MARINE' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_COMPOSITE_BOWMAN');
DELETE FROM Types WHERE Type = 'UNIT_MODERN_MARINE' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_COMPOSITE_BOWMAN');
-- DELETE FROM Types WHERE Type = 'UNIT_ARQUEBUSIER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_COMPOSITE_BOWMAN');
-- DELETE FROM Types WHERE Type = 'UNIT_AXE_THROWER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_COMPOSITE_BOWMAN');
-- DELETE FROM Types WHERE Type = 'UNIT_PELTAST' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_COMPOSITE_BOWMAN');
-- DELETE FROM Types WHERE Type = 'UNIT_GATLING_GUN' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_COMPOSITE_BOWMAN');
-- DELETE FROM Types WHERE Type = 'UNIT_AT_CREW' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_COMPOSITE_BOWMAN');
-- DELETE FROM Types WHERE Type = 'UNIT_MODERN_AT' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_COMPOSITE_BOWMAN');
-- DELETE FROM Types WHERE Type = 'UNIT_MACHINE_GUN' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_COMPOSITE_BOWMAN');
DELETE FROM Types WHERE Type = 'UNIT_ATTACK_SUBMARINE' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_COMPOSITE_BOWMAN');
DELETE FROM Types WHERE Type = 'UNIT_CORVETTE' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_COMPOSITE_BOWMAN');
--------------------------------------------------------------
-- TypeTags
--------------------------------------------------------------
DELETE FROM TypeTags WHERE Type = 'UNIT_ARMORED_INFANTRY' AND Tag = 'CLASS_MELEE' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_COMPOSITE_BOWMAN');
DELETE FROM TypeTags WHERE Type = 'UNIT_MOUNTED_RIFLES' AND Tag = 'CLASS_MELEE' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_COMPOSITE_BOWMAN');
--------------------------------------------------------------
-- Units
--------------------------------------------------------------
--陆地近战单位
UPDATE Units SET BaseSightRange = 1
WHERE PromotionClass = 'PROMOTION_CLASS_MELEE' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 40, Combat = 27
WHERE UnitType = 'UNIT_WARRIOR' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 90, Combat = 37, MandatoryObsoleteTech = 'TECH_MILITARY_TACTICS'
WHERE UnitType = 'UNIT_SWORDSMAN' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 140, Combat = 47, PrereqTech = 'TECH_MILITARY_TACTICS', Maintenance = 3
WHERE UnitType = 'UNIT_LONGSWORDSMAN' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 190, Combat = 57
WHERE UnitType = 'UNIT_MUSKETMAN' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 240, Combat = 67, Maintenance = 5
WHERE UnitType = 'UNIT_RIFLEMAN' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 290, Combat = 77, StrategicResource='RESOURCE_NITER', MandatoryObsoleteTech = 'TECH_COMBINED_ARMS', Maintenance = 6
WHERE UnitType = 'UNIT_WW1_INFANTRY' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 340, Combat = 87, StrategicResource='RESOURCE_NITER', PrereqTech = 'TECH_COMBINED_ARMS', Maintenance = 7, Description = 'LOC_UNIT_INFANTRY_DESCRIPTION_GA_WE'
WHERE UnitType = 'UNIT_INFANTRY' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 390, Combat = 97, StrategicResource='RESOURCE_NITER', Maintenance = 8
WHERE UnitType = 'UNIT_MODERN_INFANTRY' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
--陆地轻骑兵单位
UPDATE Units SET Cost = 100, Combat = 35
WHERE UnitType = 'UNIT_HORSEMAN' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 160, Combat = 45
WHERE UnitType = 'UNIT_COURSER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 220, Combat = 55, StrategicResource='RESOURCE_HORSES', Maintenance = 4
WHERE UnitType = 'UNIT_HARQUEBUSIER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN') AND NOT EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_STRADIOT');
UPDATE Units SET Cost = 280, Combat = 65, MandatoryObsoleteTech = 'TECH_COMBUSTION'
WHERE UnitType = 'UNIT_CAVALRY' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 340, Combat = 75, PrereqTech = 'TECH_COMBUSTION', StrategicResource='RESOURCE_HORSES', MandatoryObsoleteTech = 'TECH_SYNTHETIC_MATERIALS'
WHERE UnitType = 'UNIT_MOUNTED_RIFLES' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 400, Combat = 85, PrereqTech = 'TECH_SYNTHETIC_MATERIALS'
WHERE UnitType = 'UNIT_ARMORED_INFANTRY' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 460, Combat = 95, StrategicResource='RESOURCE_OIL', Description = 'LOC_UNIT_MECHANIZED_INFANTRY_DESCRIPTION_GA_WE'
WHERE UnitType = 'UNIT_MECHANIZED_INFANTRY' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
--陆地重骑兵单位
UPDATE Units SET Cost = 80, Combat = 30
WHERE UnitType = 'UNIT_HEAVY_CHARIOT' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 130, Combat = 40
WHERE UnitType = 'UNIT_ARMORED_HORSEMAN' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 200, Combat = 50, MandatoryObsoleteTech = 'TECH_METAL_CASTING'
WHERE UnitType = 'UNIT_KNIGHT' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 270, Combat = 60, StrategicResource='RESOURCE_HORSES', MandatoryObsoleteTech = 'TECH_MILITARY_SCIENCE'
WHERE UnitType = 'UNIT_REITER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 340, Combat = 70, MandatoryObsoleteTech = 'TECH_COMBUSTION'
WHERE UnitType = 'UNIT_CUIRASSIER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 410, Combat = 80, MandatoryObsoleteTech = 'TECH_SYNTHETIC_MATERIALS'
WHERE UnitType = 'UNIT_LANDSHIP' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 480, Combat = 90
WHERE UnitType = 'UNIT_TANK' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 550, Combat = 100
WHERE UnitType = 'UNIT_MODERN_ARMOR' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
--陆地抗骑兵单位
UPDATE Units SET BaseSightRange = 1
WHERE PromotionClass = 'PROMOTION_CLASS_ANTI_CAVALRY' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 40, Combat = 23
WHERE UnitType = 'UNIT_SPEARMAN' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 90, Combat = 33
WHERE UnitType = 'UNIT_HEAVY_INFANTRY' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 140, Combat = 43
WHERE UnitType = 'UNIT_PIKEMAN' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 190, Combat = 53, MandatoryObsoleteTech = 'TECH_RIFLING'
WHERE UnitType = 'UNIT_PIKE_AND_SHOT' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 240, Combat = 63, PrereqTech = 'TECH_RIFLING', Maintenance = 5
WHERE UnitType = 'UNIT_LINE_INFANTRY' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 290, Combat = 73, RangedCombat = 0, Range = 0, MandatoryObsoleteTech = 'TECH_ADVANCED_BALLISTICS', Maintenance = 6
WHERE UnitType = 'UNIT_ANTI_TANK_RIFLE' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 340, Combat = 83, RangedCombat = 0, Range = 0, PrereqTech = 'TECH_ADVANCED_BALLISTICS', MandatoryObsoleteTech = 'TECH_COMPOSITES', Maintenance = 7
WHERE UnitType = 'UNIT_ANTI_TANK_GUN' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 390, Combat = 93, BaseMoves = 2, RangedCombat = 0, Range = 0, PrereqTech = 'TECH_COMPOSITES', Maintenance = 8, Description = 'LOC_UNIT_HELICOPTER_DESCRIPTION_GA_WE'
WHERE UnitType = 'UNIT_HELICOPTER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
--陆地远程单位
UPDATE Units SET BaseSightRange = 1
WHERE PromotionClass = 'PROMOTION_CLASS_RANGED' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 50, Combat = 10, RangedCombat = 20, MandatoryObsoleteTech = 'TECH_CURRENCY', Description = 'LOC_UNIT_ARCHER_DESCRIPTION_GA_WE'
WHERE UnitType = 'UNIT_ARCHER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 100, Combat = 20, RangedCombat = 30, PrereqTech = 'TECH_CURRENCY', MandatoryObsoleteTech = 'TECH_APPRENTICESHIP'
WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 150, Combat = 30, RangedCombat = 40, MandatoryObsoleteTech = 'TECH_PRINTING', Description = 'LOC_UNIT_CROSSBOWMAN_DESCRIPTION_GA_WE'
WHERE UnitType = 'UNIT_CROSSBOWMAN' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 200, Combat = 40, RangedCombat = 50, PrereqTech = 'TECH_PRINTING', MandatoryObsoleteTech = 'TECH_SCIENTIFIC_THEORY'
WHERE UnitType = 'UNIT_CULVERIN' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 250, Combat = 50, RangedCombat = 60, MandatoryObsoleteTech = 'TECH_REFINING', Description = 'LOC_UNIT_FIELD_CANNON_DESCRIPTION_GA_WE'
WHERE UnitType = 'UNIT_FIELD_CANNON' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 300, Combat = 60, RangedCombat = 70, PrereqTech = 'TECH_REFINING', MandatoryObsoleteTech = 'TECH_ADVANCED_BALLISTICS'
WHERE UnitType = 'UNIT_FIELD_GUN' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 350, Combat = 70, RangedCombat = 80, PrereqTech = 'TECH_ADVANCED_BALLISTICS', MandatoryObsoleteTech = 'TECH_GUIDANCE_SYSTEMS'
WHERE UnitType = 'UNIT_FIELD_HOWITZER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 400, Combat = 80, RangedCombat = 90, PrereqTech = 'TECH_GUIDANCE_SYSTEMS'
WHERE UnitType = 'UNIT_FIELD_ARTILLERY' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
--陆地火力支援
UPDATE Units SET BaseSightRange = 1
WHERE PromotionClass = 'PROMOTION_CLASS_AUTOMATIC_GUN' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 50, Combat = 20, RangedCombat = 20, Range = 1, Description = 'LOC_UNIT_SLINGER_DESCRIPTION_GA_WE'
WHERE UnitType = 'UNIT_SLINGER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 100, Combat = 30, RangedCombat = 30
WHERE UnitType = 'UNIT_PELTAST' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 150, Combat = 40, RangedCombat = 40
WHERE UnitType = 'UNIT_AXE_THROWER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 200, Combat = 50, RangedCombat = 50, MandatoryObsoleteTech = 'TECH_RIFLING', Maintenance = 4
WHERE UnitType = 'UNIT_ARQUEBUSIER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 250, Combat = 60, RangedCombat = 60, PrereqTech = 'TECH_RIFLING', Maintenance = 5
WHERE UnitType = 'UNIT_GATLING_GUN' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 300, Combat = 70, RangedCombat = 70, MandatoryObsoleteTech = 'TECH_ADVANCED_BALLISTICS', Maintenance = 6, Description = 'LOC_UNIT_MACHINE_GUN_DESCRIPTION_GA_WE'
WHERE UnitType = 'UNIT_MACHINE_GUN' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 350, Combat = 80, RangedCombat = 80, PrereqTech = 'TECH_ADVANCED_BALLISTICS', MandatoryObsoleteTech = 'TECH_GUIDANCE_SYSTEMS', Maintenance = 7, Description = 'LOC_UNIT_AT_CREW_DESCRIPTION_GA_WE'
WHERE UnitType = 'UNIT_AT_CREW' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 400, Combat = 90, RangedCombat = 90, PrereqTech = 'TECH_GUIDANCE_SYSTEMS', Maintenance = 8, Description = 'LOC_UNIT_MODERN_AT_DESCRIPTION_GA_WE'
WHERE UnitType = 'UNIT_MODERN_AT' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
--陆地攻城单位
UPDATE Units SET BaseSightRange = 1
WHERE PromotionClass = 'PROMOTION_CLASS_SIEGE' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 130, Combat = 15, Bombard = 35, MandatoryObsoleteTech = 'TECH_CASTLES', BaseMoves = 1
WHERE UnitType = 'UNIT_CATAPULT' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 200, Combat = 25, Bombard = 45, Range = 3, StrategicResource='RESOURCE_IRON', PrereqTech = 'TECH_CASTLES', MandatoryObsoleteTech = 'TECH_SIEGE_TACTICS', BaseMoves = 1
WHERE UnitType = 'UNIT_TREBUCHET' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 270, Combat = 35, Bombard = 55, MandatoryObsoleteTech = 'TECH_BALLISTICS', BaseMoves = 1
WHERE UnitType = 'UNIT_BOMBARD' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 340, Combat = 45, Bombard = 65, Range = 3, StrategicResource='RESOURCE_IRON', PrereqTech = 'TECH_BALLISTICS', BaseMoves = 1
WHERE UnitType = 'UNIT_RIFLED_CANNON' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 410, Combat = 45, Bombard = 65, MandatoryObsoleteTech = 'TECH_COMBINED_ARMS', BaseMoves = 1
WHERE UnitType = 'UNIT_ARTILLERY' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 480, Combat = 85, Bombard = 105, Range = 3, StrategicResource='RESOURCE_IRON', PrereqTech = 'TECH_COMBINED_ARMS', BaseMoves = 1
WHERE UnitType = 'UNIT_HEAVY_HOWITZER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 550, Combat = 95, Bombard = 115, BaseMoves = 1
WHERE UnitType = 'UNIT_ROCKET_ARTILLERY' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
--海军近战单位
UPDATE Units SET Cost = 40, Combat = 30, BaseMoves = 2
WHERE UnitType = 'UNIT_GALLEY' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 140, Combat = 50, BaseMoves = 3, Maintenance = 3, PrereqTech = 'TECH_APPRENTICESHIP', MandatoryObsoleteTech = 'TECH_CARTOGRAPHY'
WHERE UnitType = 'UNIT_COG' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 190, Combat = 60, BaseMoves = 4
WHERE UnitType = 'UNIT_CARAVEL' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 240, Combat = 70, BaseMoves = 5, MandatoryObsoleteTech = 'TECH_REFINING'
WHERE UnitType = 'UNIT_IRONCLAD' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 290, Combat = 80, BaseMoves = 6, PrereqTech = 'TECH_REFINING', MandatoryObsoleteTech = 'TECH_ADVANCED_FLIGHT'
WHERE UnitType = 'UNIT_TORPEDO_GUNBOAT' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 340, Combat = 90, BaseMoves = 7, MandatoryObsoleteTech = 'TECH_SATELLITES', AntiAirCombat = 90
WHERE UnitType = 'UNIT_DESTROYER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 390, Combat = 100, BaseMoves = 8, StrategicResource='RESOURCE_URANIUM', PrereqTech = 'TECH_SATELLITES', AntiAirCombat = 100
WHERE UnitType = 'UNIT_MISSILE_DESTROYER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN') AND NOT EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_STRADIOT');
--海军远程单位
UPDATE Units SET Cost = 100, BaseMoves = 2, Range = 1, Combat = 20, RangedCombat = 35
WHERE UnitType = 'UNIT_QUADRIREME' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 150, BaseMoves = 2, Range = 2, Combat = 30, RangedCombat = 45
WHERE UnitType = 'UNIT_GALLEASS' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 200, BaseMoves = 3, Range = 2, Combat = 40, RangedCombat = 55
WHERE UnitType = 'UNIT_FRIGATE' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 250, BaseMoves = 3, Range = 3, Combat = 50, RangedCombat = 65
WHERE UnitType = 'UNIT_ARMORED_CRUISER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 300, BaseMoves = 4, Range = 3, Combat = 60, RangedCombat = 75, Maintenance = 6
WHERE UnitType = 'UNIT_LIGHT_CRUISER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 350, BaseMoves = 4, Range = 4, Combat = 70, RangedCombat = 85, StrategicResource='RESOURCE_ALUMINUM', Maintenance = 7, AntiAirCombat = 110
WHERE UnitType = 'UNIT_BATTLECRUISER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 400, BaseMoves = 5, Range = 4, Combat = 80, RangedCombat = 95, AntiAirCombat = 120
WHERE UnitType = 'UNIT_MISSILE_CRUISER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN') AND NOT EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_STRADIOT');
--海军轰炸单位
UPDATE Units SET Cost = 130, BaseMoves = 2, Range = 1, Combat = 20, Bombard = 35, Maintenance = 2
WHERE UnitType = 'UNIT_GREEK_FIRE_SHIP' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 200, BaseMoves = 2, Range = 2, Combat = 30, Bombard = 45, Maintenance = 3
WHERE UnitType = 'UNIT_GALLEON' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 270, BaseMoves = 3, Range = 2, Combat = 40, Bombard = 55
WHERE UnitType = 'UNIT_SHIP_OF_THE_LINE' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 340, BaseMoves = 3, Range = 3, Combat = 50, Bombard = 65
WHERE UnitType = 'UNIT_PRE_DREADNOUGHT' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 410, BaseMoves = 4, Range = 3, Combat = 60, Bombard = 75
WHERE UnitType = 'UNIT_DREADNOUGHT' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 480, BaseMoves = 4, Range = 4, Combat = 70, Bombard = 85, AntiAirCombat = 70
WHERE UnitType = 'UNIT_BATTLESHIP' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 550, BaseMoves = 5, Range = 4, Combat = 80, Bombard = 95, StrategicResource='RESOURCE_URANIUM', AntiAirCombat = 80
WHERE UnitType = 'UNIT_RAILGUN_WARSHIP' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN') AND NOT EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_STRADIOT');
--海军突袭单位
UPDATE Units SET Cost = 200, BaseMoves = 4, Combat = 50, RangedCombat = 50
WHERE UnitType = 'UNIT_PRIVATEER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 250, BaseMoves = 5, Combat = 60, RangedCombat = 60
WHERE UnitType = 'UNIT_RAIDER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 300, BaseMoves = 6, Combat = 70, RangedCombat = 70
WHERE UnitType = 'UNIT_SUBMARINE' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 400, BaseMoves = 7, Combat = 80, RangedCombat = 80
WHERE UnitType = 'UNIT_NUCLEAR_SUBMARINE' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
--航母单位
UPDATE Units SET Cost = 550
WHERE UnitType = 'UNIT_SUPERCARRIER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Description = 'LOC_UNIT_AIRCRAFT_CARRIER_DESCRIPTION_GA_WE'
WHERE UnitType = 'UNIT_AIRCRAFT_CARRIER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
--飞机
UPDATE Units SET Cost = 300, BaseMoves = 6, Range = 6, Combat = 85, RangedCombat = 65
WHERE UnitType = 'UNIT_BIPLANE' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 410, BaseMoves = 6, Range = 6, Combat = 65, Bombard = 85, StrategicResource='RESOURCE_OIL'
WHERE UnitType = 'UNIT_WW1_BOMBER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 360, BaseMoves = 6, Range = 6, Combat = 65, RangedCombat = 85, StrategicResource='RESOURCE_OIL'
WHERE UnitType = 'UNIT_WW1_GROUND_ATTACK' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 350, BaseMoves = 9, Range = 9, Combat = 95, RangedCombat = 75
WHERE UnitType = 'UNIT_FIGHTER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 480, BaseMoves = 9, Range = 9, Combat = 75, Bombard = 95
WHERE UnitType = 'UNIT_BOMBER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 420, BaseMoves = 9, Range = 9, Combat = 75, RangedCombat = 95
WHERE UnitType = 'UNIT_GROUND_ATTACK' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 400, BaseMoves = 12, Range = 12, Combat = 105, RangedCombat = 85, MandatoryObsoleteTech = 'TECH_ADVANCED_AI'
WHERE UnitType = 'UNIT_JET_FIGHTER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 550, BaseMoves = 12, Range = 12, Combat = 85, Bombard = 105, MandatoryObsoleteTech = 'TECH_ADVANCED_POWER_CELLS'
WHERE UnitType = 'UNIT_JET_BOMBER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 480, BaseMoves = 12, Range = 12, Combat = 85, RangedCombat = 105, MandatoryObsoleteTech = 'TECH_PREDICTIVE_SYSTEMS'
WHERE UnitType = 'UNIT_JET_GROUND_ATTACK' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 450, BaseMoves = 15, Range = 15, Combat = 115, RangedCombat = 95, PrereqTech = 'TECH_ADVANCED_AI', Maintenance = 9
WHERE UnitType = 'UNIT_STEALTH_FIGHTER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 620, BaseMoves = 15, Range = 15, Combat = 95, Bombard = 115, PrereqTech = 'TECH_ADVANCED_POWER_CELLS', Maintenance = 9
WHERE UnitType = 'UNIT_STEALTH_BOMBER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units SET Cost = 540, BaseMoves = 15, Range = 15, Combat = 95, RangedCombat = 115, PrereqTech = 'TECH_PREDICTIVE_SYSTEMS', Maintenance = 9
WHERE UnitType = 'UNIT_STEALTH_ATTACK' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
--------------------------------------------------------------
-- Units_XP2
--------------------------------------------------------------
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_IRON", ResourceMaintenanceAmount= 1
WHERE UnitType ='UNIT_LONGSWORDSMAN' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 20, ResourceMaintenanceType="RESOURCE_HORSES", ResourceMaintenanceAmount= 2
WHERE UnitType ='UNIT_REITER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_NITER", ResourceMaintenanceAmount= 1
WHERE UnitType ='UNIT_RIFLEMAN' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_NITER", ResourceMaintenanceAmount= 1
WHERE UnitType ='UNIT_GALLEASS' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_NITER", ResourceMaintenanceAmount= 1
WHERE UnitType ='UNIT_GALLEON' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_NITER", ResourceMaintenanceAmount= 1
WHERE UnitType ='UNIT_SHIP_OF_THE_LINE' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_IRON", ResourceMaintenanceAmount= 1
WHERE UnitType ='UNIT_RIFLED_CANNON' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 20, ResourceMaintenanceType="RESOURCE_HORSES", ResourceMaintenanceAmount= 2
WHERE UnitType ='UNIT_ARMORED_HORSEMAN' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_HORSES", ResourceMaintenanceAmount= 1
WHERE UnitType ='UNIT_HARQUEBUSIER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_HORSES", ResourceMaintenanceAmount= 1
WHERE UnitType ='UNIT_MOUNTED_RIFLES' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 20, ResourceMaintenanceType="RESOURCE_OIL", ResourceMaintenanceAmount= 2
WHERE UnitType ='UNIT_LANDSHIP' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_OIL", ResourceMaintenanceAmount= 1
WHERE UnitType ='UNIT_ARMORED_INFANTRY' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_IRON", ResourceMaintenanceAmount= 1
WHERE UnitType ='UNIT_HEAVY_HOWITZER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_COAL", ResourceMaintenanceAmount= 1
WHERE UnitType ='UNIT_TORPEDO_GUNBOAT' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_COAL", ResourceMaintenanceAmount= 1
WHERE UnitType ='UNIT_ARMORED_CRUISER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_COAL", ResourceMaintenanceAmount= 1
WHERE UnitType ='UNIT_PRE_DREADNOUGHT' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_COAL", ResourceMaintenanceAmount= 1
WHERE UnitType ='UNIT_LIGHT_CRUISER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_COAL", ResourceMaintenanceAmount= 1
WHERE UnitType ='UNIT_DREADNOUGHT' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_URANIUM", ResourceMaintenanceAmount= 1
WHERE UnitType ='UNIT_RAILGUN_WARSHIP' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_URANIUM", ResourceMaintenanceAmount= 1
WHERE UnitType ='UNIT_MISSILE_DESTROYER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_URANIUM", ResourceMaintenanceAmount= 1, CanEarnExperience = 0
WHERE UnitType ='UNIT_SUPERCARRIER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_OIL", ResourceMaintenanceAmount= 1, CanEarnExperience = 0
WHERE UnitType ='UNIT_AIRCRAFT_CARRIER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_ALUMINUM", ResourceMaintenanceAmount= 1
WHERE UnitType ='UNIT_GROUND_ATTACK' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_ALUMINUM", ResourceMaintenanceAmount= 1
WHERE UnitType ='UNIT_JET_GROUND_ATTACK' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_ALUMINUM", ResourceMaintenanceAmount= 1
WHERE UnitType ='UNIT_BATTLECRUISER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_OIL", ResourceMaintenanceAmount= 1
WHERE UnitType ='UNIT_WW1_BOMBER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_OIL", ResourceMaintenanceAmount= 1
WHERE UnitType ='UNIT_WW1_GROUND_ATTACK' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_OIL", ResourceMaintenanceAmount= 1
WHERE UnitType ='UNIT_MECHANIZED_INFANTRY' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_ALUMINUM", ResourceMaintenanceAmount= 1
WHERE UnitType ='UNIT_STEALTH_FIGHTER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_ALUMINUM", ResourceMaintenanceAmount= 1
WHERE UnitType ='UNIT_STEALTH_BOMBER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE Units_XP2 SET ResourceCost= 10, ResourceMaintenanceType="RESOURCE_ALUMINUM", ResourceMaintenanceAmount= 1
WHERE UnitType ='UNIT_STEALTH_ATTACK' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO Units_XP2
		(UnitType, ResourceCost, ResourceMaintenanceType, ResourceMaintenanceAmount)
SELECT	'UNIT_WW1_INFANTRY', 10, 'RESOURCE_NITER', 1 WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO Units_XP2
		(UnitType, ResourceCost, ResourceMaintenanceType, ResourceMaintenanceAmount)
SELECT	'UNIT_MODERN_INFANTRY', 10, 'RESOURCE_NITER', 1 WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO Units_XP2
		(UnitType, ResourceCost, ResourceMaintenanceType, ResourceMaintenanceAmount)
SELECT	'UNIT_TREBUCHET', 10, 'RESOURCE_IRON', 1 WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO Units_XP2
		(UnitType, ResourceCost, ResourceMaintenanceType, ResourceMaintenanceAmount)
SELECT	'UNIT_INFANTRY', 10, 'RESOURCE_NITER', 1 WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
-----------------------------------------------
-- UnitAbilities
-----------------------------------------------
DELETE FROM Types WHERE Type = 'ABILITY_NAVAL_BOMBARD' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_COMPOSITE_BOWMAN');
DELETE FROM Types WHERE Type = 'ABILITY_MARINE' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_COMPOSITE_BOWMAN');
DELETE FROM Types WHERE Type = 'ABILITY_ATTACK_SUB_RAIDER' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_COMPOSITE_BOWMAN');
DELETE FROM Types WHERE Type = 'ABILITY_ATTACK_SUB_SURFACE_WARSHIP' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_COMPOSITE_BOWMAN');
DELETE FROM Types WHERE Type = 'ABILITY_AUTOMATIC_GUNFIRE' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_COMPOSITE_BOWMAN');
DELETE FROM Types WHERE Type = 'ABILITY_LK_AUTOMATIC_GUN_CAV' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_COMPOSITE_BOWMAN') AND NOT EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_STRADIOT');
DELETE FROM Types WHERE Type = 'ABILITY_LK_AUTOMATIC_GUN_ANTICAV' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_COMPOSITE_BOWMAN');
DELETE FROM Types WHERE Type = 'ABILITY_LK_AUTOMATIC_GUN_MELEE' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_COMPOSITE_BOWMAN');
--------------------------------------------------------------
--Policy
--ModifierArguments
--------------------------------------------------------------
UPDATE ModifierArguments SET Value = 50
WHERE ModifierId ='MARITIMIEINDUSTRIES_ANCIENT_NAVAL_BOMBARD_PRODUCTION' AND Name = 'Amount' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE ModifierArguments SET Value = 50
WHERE ModifierId ='MARITIMIEINDUSTRIES_CLASSICAL_NAVAL_BOMBARD_PRODUCTION' AND Name = 'Amount' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE ModifierArguments SET Value = 50
WHERE ModifierId ='PRESSGANGS_MEDIEVAL_NAVAL_BOMBARD_PRODUCTION' AND Name = 'Amount' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE ModifierArguments SET Value = 50
WHERE ModifierId ='PRESSGANGS_RENAISSANCE_NAVAL_BOMBARD_PRODUCTION' AND Name = 'Amount' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE ModifierArguments SET Value = 50
WHERE ModifierId ='PRESSGANGS_INDUSTRIAL_NAVAL_BOMBARD_PRODUCTION' AND Name = 'Amount' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE ModifierArguments SET Value = 50
WHERE ModifierId ='INTERNATIONALWATERS_MODERN_NAVAL_BOMBARD_PRODUCTION' AND Name = 'Amount' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE ModifierArguments SET Value = 50
WHERE ModifierId ='INTERNATIONALWATERS_ATOMIC_NAVAL_BOMBARD_PRODUCTION' AND Name = 'Amount' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
UPDATE ModifierArguments SET Value = 50
WHERE ModifierId ='INTERNATIONALWATERS_INFORMATION_NAVAL_BOMBARD_PRODUCTION' AND Name = 'Amount' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
--------------------------------------------------------------
-- RequirementSetRequirements
--------------------------------------------------------------
--------------------------------------------------------------
-- TypeTags
--------------------------------------------------------------
INSERT OR REPLACE INTO Tags (Tag,							Vocabulary) VALUES
('CLASS_TRUE_RANGED',				            'ABILITY_CLASS');
INSERT OR REPLACE INTO TypeTags (Type,							Tag) VALUES
('UNIT_ARCHER',				            'CLASS_TRUE_RANGED'),
('UNIT_CROSSBOWMAN',				    'CLASS_TRUE_RANGED'),
('UNIT_FIELD_CANNON',				    'CLASS_TRUE_RANGED'),
('UNIT_CHINESE_CROUCHING_TIGER',		'CLASS_TRUE_RANGED'),
('UNIT_KOREAN_HWACHA',		            'CLASS_TRUE_RANGED');
INSERT OR REPLACE INTO TypeTags	(Type, Tag)
SELECT	'UNIT_NUBIAN_PITATI', 'CLASS_TRUE_RANGED' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_NUBIAN_PITATI');
INSERT OR REPLACE INTO TypeTags	(Type, Tag)
SELECT	'UNIT_COMPOSITE_BOWMAN', 'CLASS_TRUE_RANGED' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO TypeTags	(Type, Tag)
SELECT	'UNIT_CULVERIN', 'CLASS_TRUE_RANGED' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO TypeTags	(Type, Tag)
SELECT	'UNIT_FIELD_GUN', 'CLASS_TRUE_RANGED' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO TypeTags	(Type, Tag)
SELECT	'UNIT_FIELD_HOWITZER', 'CLASS_TRUE_RANGED' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO TypeTags	(Type, Tag)
SELECT	'UNIT_FIELD_ARTILLERY', 'CLASS_TRUE_RANGED' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
--------------------------------------------------------------
-- New unitablity-RANGE_FIRE_SUPPORT
--------------------------------------------------------------
INSERT OR REPLACE INTO Types		(Type, Kind)
SELECT	'ABILITY_RANGE_FIRE_SUPPORT', 'KIND_ABILITY' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO TypeTags	(Type, Tag)
SELECT	'ABILITY_RANGE_FIRE_SUPPORT', 'CLASS_TRUE_RANGED' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO UnitAbilities		(UnitAbilityType, Name, Description)
SELECT	'ABILITY_RANGE_FIRE_SUPPORT', 'LOC_ABILITY_RANGE_FIRE_SUPPORT_NAME', 'LOC_ABILITY_RANGE_FIRE_SUPPORT_DESCRIPTION' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO UnitAbilityModifiers		(UnitAbilityType, ModifierId)
SELECT	'ABILITY_RANGE_FIRE_SUPPORT', 'GOLDEN_ADJUST_RANGE_FIRE_SUPPORT' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO Modifiers		(ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'GOLDEN_ADJUST_RANGE_FIRE_SUPPORT', 'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH', 'GOLDEN_OPPONENT_FIRE_SUPPORT_REQUIREMENTS' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_ADJUST_RANGE_FIRE_SUPPORT', 'Amount', 20 WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO ModifierStrings		(ModifierId, Context, Text)
SELECT	'GOLDEN_ADJUST_RANGE_FIRE_SUPPORT', 'Preview', 'LOC_ABILITY_RANGE_FIRE_SUPPORT_MODIFIER_DESCRIPTION' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO RequirementSets		(RequirementSetId, RequirementSetType)
SELECT	'GOLDEN_OPPONENT_FIRE_SUPPORT_REQUIREMENTS', 'REQUIREMENTSET_TEST_ALL' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO RequirementSetRequirements		(RequirementSetId, RequirementId)
SELECT	'GOLDEN_OPPONENT_FIRE_SUPPORT_REQUIREMENTS', 'GOLDEN_REQUIRES_OPPONENT_FIRE_SUPPORT' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO Requirements		(RequirementId, RequirementType)
SELECT	'GOLDEN_REQUIRES_OPPONENT_FIRE_SUPPORT', 'REQUIREMENT_OPPONENT_UNIT_PROMOTION_CLASS_MATCHES' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO RequirementArguments		(RequirementId, Name, Value)
SELECT	'GOLDEN_REQUIRES_OPPONENT_FIRE_SUPPORT', 'UnitPromotionClass', 'PROMOTION_CLASS_AUTOMATIC_GUN' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
--------------------------------------------------------------
-- New unitablity-FIRE_SUPPORT_MELEE
--------------------------------------------------------------
INSERT OR REPLACE INTO Types		(Type, Kind)
SELECT	'ABILITY_FIRE_SUPPORT_MELEE', 'KIND_ABILITY' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO TypeTags	(Type, Tag)
SELECT	'ABILITY_FIRE_SUPPORT_MELEE', 'CLASS_AUTOMATIC_GUN' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO UnitAbilities		(UnitAbilityType, Name, Description)
SELECT	'ABILITY_FIRE_SUPPORT_MELEE', 'LOC_ABILITY_FIRE_SUPPORT_MELEE_NAME', 'LOC_ABILITY_FIRE_SUPPORT_MELEE_DESCRIPTION' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO UnitAbilityModifiers		(UnitAbilityType, ModifierId)
SELECT	'ABILITY_FIRE_SUPPORT_MELEE', 'GOLDEN_ADJUST_FIRE_SUPPORT_MELEE' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO Modifiers		(ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'GOLDEN_ADJUST_FIRE_SUPPORT_MELEE', 'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH', 'GOLDEN_OPPONENT_MELEE_REQUIREMENTS' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_ADJUST_FIRE_SUPPORT_MELEE', 'Amount', 20 WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO ModifierStrings		(ModifierId, Context, Text)
SELECT	'GOLDEN_ADJUST_FIRE_SUPPORT_MELEE', 'Preview', 'LOC_ABILITY_FIRE_SUPPORT_MELEE_MODIFIER_DESCRIPTION' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO RequirementSets		(RequirementSetId, RequirementSetType)
SELECT	'GOLDEN_OPPONENT_MELEE_REQUIREMENTS', 'REQUIREMENTSET_TEST_ALL' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO RequirementSetRequirements		(RequirementSetId, RequirementId)
SELECT	'GOLDEN_OPPONENT_MELEE_REQUIREMENTS', 'GOLDEN_REQUIRES_OPPONENT_MELEE' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO Requirements		(RequirementId, RequirementType)
SELECT	'GOLDEN_REQUIRES_OPPONENT_MELEE', 'REQUIREMENT_OPPONENT_UNIT_PROMOTION_CLASS_MATCHES' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
INSERT OR REPLACE INTO RequirementArguments		(RequirementId, Name, Value)
SELECT	'GOLDEN_REQUIRES_OPPONENT_MELEE', 'UnitPromotionClass', 'PROMOTION_CLASS_MELEE' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
--------------------------------------------------------------
-- Automatic_Gun
-- Author: Flactine
--------------------------------------------------------------
--===
--左线1：PROMOTION_LK_FUSILLADE 齐射
--原：对抗近战和反骑兵单位时+4攻击范围（文本错误，实际加远程攻击）
--改：与未受伤的单位战斗时+5战斗力。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_LK_FUSILLADE' AND ModifierId = 'MODIFIER_LK_FUSILLADE_RANGED_VS_MELEE_ANTI_CAV';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,			ModifierId)
SELECT
'PROMOTION_LK_FUSILLADE',	'MODIFIER_GA_PROMOTION_LK_FUSILLADE_COMBAT_UNWOUNDED_BONUS'
WHERE EXISTS (SELECT * FROM UnitPromotionClasses WHERE PromotionClassType = 'PROMOTION_CLASS_AUTOMATIC_GUN');

INSERT INTO Modifiers
(ModifierId,													ModifierType,							SubjectRequirementSetId)
VALUES
('MODIFIER_GA_PROMOTION_LK_FUSILLADE_COMBAT_UNWOUNDED_BONUS',	'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',	'REQSET_GA_PROMOTION_OPPONENT_NOT_WOUNDED');

INSERT INTO ModifierArguments
(ModifierId,														Name,		Value)
VALUES			
('MODIFIER_GA_PROMOTION_LK_FUSILLADE_COMBAT_UNWOUNDED_BONUS',		'Amount',	5);

INSERT INTO ModifierStrings	
(ModifierId,														Context,	Text)
VALUES
('MODIFIER_GA_PROMOTION_LK_FUSILLADE_COMBAT_UNWOUNDED_BONUS',		'Preview',	'LOC_MODIFIER_GA_PROMOTION_LK_FUSILLADE_COMBAT_UNWOUNDED_BONUS_TEXT');
--===
--左线2：PROMOTION_LK_MANTLET 掩体
--原：防御时对抗远程单位+7战斗力。
--改：攻击后可移动，+1移动力。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_LK_MANTLET' AND ModifierId = 'MODIFIER_LK_MANTLET_DEFENSE_VS_RANGED_COMBAT';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,		ModifierId)
SELECT
'PROMOTION_LK_MANTLET',	'MOD_MOVE_AFTER_ATTACKING'
WHERE EXISTS (SELECT * FROM UnitPromotionClasses WHERE PromotionClassType = 'PROMOTION_CLASS_AUTOMATIC_GUN');

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,		ModifierId)
SELECT
'PROMOTION_LK_MANTLET',	'MODIFIER_GA_PROMOTION_LK_MANTLET_MOVEMENT_BONUS'
WHERE EXISTS (SELECT * FROM UnitPromotionClasses WHERE PromotionClassType = 'PROMOTION_CLASS_AUTOMATIC_GUN');

INSERT INTO Modifiers
(ModifierId,										ModifierType)
VALUES
('MODIFIER_GA_PROMOTION_LK_MANTLET_MOVEMENT_BONUS',	'MODIFIER_PLAYER_UNIT_ADJUST_MOVEMENT');

INSERT INTO ModifierArguments
(ModifierId,											Name,		Value)
VALUES			
('MODIFIER_GA_PROMOTION_LK_MANTLET_MOVEMENT_BONUS',		'Amount',	1);
--===
--左线2：PROMOTION_LK_MARKSMAN 神枪手
--原：神枪手：对抗陆地单位+7攻击范围（文本错误，实际远程加攻击）
--改：为相邻的火力支援单位+5远程攻击力。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_LK_MARKSMAN' AND ModifierId = 'MODIFIER_LK_MARKSMAN_ATTACK_BONUS_VS_LAND';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,			ModifierId)
SELECT
'PROMOTION_LK_MARKSMAN',	'MODIFIER_GA_PROMOTION_LK_MARKSMAN_COMBAT_BONUS_TO_AUTOMATIC_GUN'
WHERE EXISTS (SELECT * FROM UnitPromotionClasses WHERE PromotionClassType = 'PROMOTION_CLASS_AUTOMATIC_GUN');

INSERT INTO Modifiers
(ModifierId,														ModifierType,								SubjectRequirementSetId)
SELECT
'MODIFIER_GA_PROMOTION_LK_MARKSMAN_COMBAT_BONUS_TO_AUTOMATIC_GUN',	'MODIFIER_PLAYER_UNITS_ATTACH_MODIFIER',	'REQSET_GA_PROMOTION_LK_MARKSMAN_WITH_AUTOMATIC_GUN'
WHERE EXISTS (SELECT * FROM UnitPromotionClasses WHERE PromotionClassType = 'PROMOTION_CLASS_AUTOMATIC_GUN');

INSERT INTO Modifiers
(ModifierId,														ModifierType)
VALUES
('MODIFIER_GA_PROMOTION_LK_MARKSMAN_AUTOMATIC_GUN_BUFF',			'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH');

INSERT INTO ModifierArguments
(ModifierId,															Name,			Value)
SELECT	
'MODIFIER_GA_PROMOTION_LK_MARKSMAN_COMBAT_BONUS_TO_AUTOMATIC_GUN',		'ModifierId',	'MODIFIER_GA_PROMOTION_LK_MARKSMAN_AUTOMATIC_GUN_BUFF'
WHERE EXISTS (SELECT * FROM UnitPromotionClasses WHERE PromotionClassType = 'PROMOTION_CLASS_AUTOMATIC_GUN');

INSERT INTO ModifierArguments
(ModifierId,												Name,			Value)
VALUES
('MODIFIER_GA_PROMOTION_LK_MARKSMAN_AUTOMATIC_GUN_BUFF',	'Amount',		5);

INSERT INTO ModifierStrings	
(ModifierId,												Context,	Text)
VALUES
('MODIFIER_GA_PROMOTION_LK_MARKSMAN_AUTOMATIC_GUN_BUFF',	'Preview',	'LOC_MODIFIER_GA_PROMOTION_LK_MARKSMAN_AUTOMATIC_GUN_BUFF_TEXT');

INSERT INTO RequirementSets	
(RequirementSetId,										RequirementSetType)
SELECT	
'REQSET_GA_PROMOTION_LK_MARKSMAN_WITH_AUTOMATIC_GUN',	'REQUIREMENTSET_TEST_ALL'
WHERE EXISTS (SELECT * FROM UnitPromotionClasses WHERE PromotionClassType = 'PROMOTION_CLASS_AUTOMATIC_GUN');

INSERT INTO RequirementSetRequirements	
(RequirementSetId,										RequirementId)
SELECT	
'REQSET_GA_PROMOTION_LK_MARKSMAN_WITH_AUTOMATIC_GUN',	'REQ_GA_UNIT_IS_AUTOMATIC_GUN'
WHERE EXISTS (SELECT * FROM UnitPromotionClasses WHERE PromotionClassType = 'PROMOTION_CLASS_AUTOMATIC_GUN');

INSERT INTO RequirementSetRequirements	
(RequirementSetId,										RequirementId)
SELECT
'REQSET_GA_PROMOTION_LK_MARKSMAN_WITH_AUTOMATIC_GUN',	'REQ_GA_PROMOTION_FRIENDLY_IN_1_TILE'
WHERE EXISTS (SELECT * FROM UnitPromotionClasses WHERE PromotionClassType = 'PROMOTION_CLASS_AUTOMATIC_GUN');

INSERT INTO Requirements	
(RequirementId,						RequirementType)
SELECT	
'REQ_GA_UNIT_IS_AUTOMATIC_GUN',		'REQUIREMENT_UNIT_PROMOTION_CLASS_MATCHES'
WHERE EXISTS (SELECT * FROM UnitPromotionClasses WHERE PromotionClassType = 'PROMOTION_CLASS_AUTOMATIC_GUN');

INSERT INTO RequirementArguments	
(RequirementId,					Name,					Value)
SELECT	
'REQ_GA_UNIT_IS_AUTOMATIC_GUN',	'UnitPromotionClass',	'PROMOTION_CLASS_AUTOMATIC_GUN'
WHERE EXISTS (SELECT * FROM UnitPromotionClasses WHERE PromotionClassType = 'PROMOTION_CLASS_AUTOMATIC_GUN');
--===
--右线1：PROMOTION_LK_COUNTER_FIRE 火力对抗
--原：对抗远程和攻城单位时+6攻击范围（文本错误，实际加远程攻击）
--改：在敌方领土内+5战斗力。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_LK_COUNTER_FIRE' AND ModifierId = 'MODIFIER_LK_COUNTER_FIRE_VS_RANGED_SIEGE';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,				ModifierId)
SELECT
'PROMOTION_LK_COUNTER_FIRE',	'MODIFIER_GA_PROMOTION_LK_COUNTER_FIRE_COMBAT_BONUS'
WHERE EXISTS (SELECT * FROM UnitPromotionClasses WHERE PromotionClassType = 'PROMOTION_CLASS_AUTOMATIC_GUN');

INSERT INTO Modifiers
(ModifierId,											ModifierType,							SubjectRequirementSetId)
VALUES
('MODIFIER_GA_PROMOTION_LK_COUNTER_FIRE_COMBAT_BONUS',	'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',	'BERSERKER_PLOT_IS_ENEMY_TERRITORY');

INSERT INTO ModifierArguments
(ModifierId,												Name,		Value)
VALUES			
('MODIFIER_GA_PROMOTION_LK_COUNTER_FIRE_COMBAT_BONUS',		'Amount',	5);

INSERT INTO ModifierStrings	
(ModifierId,												Context,	Text)
VALUES
('MODIFIER_GA_PROMOTION_LK_COUNTER_FIRE_COMBAT_BONUS',		'Preview',	'LOC_MODIFIER_GA_PROMOTION_LK_COUNTER_FIRE_COMBAT_BONUS_TEXT');
--===
--右线2：PROMOTION_LK_ENTRENCH 战壕
--原：战壕：驻扎区域或堡垒防御作战时+10战斗力
--改：获得区域控制，+5近战攻击力。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_LK_ENTRENCH' AND ModifierId = 'MODIFIER_LK_ENTRENCH_ATTACK_BONUS_IN_DISTRICT';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,				ModifierId)
SELECT
'PROMOTION_LK_COUNTER_FIRE',	'MODIFIER_LK_OVERWATCH_EXERT_ZOC'
WHERE EXISTS (SELECT * FROM UnitPromotionClasses WHERE PromotionClassType = 'PROMOTION_CLASS_AUTOMATIC_GUN');

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,				ModifierId)
SELECT
'PROMOTION_LK_COUNTER_FIRE',	'MODIFIER_GA_PROMOTION_LK_COUNTER_FIRE_DEFEND_MELEE'
WHERE EXISTS (SELECT * FROM UnitPromotionClasses WHERE PromotionClassType = 'PROMOTION_CLASS_AUTOMATIC_GUN');

INSERT INTO Modifiers
(ModifierId,											ModifierType,							SubjectRequirementSetId)
VALUES
('MODIFIER_GA_PROMOTION_LK_COUNTER_FIRE_DEFEND_MELEE',	'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',	'REQSET_GA_PROMOTION_LK_COUNTER_FIRE_DEFEND_MELEE');

INSERT INTO ModifierArguments
(ModifierId,												Name,		Value)
VALUES			
('MODIFIER_GA_PROMOTION_LK_COUNTER_FIRE_DEFEND_MELEE',		'Amount',	5);

INSERT INTO ModifierStrings	
(ModifierId,												Context,	Text)
VALUES
('MODIFIER_GA_PROMOTION_LK_COUNTER_FIRE_DEFEND_MELEE',		'Preview',	'LOC_MODIFIER_GA_PROMOTION_LK_COUNTER_FIRE_DEFEND_MELEE_TEXT');

INSERT INTO RequirementSets	
(RequirementSetId,										RequirementSetType)
VALUES
('REQSET_GA_PROMOTION_LK_COUNTER_FIRE_DEFEND_MELEE',	'REQUIREMENTSET_TEST_ALL');

INSERT INTO RequirementSetRequirements	
(RequirementSetId,										RequirementId)
VALUES
('REQSET_GA_PROMOTION_LK_COUNTER_FIRE_DEFEND_MELEE',	'PLAYER_IS_DEFENDER_REQUIREMENTS'),
('REQSET_GA_PROMOTION_LK_COUNTER_FIRE_DEFEND_MELEE',	'MELEE_COMBAT_REQUIREMENTS');
--===
--右线3：PROMOTION_LK_OVERWATCH 掩护
--原：建立区域控制并在对抗近距离攻击时+5战斗力。
--改：对城市和军营远程攻击效率为100%。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_LK_OVERWATCH' AND ModifierId = 'MODIFIER_LK_OVERWATCH_EXERT_ZOC';
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_LK_OVERWATCH' AND ModifierId = 'MODIFIER_LK_OVERWATCH_DEFENSE_VS_MELEE_COMBAT';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,			ModifierId)
SELECT
'PROMOTION_LK_OVERWATCH',	'GDR_SIEGE_LASER'
WHERE EXISTS (SELECT * FROM UnitPromotionClasses WHERE PromotionClassType = 'PROMOTION_CLASS_AUTOMATIC_GUN');
--===
--中线4：PROMOTION_LK_FIRE_AND_MANEUVER 机动火力
--原：攻击后可移动，对抗区域防御时+5攻击范围（文本错误，实际加远程攻击）
--改：如果单位没有移动，每回合+1额外攻击。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_LK_FIRE_AND_MANEUVER' AND ModifierId = 'MODIFIER_LK_FIRE_AND_MANEUVER_ATTACK_AFTER_MOVE';
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_LK_FIRE_AND_MANEUVER' AND ModifierId = 'MODIFIER_LK_FIRE_AND_MANEUVER_BONUS_VS_DISTRICT_DEFENSES';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,					ModifierId)
SELECT
'PROMOTION_LK_FIRE_AND_MANEUVER',	'EXPERT_MARKSMAN_ADDITIONAL_ATTACK'
WHERE EXISTS (SELECT * FROM UnitPromotionClasses WHERE PromotionClassType = 'PROMOTION_CLASS_AUTOMATIC_GUN');