﻿using System;
using System.Collections.Generic;
using System.Reflection;
using System.Linq;
using System.Text;

using UnityEngine;
using Verse;
using RimWorld;
using Harmony;

namespace SSDetours
{
    [HarmonyPatch(typeof(IncidentWorker_ShortCircuit)), HarmonyPatch("TryExecuteWorker")]
    public static class IncidentWorker_SSShortCircuit
    {
        public static IEnumerable<Building> UsableBatteries(Map map)
        {
            return
                from Building battery in map.listerBuildings.allBuildingsColonist
                where (battery.TryGetComp<CompPowerBattery>() != null
                        && battery.TryGetComp<CompPowerBattery>().StoredEnergy > 50f)
                select battery;
        }
        
        /// <summary>
        /// Combination of Ratys's code from Fuse and original Core code. Shouldn't conflict with RT Fuse.
        /// </summary>
        [HarmonyPriority(0)]
        public static void Postfix(IncidentParms parms, IncidentWorker_ShortCircuit __instance, ref bool __result)
        {
            //if (__result) return;
            ////Redo calculation with new parameters
            //if (.Count == 0) __result = false;
            //__result = true;
        }
    }

    [HarmonyPatch(typeof(Alert_NeedBatteries)), HarmonyPatch("NeedBatteries")]
    static class Patch_NeedBatteries
    {
        static bool ShouldFireNeedBatteries(Map map)
        {
            List<Building> buildings = map.listerBuildings.allBuildingsColonist;
            for (int i = 0; i < buildings.Count; i++)
            {
                CompPowerBattery batteryComp = buildings[i].TryGetComp<CompPowerBattery>();
                if (batteryComp != null)
                {
                    return false;
                }
            }
            return true;
        }
        public static void Postfix(Map map, ref bool __result)
        {
            if (__result)
            {
                __result = map.IsPlayerHome && ShouldFireNeedBatteries(map);
            }
        }
    }

    /// <summary>
    /// Powered by Harmony
    /// </summary>
    [StaticConstructorOnStartup]
    internal static class DetourInjector
        {
            static DetourInjector()
            {
                Inject();
            }

            public static void Inject()
            {
                HarmonyInstance.Create("com.spdskatr.biggerbatteries.injector").PatchAll(Assembly.GetExecutingAssembly());
                Log.Message("SS Bigger Batteries information for modders(not an error)\n This mod uses Harmony postfixes(non-destructive) on the following methods:\nRimWorld.IncidentWorker_ShortCircuit.TryExecute,\nRimWorld.Alert_NeedBatteries.NeedBatteries\n\nSTACK TRACE BELOW\n\n");
            }
        }
    }