﻿using UnityEngine;
using Verse;

namespace static_quality_plus
{
    public class static_quality_plus_settings : ModSettings
    {
        public bool learning_saturation_tweak = true;
        public int skill_switch = 1;
        public bool passion_tweak = false;
        public bool passion_gain = false;
        public bool passion_cap = false;
        public bool no_delevel = false;
        public bool plant_rest = true;
        public int quality_switch = 0;

        public void DoWindowContents(Rect canvas)
        {
            Listing_Standard listing_Standard = new Listing_Standard();
            listing_Standard.ColumnWidth = 250f;
            listing_Standard.Begin(canvas);
            //            listing_Standard.
            //            listing_Standard.set_ColumnWidth(rect.get_width() - 4f);
            listing_Standard.Label("物品品质设定:");
            listing_Standard.Gap(12f);

            bool[] qs = new bool[4];
            qs[0] = listing_Standard.RadioButton("随机品质", (quality_switch == 0), 0f);
            qs[1] = listing_Standard.RadioButton("稳定品质", (quality_switch == 1), 0f);
            qs[2] = listing_Standard.RadioButton("稳定品质±1", (quality_switch == 2), 0f);
            qs[3] = listing_Standard.RadioButton("稳定品质±2", (quality_switch == 3), 0f);
            listing_Standard.Gap(24f);
            bool[] ss = new bool[4];
            listing_Standard.Label("技能设定:");
            listing_Standard.Gap(12f);
            ss[0] = listing_Standard.RadioButton("正常下降", (skill_switch == 0), 0f);
            ss[1] = listing_Standard.RadioButton("半速下降", (skill_switch == 1), 0f);
            ss[2] = listing_Standard.RadioButton("缓慢下降", (skill_switch == 2), 0f);
            ss[3] = listing_Standard.RadioButton("不会下降", (skill_switch == 3), 0f);
            listing_Standard.Gap(12f);
            string text_nd = "技能等级不下降";
            listing_Standard.CheckboxLabeled(text_nd, ref no_delevel, "经验下降不会导致等级下降");
            listing_Standard.Gap(12f);
            string text_ls = "每日经验上限";
            listing_Standard.CheckboxLabeled(text_ls, ref learning_saturation_tweak, "每日经验上限不再是4000而是500*等级+1000");
            listing_Standard.Gap(24f);
            listing_Standard.Label("技能兴趣设定:");
            listing_Standard.Gap(12f);
            string text_pt = "技能兴趣调整";
            listing_Standard.CheckboxLabeled(text_pt, ref passion_tweak, "调整技能兴趣为1，1.25，1.5而非0.33，1，1.5");
            //listing_Standard.Gap(12f);
            string text_pg = "技能兴趣提升";
            listing_Standard.CheckboxLabeled(text_pg, ref passion_gain, "技能等级提升的时候有概率提升兴趣");
            //listing_Standard.Gap(12f);
            string text_pc = "技能兴趣限额";
            listing_Standard.CheckboxLabeled(text_pc, ref passion_cap, "一个人最多对四个技能感兴趣，如果对新的技能感兴趣就会对旧的技能失去兴趣");
            listing_Standard.Gap(12f);
            listing_Standard.Label("杂项设定:");
            listing_Standard.Gap(12f);
            string text_pr = "植物休眠";
            listing_Standard.CheckboxLabeled(text_pr, ref plant_rest, "如果关闭此项，植物将能24小时生长");
            listing_Standard.Gap(12f);


            for (int i = 0; i < (qs.Length); ++i)
            {
                if (qs[i])
                {
                    quality_switch = i;
                    break;
                }
            }
            for (int i = 0; i < (ss.Length); ++i)
            {
                if (ss[i])
                {
                    skill_switch = i;
                    break;
                }
            }

            listing_Standard.End();
            //listing_Standard.RadioButton(string label, bool active, [float tabIn]);
            //            return listing_Standard.get_CurHeight();
        }

        public override void ExposeData()
        {
            Scribe_Values.Look<int>(ref skill_switch, "skill_switch", 3, true);
            Scribe_Values.Look<bool>(ref no_delevel, "no_skill_delevel", false, true);
            Scribe_Values.Look<bool>(ref passion_tweak, "passion_tweak", false, true);
            Scribe_Values.Look<bool>(ref learning_saturation_tweak, "learning_saturation", false, true);
            Scribe_Values.Look<bool>(ref passion_gain, "passion_gain", false, true);
            Scribe_Values.Look<bool>(ref passion_cap, "passion_cap", true, true);
            Scribe_Values.Look<int>(ref quality_switch, "quality_switch", 1, true);
            Scribe_Values.Look<bool>(ref plant_rest, "plant_rest", true, true);
        }
    }
}
