/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.openglider.client.event;

import gr8pefish.openglider.api.helper.GliderHelper;
import gr8pefish.openglider.api.item.IGlider;
import gr8pefish.openglider.client.model.ModelGlider;
import gr8pefish.openglider.common.OpenGlider;
import gr8pefish.openglider.common.config.ConfigHandler;
import gr8pefish.openglider.common.helper.OpenGliderPlayerHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientEventHandler
extends Gui {
    private boolean needToPop = false;
    private final ModelGlider modelGlider = new ModelGlider();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRender(RenderPlayerEvent.Pre event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer playerEntity = (EntityPlayer)event.getEntity();
            if (GliderHelper.getIsGliderDeployed((EntityPlayer)event.getEntity())) {
                if (!OpenGliderPlayerHelper.shouldBeGliding(playerEntity)) {
                    return;
                }
                if (Minecraft.func_71410_x().field_71462_r instanceof GuiInventory) {
                    return;
                }
                this.rotateToHorizontal(event.getEntityPlayer(), event.getX(), event.getY(), event.getZ());
                this.needToPop = true;
            }
        }
    }

    private void rotateToHorizontal(EntityPlayer playerEntity, double x, double y, double z) {
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        double interpolatedYaw = playerEntity.field_70126_B + (playerEntity.field_70177_z - playerEntity.field_70126_B) * partialTicks;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)((float)(-interpolatedYaw)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(playerEntity.field_70131_O / 2.0f), (float)0.0f);
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(-playerEntity.field_70131_O / 2.0f), (float)0.0f);
        GlStateManager.func_179114_b((float)((float)interpolatedYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onRender(RenderPlayerEvent.Post event) {
        if (this.needToPop) {
            this.needToPop = false;
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderWorldLastEvent event) {
        EntityPlayerSP playerEntity;
        if (ConfigHandler.enableRenderingFPP && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 && GliderHelper.getIsGliderDeployed((EntityPlayer)(playerEntity = Minecraft.func_71410_x().field_71439_g)) && OpenGliderPlayerHelper.shouldBeGliding((EntityPlayer)playerEntity)) {
            this.renderGliderFirstPersonPerspective(event);
        }
    }

    private void renderGliderFirstPersonPerspective(RenderWorldLastEvent event) {
        EntityPlayerSP entityPlayer = Minecraft.func_71410_x().field_71439_g;
        ItemStack gliderStack = GliderHelper.getGlider((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (gliderStack == null) {
            return;
        }
        ResourceLocation resourceLocation = ((IGlider)gliderStack.func_77973_b()).getModelTexture(gliderStack);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceLocation);
        GlStateManager.func_179094_E();
        this.setRotationFirstPersonPerspective((EntityPlayer)entityPlayer, event.getPartialTicks());
        this.setLightingBeforeRendering((EntityPlayer)entityPlayer, event.getPartialTicks());
        this.modelGlider.func_78088_a((Entity)entityPlayer, entityPlayer.field_184619_aG, entityPlayer.field_70721_aZ, entityPlayer.func_70654_ax(), entityPlayer.field_70759_as, entityPlayer.field_70125_A, 1.0f);
        GlStateManager.func_179121_F();
    }

    private void setLightingBeforeRendering(EntityPlayer player, float partialTicks) {
        GlStateManager.func_179145_e();
        int i = player.func_70070_b(partialTicks);
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
    }

    private void setRotationFirstPersonPerspective(EntityPlayer player, float partialTicks) {
        double interpolatedYaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * partialTicks;
        GlStateManager.func_179114_b((float)((float)(-interpolatedYaw)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)ConfigHandler.gliderVisibilityFPPShiftAmount, (float)0.0f);
        if (player.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(-1.0f * ConfigHandler.shiftSpeedVisualShift));
        }
    }

    @SubscribeEvent
    public void onHandRender(RenderSpecificHandEvent event) {
        EntityPlayer player = OpenGlider.proxy.getClientPlayer();
        if ((ConfigHandler.disableOffhandRenderingWhenGliding || ConfigHandler.disableHandleBarRenderingWhenGliding) && GliderHelper.getIsGliderDeployed(player)) {
            if (ConfigHandler.disableHandleBarRenderingWhenGliding) {
                event.setCanceled(true);
            } else if (ConfigHandler.disableOffhandRenderingWhenGliding && player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof IGlider && !((IGlider)player.func_184614_ca().func_77973_b()).isBroken(player.func_184614_ca()) && event.getHand() == EnumHand.OFF_HAND) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onScroll(MouseEvent event) {
        EntityPlayer player;
        int wheelState = event.getDwheel();
        if (wheelState != 0 && GliderHelper.getIsGliderDeployed(player = OpenGlider.proxy.getClientPlayer())) {
            GliderHelper.setIsGliderDeployed(player, false);
        }
    }
}

