/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.openglider.common.recipe;

import gr8pefish.openglider.common.recipe.RecipeHelper;
import gr8pefish.openglider.common.util.OpenGliderHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RemoveUpgradeFromGliderRecipe
extends ShapelessOreRecipe {
    private ItemStack recipeOutput;
    private ItemStack upgradeRemovedStack;

    public RemoveUpgradeFromGliderRecipe(ItemStack recipeOutput, Object ... items) {
        super(recipeOutput, items);
        this.recipeOutput = recipeOutput;
    }

    public ItemStack func_77572_b(InventoryCrafting inventoryCrafting) {
        int slotOfGlider = RecipeHelper.getFirstGliderInGridSlotNumber(inventoryCrafting);
        if (slotOfGlider == -1) {
            return null;
        }
        ItemStack glider = inventoryCrafting.func_70301_a(slotOfGlider);
        ItemStack result = glider.func_77946_l();
        ArrayList<ItemStack> upgrades = OpenGliderHelper.getUpgradesFromNBT(result);
        if (upgrades.isEmpty()) {
            return null;
        }
        NBTTagCompound nbtTagCompound = result.func_77978_p();
        if (nbtTagCompound == null) {
            nbtTagCompound = new NBTTagCompound();
            nbtTagCompound.func_74782_a("upgrades", (NBTBase)new NBTTagList());
            result.func_77982_d(nbtTagCompound);
        }
        boolean nullChecksPassed = false;
        ItemStack upgradeInQuestion = null;
        if (slotOfGlider <= upgrades.size() - 1 && slotOfGlider >= 0 && upgrades.get(slotOfGlider) != null) {
            upgradeInQuestion = upgrades.get(slotOfGlider);
            nullChecksPassed = true;
        }
        boolean upgradeRemoved = false;
        NBTTagList tagList = new NBTTagList();
        for (ItemStack upgrade : upgrades) {
            if (nullChecksPassed && ItemStack.func_77989_b((ItemStack)upgrade, (ItemStack)upgradeInQuestion)) {
                upgradeRemoved = true;
                continue;
            }
            tagList.func_74742_a((NBTBase)upgrade.func_77955_b(new NBTTagCompound()));
        }
        nbtTagCompound.func_74782_a("upgrades", (NBTBase)tagList);
        if (upgradeRemoved) {
            this.upgradeRemovedStack = upgradeInQuestion;
            return result;
        }
        this.upgradeRemovedStack = null;
        return null;
    }

    public boolean func_77569_a(InventoryCrafting var1, World world) {
        ArrayList required = new ArrayList(this.input);
        for (int x = 0; x < var1.func_70302_i_(); ++x) {
            ItemStack slot = var1.func_70301_a(x);
            if (slot == null) continue;
            boolean inRecipe = false;
            Iterator req = required.iterator();
            while (req.hasNext()) {
                boolean match = false;
                Object next = req.next();
                if (next instanceof ItemStack) {
                    match = OreDictionary.itemMatches((ItemStack)((ItemStack)next), (ItemStack)slot, (boolean)false);
                } else if (next instanceof List) {
                    Iterator itr = ((List)next).iterator();
                    while (itr.hasNext() && !match) {
                        match = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(next);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    public ItemStack[] func_179532_b(InventoryCrafting inv) {
        if (this.upgradeRemovedStack != null) {
            ItemStack[] ret = new ItemStack[inv.func_70302_i_()];
            ret[0] = this.upgradeRemovedStack.func_77946_l();
            for (int i = 1; i < ret.length; ++i) {
                ret[i] = null;
            }
            return ret;
        }
        return super.func_179532_b(inv);
    }
}

