/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.openglider.common.registry;

import gr8pefish.openglider.api.upgrade.UpgradeItems;
import gr8pefish.openglider.common.item.ItemHangGliderAdvanced;
import gr8pefish.openglider.common.item.ItemHangGliderBasic;
import gr8pefish.openglider.common.item.ItemHangGliderPart;
import gr8pefish.openglider.common.lib.ModInfo;
import gr8pefish.openglider.common.recipe.AddUpgradeToGliderRecipe;
import gr8pefish.openglider.common.recipe.RemoveUpgradeFromGliderRecipe;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ItemRegistry {
    public static ItemHangGliderBasic gliderBasic;
    public static ItemHangGliderAdvanced gliderAdv;
    public static ItemHangGliderPart gliderPart;

    public static void registerItems() {
        gliderBasic = (ItemHangGliderBasic)ItemRegistry.registerItem(new ItemHangGliderBasic(), "hang_glider_basic");
        gliderAdv = (ItemHangGliderAdvanced)ItemRegistry.registerItem(new ItemHangGliderAdvanced(), "hang_glider_advanced");
        gliderPart = (ItemHangGliderPart)ItemRegistry.registerItem(new ItemHangGliderPart(), "glider_part");
    }

    public static void registerRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)gliderPart, 1, 0), new Object[]{" sl", "sll", "lll", Character.valueOf('s'), "stickWood", Character.valueOf('l'), "leather"}).setMirrored(false));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)gliderPart, 1, 1), new Object[]{"ls ", "lls", "lll", Character.valueOf('s'), "stickWood", Character.valueOf('l'), "leather"}).setMirrored(false));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)gliderPart, 1, 2), new Object[]{" i ", "i i", "iii", Character.valueOf('i'), "ingotIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)gliderBasic), new Object[]{"   ", "lsr", "   ", Character.valueOf('l'), new ItemStack((Item)gliderPart, 1, 0), Character.valueOf('s'), new ItemStack((Item)gliderPart, 1, 2), Character.valueOf('r'), new ItemStack((Item)gliderPart, 1, 1)}).setMirrored(false));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)gliderAdv), new Object[]{" e ", "lbr", " e ", Character.valueOf('l'), new ItemStack((Item)gliderPart, 1, 0), Character.valueOf('b'), new ItemStack((Item)gliderBasic, 1), Character.valueOf('r'), new ItemStack((Item)gliderPart, 1, 1), Character.valueOf('e'), new ItemStack(Items.field_185160_cR)}).setMirrored(false));
        for (ItemStack upgrade : UpgradeItems.getPossibleUpgradeList()) {
            GameRegistry.addRecipe((IRecipe)new AddUpgradeToGliderRecipe(new ItemStack((Item)gliderBasic), new ItemStack((Item)gliderBasic), upgrade));
            GameRegistry.addRecipe((IRecipe)new RemoveUpgradeFromGliderRecipe(new ItemStack((Item)gliderBasic), new ItemStack((Item)gliderBasic)));
            GameRegistry.addRecipe((IRecipe)new AddUpgradeToGliderRecipe(new ItemStack((Item)gliderAdv), new ItemStack((Item)gliderAdv), upgrade));
            GameRegistry.addRecipe((IRecipe)new RemoveUpgradeFromGliderRecipe(new ItemStack((Item)gliderAdv), new ItemStack((Item)gliderAdv)));
        }
        RecipeSorter.register((String)"GliderAddUpgrade", AddUpgradeToGliderRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        RecipeSorter.register((String)"GliderRemoveUpgrade", RemoveUpgradeFromGliderRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
    }

    public static void registerRenders() {
        ItemRegistry.itemRender(gliderBasic, 0, "hang_glider_basic");
        ItemRegistry.itemRender(gliderAdv, 0, "hang_glider_advanced");
        ItemRegistry.itemRender(gliderPart, 0, ItemHangGliderPart.names[0]);
        ItemRegistry.itemRender(gliderPart, 1, ItemHangGliderPart.names[1]);
        ItemRegistry.itemRender(gliderPart, 2, ItemHangGliderPart.names[2]);
    }

    private static Item registerItem(Item item, String name) {
        item.setRegistryName(name);
        GameRegistry.register((IForgeRegistryEntry)item);
        return item;
    }

    private static void itemRender(Item item, int meta, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(ModInfo.DOMAIN + name, "inventory"));
    }
}

