local modDesc = loadXMLFile("modDesc", g_currentModDirectory .. "modDesc.xml")

animalsINFO = {}
animalsINFO.version = getXMLString(modDesc, "modDesc.version")
animalsINFO.modDirectory = g_currentModDirectory
hudActive = false

addModEventListener(animalsINFO)

function animalsINFO:loadMap()
	print("--- Animal Status v.:" .. self.version .. ", by Deekay")
end

function animalsINFO:keyEvent(unicode, sym, modifier, isDown)
	if Input.isKeyPressed(Input.KEY_rctrl) and Input.isKeyPressed(Input.KEY_rightbracket) then
		hudActive = not hudActive
	end
end

function animalsINFO:mouseEvent(posX, posY, isDown, isUp, button)
end

function animalsINFO:deleteMap()
end

function animalsINFO:update(dt)
end

function animalsINFO:draw()
	local posX = 0.89
	local posX2 = posX + 0.1
	local posY = 0.8
	local padY = 0.010
	local fontSize = 0.015
	local lineDist = fontSize + 0.002
	local Animals = g_currentMission.husbandries

	function printInfo(title, value)
		if #title == 3 then
			setTextColor(1, 1, 1, 1)
			setTextBold(true)
			setTextAlignment(RenderText.ALIGN_LEFT)
			renderText(posX, posY, fontSize, title)
			setTextAlignment(RenderText.ALIGN_RIGHT)
			renderText(posX2, posY, fontSize, value .. " 只")
		else
			setTextBold(false)
			switchColor(value)
			setTextAlignment(RenderText.ALIGN_LEFT)
			renderText(posX, posY, fontSize, title)
			setTextAlignment(RenderText.ALIGN_RIGHT)
			renderText(posX2, posY, fontSize, value .. " %")
		end
		posY = posY - lineDist
		setTextColor(1, 1, 1, 1)
	end

	function switchColor(cc)
		if cc >= 60 then
			setTextColor(1, 1, 1, 1)
		elseif cc < 60 and cc >= 30 then
			setTextColor(0.95, 0.82, 0.3, 1)
		elseif cc < 30 then
			setTextColor(0.79, 0.05, 0.086, 1)
		end
	end

	function paddingY()
		posY = posY - padY
	end

	function getFillLevelFoodFromId(id, husbandry)
		local capacities = husbandry.modulesByName.food.foodGroupCapacities
		local capacity = 0
		for k, v in pairs(capacities) do
			capacity = capacities[k].capacity
		end
		local fillLevelFood = tonumber(math.floor(husbandry.modulesByName.food.fillLevels[id]))
		local fillLevelFoodPercent = tonumber(math.floor((100 * fillLevelFood / capacity)))
		return fillLevelFoodPercent
	end

	function getFillLevelWaterFromId(id, husbandry)
		local capacity = husbandry.modulesByName.water.fillCapacity
		local fillLevelWater = tonumber(math.floor(husbandry.modulesByName.water.fillLevels[id]))
		local fillLevelWaterPercent = tonumber(math.floor((100 * fillLevelWater / capacity)))
		return fillLevelWaterPercent
	end

	function getFillLevelStrawFromId(id, husbandry)
		local capacity = husbandry.modulesByName.straw.fillCapacity
		local fillLevelStraw = tonumber(math.floor(husbandry.modulesByName.straw.fillLevels[id]))
		local fillLevelStrawPercent = tonumber(math.floor((100 * fillLevelStraw / capacity)))
		return fillLevelStrawPercent
	end

	function getCleanlinessFactorInPercent(husbandry)
		local cleanPercent = tonumber(math.floor(husbandry.modulesByName.foodSpillage.cleanlinessFactor * 100))
		return cleanPercent
	end

	function countAnimals(husbandry)
		local numAnimals = 0
		for k, v in pairs(husbandry.modulesByName.animals.animals) do
			numAnimals = tonumber(k)
		end
		return numAnimals
	end

	if hudActive == true then
		for _, husbandry in pairs(Animals) do
			if husbandry.modulesByName.animals.animalType == "CHICKEN" then
				local numChicken = countAnimals(husbandry)
				local cleanliness = getCleanlinessFactorInPercent(husbandry)
				if numChicken > 0 then
					printInfo("鸡", numChicken)
					printInfo("清洁度", cleanliness)
					printInfo("小麦/大麦", getFillLevelFoodFromId(2, husbandry) + getFillLevelFoodFromId(3, husbandry))
				end
				paddingY()
			end
			if husbandry.modulesByName.animals.animalType == "COW" then
				local numCow = countAnimals(husbandry)
				local cleanliness = getCleanlinessFactorInPercent(husbandry)
				if numCow > 0 then
					printInfo("牛", numCow)
					printInfo("清洁度", cleanliness)
					printInfo("农夫山泉", getFillLevelWaterFromId(18, husbandry))
					printInfo("秸秆", getFillLevelStrawFromId(31, husbandry))
					printInfo("牧草", getFillLevelFoodFromId(28, husbandry))
					printInfo("混合饲料", getFillLevelFoodFromId(19, husbandry))
					printInfo("干草/青贮", getFillLevelFoodFromId(24, husbandry) + getFillLevelFoodFromId(30, husbandry))
				end
				paddingY()
			end
			if husbandry.modulesByName.animals.animalType == "PIG" then
				local numPig = countAnimals(husbandry)
				local cleanliness = getCleanlinessFactorInPercent(husbandry)
				if numPig > 0 then
					printInfo("猪", numPig, tonumber(linePadding))
					printInfo("清洁度", cleanliness)
					printInfo("农夫山泉", getFillLevelWaterFromId(18, husbandry))
					printInfo("秸秆", getFillLevelStrawFromId(31, husbandry))
					printInfo("玉米", getFillLevelFoodFromId(8, husbandry))
					printInfo("小麦/大麦", getFillLevelFoodFromId(2, husbandry) + getFillLevelFoodFromId(3, husbandry))
					printInfo(
						"大豆/油菜/向日葵",
						getFillLevelFoodFromId(7, husbandry) + getFillLevelFoodFromId(5, husbandry) + getFillLevelFoodFromId(6, husbandry),
						tonumber(padY)
					)
					printInfo("土豆/甜菜", getFillLevelFoodFromId(9, husbandry) + getFillLevelFoodFromId(10, husbandry))
				end
				paddingY()
			end
			if husbandry.modulesByName.animals.animalType == "HORSE" then
				local numHorse = countAnimals(husbandry)
				if numHorse > 0 then
					printInfo("马", numHorse, tonumber(linePadding))
					printInfo("农夫山泉", getFillLevelWaterFromId(18, husbandry))
					printInfo("秸秆", getFillLevelStrawFromId(31, husbandry))
					printInfo("燕麦", getFillLevelFoodFromId(30, husbandry))
					printInfo("干草", getFillLevelFoodFromId(4, husbandry))
				end
				paddingY()
			end
			if husbandry.modulesByName.animals.animalType == "SHEEP" then
				local numSheep = countAnimals(husbandry)
				local cleanliness = getCleanlinessFactorInPercent(husbandry)
				if numSheep > 0 then
					printInfo("羊", numSheep)
					printInfo("清洁度", cleanliness)
					printInfo("农夫山泉", getFillLevelWaterFromId(18, husbandry))
					printInfo("牧草/干草", getFillLevelFoodFromId(28, husbandry) + getFillLevelFoodFromId(30, husbandry))
				end
				paddingY()
			end
		end
	end
end
