local TyTpTeleporter = Class(function(self, inst)
    self.inst = inst
    self.destinations = {}
    self.index = nil
    self.maxindex = nil
    self.currentdestination = nil
    self.isdestination = true
    self.isPlayer = false
    self.traveller = nil
    self.firstActiveTp = true
end)


function TyTpTeleporter:setDestination(traveller)
	local tempdestination = {}
	local pigking = nil
	local startdoor = nil
	for k,v in pairs(Ents) do
		if v.prefab == "homesign" then
			table.insert(tempdestination, v)
		elseif v.prefab == "pigking" then
			pigking = v
		elseif v.prefab== "multiplayer_portal" then
			startdoor = v
		end
	end
	if pigking then table.insert(tempdestination, pigking) end
	if startdoor then table.insert(tempdestination, startdoor) end
	self.destinations = tempdestination
	self.maxindex = #tempdestination
	self.index =  (self.index and self.maxindex and self.index > 0) and self.index or self.maxindex
end


function TyTpTeleporter:TpTeleporter(traveller,isreverse)
	if traveller == nil then return	end
	
	local isreverse = isreverse or false
	self:setDestination(traveller)
	
	if self.traveltask ~= nil then
		self.traveltask:Cancel()
		self.traveltask = nil
	end
	if self.traveltask1 ~= nil then
		self.traveltask1:Cancel()
		self.traveltask1 = nil
	end
	if self.traveltask2 ~= nil then
		self.traveltask2:Cancel()
		self.traveltask2 = nil
	end
	if self.traveltask3 ~= nil then
		self.traveltask3:Cancel()
		self.traveltask3 = nil
	end
	if self.traveltask4 ~= nil then
		self.traveltask4:Cancel()
		self.traveltask4 = nil
	end
	 
	if self.index and self.index > 0 and self.maxindex and self.maxindex > 0 then
		if isreverse then
			if self.firstActiveTp then
				self.index = self.maxindex
			else
				self.index = (self.index - 1) < 1 and self.maxindex or (self.index - 1)
			end			
		else
			if self.firstActiveTp then
				self.index = 1
			else
				self.index = (self.index + 1) > self.maxindex and 1 or (self.index + 1)
			end
		end
		self.firstActiveTp = false
		self.currentdestination = self.destinations[self.index]
		local desc1 = self.index.."."
		local desc2 = self.currentdestination and self.currentdestination.components.writeable and self.currentdestination.components.writeable:GetText()
		
		local destinationinf = desc1..(desc2 and desc2 or ((self.currentdestination and self.currentdestination.name) and self.currentdestination.name or "  ")) 

		local px,py,pz = traveller.Transform:GetWorldPosition()
		self.traveltask  = traveller:DoTaskInTime(5, function()
			self.activeTp = false
			if traveller == nil  then 
				return
			elseif  self.currentdestination then
				if traveller:HasTag("player") and not traveller:HasTag("playerghost") then
					
					local finduesr = TheSim:FindEntities( px,py,pz, 0.5, 'player')
					local truetraveller = nil
					for k,v in pairs(finduesr) do
						if v == traveller then
							truetraveller = v
						end
					end 
					local x, y, z = self.currentdestination.Transform:GetWorldPosition()
					if traveller and truetraveller and x and y and z then
						
						if traveller.Physics then
							traveller.Physics:Teleport(x,0,z+0.5)
						else
							traveller.Transform:SetPosition(x, 0, z+0.5)
						end
						local lava = SpawnPrefab("lavalight")
						lava.Transform:SetPosition(x-1, 0, z+3)	
						self.activeTp = true
						if self.inst.components.stackable ~= nil then
							self.inst.components.stackable:Get():Remove()
						else
							self.inst:Remove()
						end
					elseif not truetraveller then
						traveller.components.talker:Say(TYWORDS.TYWORDS_39_1) 					
					elseif not x and not y and not z then
						traveller.components.talker:Say(TYWORDS.TYWORDS_39_2) 
					end
				end
			end		
		end)

		self.traveltask4 = traveller:DoTaskInTime(0, function() traveller.components.talker:Say(TYWORDS.TYWORDS_39_3..destinationinf) 
		self.inst.SoundEmitter:PlaySound("dontstarve/HUD/craft_down") end)

		self.traveltask3 = traveller:DoTaskInTime(2, function() traveller.components.talker:Say(TYWORDS.TYWORDS_39_4..destinationinf.."\n"..TYWORDS.TYWORDS_39_5) 
		self.inst.SoundEmitter:PlaySound("dontstarve/HUD/craft_down") end)

		self.traveltask2 = traveller:DoTaskInTime(3, function() traveller.components.talker:Say(TYWORDS.TYWORDS_39_4..destinationinf.."\n"..TYWORDS.TYWORDS_39_5_1)
		self.inst.SoundEmitter:PlaySound("dontstarve/HUD/craft_down") end)

		self.traveltask1 = traveller:DoTaskInTime(4, function() traveller.components.talker:Say(TYWORDS.TYWORDS_39_4..destinationinf.."\n"..TYWORDS.TYWORDS_39_5_2)
		self.inst.SoundEmitter:PlaySound("dontstarve/HUD/craft_down") end)
		


	else
		 traveller.components.talker:Say(TYWORDS.TYWORDS_39_6) 
	end
end
return TyTpTeleporter
