local assets=
{ 
   Asset("ANIM", "anim/rtytp.zip"),
   
   Asset("ATLAS", "images/inventoryimages/tytp.xml"),
   Asset("IMAGE", "images/inventoryimages/tytp.tex"),
}

local prefabs = 
{
}


local function fn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    local sound = inst.entity:AddSoundEmitter()	
    MakeInventoryPhysics(inst)
    inst.entity:AddNetwork ()

    anim:SetBank("rtytp")
    anim:SetBuild("rtytp")
    anim:PlayAnimation("idle",true)
	
	if not TheWorld.ismastersim then
		 return inst
	end	

    inst:AddComponent("inspectable")
    	
    inst.castsound = "dontstarve/common/staffteleport"

    inst:AddComponent("tytpteleporter")
    inst:AddComponent("stackable")
 	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
     
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.keepondeath = false
	inst.components.inventoryitem.imagename = "tytp"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/tytp.xml"  
    
    return inst
end

return  Prefab("common/inventory/tytp", fn, assets, prefabs)