/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import net.blay09.mods.trashslot.CommonProxy;
import net.blay09.mods.trashslot.net.NetworkHandler;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="trashslot", name="TrashSlot")
public class TrashSlot {
    public static final String MOD_ID = "trashslot";
    public static boolean drawSlotBackground;
    public static boolean enableDeleteKey;
    public static boolean trashSlotRelative;
    public static float trashSlotX;
    public static float trashSlotY;
    @Mod.Instance
    public static TrashSlot instance;
    @SidedProxy(serverSide="net.blay09.mods.trashslot.CommonProxy", clientSide="net.blay09.mods.trashslot.client.ClientProxy")
    public static CommonProxy proxy;
    private Configuration config;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        drawSlotBackground = this.config.getBoolean("drawSlotBackground", "general", true, "Set this to false if you don't want the trash can icon to be rendered inside the trash slot.");
        enableDeleteKey = this.config.getBoolean("enableDeleteKey", "general", true, "Set this to false if you don't want the delete key to delete the item below the mouse cursor.");
        trashSlotRelative = this.config.getBoolean("trashSlotRelative", "general", false, "Set this to true if you want the position of the trash slot to be relative to the game window.");
        trashSlotX = trashSlotRelative ? this.config.getFloat("trashSlotXRelative", "general", 1.0f, 0.0f, 1.0f, "The relative x position of the trash slot (if trashSlotRelative is set to true)") : (float)this.config.getInt("trashSlotX", "general", -1, Integer.MIN_VALUE, Integer.MAX_VALUE, "The absolute x position of the trash slot from the center of the screen");
        trashSlotY = trashSlotRelative ? this.config.getFloat("trashSlotYRelative", "general", 1.0f, 0.0f, 1.0f, "The relative y position of the trash slot (if trashSlotRelative is set to true)") : (float)this.config.getInt("trashSlotY", "general", -1, Integer.MIN_VALUE, Integer.MAX_VALUE, "The absolute y position of the trash slot from the center of the screen");
        this.config.save();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkHandler.init();
        proxy.init(event);
    }

    public static boolean canDropStack(boolean result, int mouseX, int mouseY) {
        return proxy.canDropStack(mouseX, mouseY, result);
    }

    public void saveConfig() {
        if (trashSlotRelative) {
            this.config.get("general", "trashSlotXRelative", 1.0, "The relative x position of the trash slot (if trashSlotRelative is set to true)").set((double)trashSlotX);
            this.config.get("general", "trashSlotYRelative", 1.0, "The relative y position of the trash slot (if trashSlotRelative is set to true)").set((double)trashSlotY);
        } else {
            this.config.get("general", "trashSlotX", -1, "The absolute x position of the trash slot from the center of the screen").set((int)trashSlotX);
            this.config.get("general", "trashSlotY", -1, "The absolute y position of the trash slot from the center of the screen").set((int)trashSlotY);
        }
        this.config.save();
    }
}

