PrefabFiles = {
	"haibara",
	"greyhat",
	"aptx",
	"flow"
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/haibara.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/haibara.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/haibara.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/haibara.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/haibara_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/haibara_silho.xml" ),

    Asset( "IMAGE", "bigportraits/haibara.tex" ),
    Asset( "ATLAS", "bigportraits/haibara.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/greyhat.tex" ),
	Asset( "ATLAS", "images/inventoryimages/greyhat.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/aptx.tex" ),
	Asset( "ATLAS", "images/inventoryimages/aptx.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/flow.tex" ),
	Asset( "ATLAS", "images/inventoryimages/flow.xml" ),
	
	Asset( "IMAGE", "images/haibara.tex" ),
    Asset( "ATLAS", "images/haibara.xml" ),

}

local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local STRINGS = GLOBAL.STRINGS
local Recipe = GLOBAL.Recipe

GLOBAL.STRINGS.NAMES.GREYHAT = "ɫñ"
GLOBAL.STRINGS.RECIPE_DESC.GREYHAT = "ɫñ!"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.GREYHAT = "Բ!ҪһЩƷ!"
GLOBAL.STRINGS.NAMES.APTX= "APTX - 4869"
GLOBAL.STRINGS.RECIPE_DESC.APTX= "ҩ!"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.APTX = "Բ!ҪһЩƷ!"
GLOBAL.STRINGS.NAMES.FLOW= "Ļ"
GLOBAL.STRINGS.RECIPE_DESC.FLOW= "Ļ!"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.FLOW= "Բ!ҪһЩƷ!"
-- strings! Any "haibara" below would have to be replaced by the prefab name of your character.

-- The character select screen lines
-- note: these are lower-case character name
GLOBAL.STRINGS.CHARACTER_TITLES.haibara = "Haibara"
GLOBAL.STRINGS.CHARACTER_NAMES.haibara = "Haibara"  -- Note! This line is especially important as some parts of the game require
                                            -- the character to have a valid name.
GLOBAL.STRINGS.CHARACTER_DESCRIPTIONS.haibara = "* ԭ, ,ר."
GLOBAL.STRINGS.CHARACTER_QUOTES.haibara = "\"㲻ܱԹʱ...\""

-- You can also add any kind of custom dialogue that you would like. Don't forget to make
-- categores that don't exist yet using = {}
-- note: these are UPPER-CASE charcacter name
GLOBAL.STRINGS.CHARACTERS.haibara = {}
GLOBAL.STRINGS.CHARACTERS.haibara.DESCRIBE = {}
GLOBAL.STRINGS.CHARACTERS.haibara.DESCRIBE.EVERGREEN = "Creation reflects the inner state of the creator."

-- Let the game know haibara is a male, for proper pronouns during the end-game sequence.
-- Possible genders here are MALE, FEMALE, or ROBOT
table.insert(GLOBAL.CHARACTER_GENDERS.FEMALE, "haibara")

function AddMap(inst)
	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetIcon( inst.prefab .. ".tex" )
end
AddPrefabPostInit("greyhat", AddMap)
AddMinimapAtlas("images/inventoryimages/greyhat.xml")
AddPrefabPostInit("aptx", AddMap)
AddMinimapAtlas("images/inventoryimages/aptx.xml")
AddPrefabPostInit("flow", AddMap)
AddMinimapAtlas("images/inventoryimages/flow.xml")
AddMinimapAtlas("images/haibara.xml")
AddModCharacter("haibara")

