local assets =
{
	Asset("ANIM", "anim/aptx.zip"),
	Asset("IMAGE", "images/inventoryimages/aptx.tex"),
	Asset("ATLAS", "images/inventoryimages/aptx.xml"),
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	
	inst:AddTag("sharp")

    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("bandage")
    inst.AnimState:SetBuild("aptx")
    inst.AnimState:PlayAnimation("idle")
    
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/aptx.xml"
	
	inst:AddComponent("edible")
    inst.components.edible.foodtype = "APTX"
    inst.components.edible.healthvalue = TUNING.HEALING_SUPERHUGE*0.6
    inst.components.edible.hungervalue = 0
    inst.components.edible.sanityvalue = TUNING.SANITY_MED*2
    return inst
end

return Prefab( "common/inventory/aptx", fn, assets) 

