local assets=
{
	Asset("ANIM", "anim/flow.zip"),
	Asset("ANIM", "anim/swap_flow.zip"),
	Asset("IMAGE", "images/inventoryimages/flow.tex"),
	Asset("ATLAS", "images/inventoryimages/flow.xml"),
}

local function OnLoad(inst, data)
    UpdateSanity(inst)
end

local function onattack(inst, owner, target)
	local summonchance = 0.03
    if math.random() < summonchance then 
        local pt = target:GetPosition()
		local st_pt =  FindWalkableOffset(pt or owner:GetPosition(), math.random()*2*PI, 2, 3)
		local ores = {"tornado","bandage","unagi","icecream","knight"}
		local ore = ores[math.random(#ores)]
		if st_pt then
			st_pt = st_pt + pt
			local st1 = SpawnPrefab(ore)
			local st2 = SpawnPrefab("collapse_small")
			st1.Transform:SetPosition(st_pt.x, st_pt.y, st_pt.z)
			st2.Transform:SetPosition(pt.x, pt.y, pt.z)
		end
    end
end

local function onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_object", "swap_flow", "swap_ham_bat")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
	        if inst.components.fueled then
            inst.components.fueled:StartConsuming()      
        end
end
	
	
local function onunequip(inst, owner)
		owner.AnimState:Hide("ARM_carry") 
		owner.AnimState:Show("ARM_normal") 
		        if inst.components.fueled then
            inst.components.fueled:StopConsuming()       
        end
end

local function turnon(inst)

        local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
        if inst.components.fueled:IsEmpty() then
            if owner then
                onequip(inst, owner)
            end
        else
            if owner then
                onequip(inst, owner)
            end
            inst.components.fueled:StartConsuming()
            inst.Light:Enable(true)
        end
end

    local function turnoff(inst, ranout)
        if inst.components.equippable and inst.components.equippable:IsEquipped() then
            local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
            if owner then
                onequip(inst, owner)
            end
        end
        inst.components.fueled:StopConsuming()
        inst.Light:Enable(false)
    end

    local function equip(inst, owner)
        turnon(inst)
    end
    local function unequip(inst, owner)
        onunequip(inst, owner)
        turnoff(inst)
    end
    local function perish(inst)
        local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
        turnoff(inst)
    end
    local function drop(inst)
        turnoff(inst)
    end
    local function takefuel(inst)
        if inst.components.equippable and inst.components.equippable:IsEquipped() then
            turnon(inst)
        end
    end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    local sound = inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("ham_bat")
    anim:SetBuild("flow")
    anim:PlayAnimation("idle")
    
    inst:AddTag("sharp")
	
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(55)
	inst.components.weapon.onattack = onattack

    inst:AddComponent("inspectable")
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem:SetOnDroppedFn( drop )
	inst.components.inventoryitem.atlasname = "images/inventoryimages/flow.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( equip )
    inst.components.equippable:SetOnUnequip( unequip )
	
	
	local light = inst.entity:AddLight()
    light:SetFalloff(0.4)
    light:SetIntensity(.7)
    light:SetRadius(2.5)
    light:SetColour(180/255, 195/255, 150/255)
    light:Enable(false)
	
	
	inst:AddComponent("fueled")
    inst.components.fueled.fueltype = "PETALS"
    inst.components.fueled:InitializeFuelLevel(600)
    inst.components.fueled:SetDepletedFn(perish)
    inst.components.fueled.ontakefuelfn = takefuel
    inst.components.fueled.accepting = true
	
    return inst
end

return Prefab( "common/inventory/flow", fn, assets, prefabs) 