local assets=
{
	Asset("ANIM", "anim/greyhat.zip"),
	Asset("IMAGE", "images/inventoryimages/greyhat.tex"),
	Asset("ATLAS", "images/inventoryimages/greyhat.xml"),
}

local function onfinish(inst)
	inst:Remove()
end

local function onequiphat(inst, owner)
    owner.AnimState:OverrideSymbol("swap_hat", "greyhat", "swap_hat")
    owner.AnimState:Show("HAT")
    owner.AnimState:Show("HAT_HAIR")
    owner.AnimState:Hide("HAIR_NOHAT")
    owner.AnimState:Hide("HAIR")
        
    if owner:HasTag("player") then
        owner.AnimState:Hide("HEAD")
        owner.AnimState:Show("HEAD_HAIR")
    end
end

local function onunequiphat(inst, owner)
    owner.AnimState:Hide("HAT")
    owner.AnimState:Hide("HAT_HAIR")
    owner.AnimState:Show("HAIR_NOHAT")
    owner.AnimState:Show("HAIR")
	
    if owner:HasTag("player") then
        owner.AnimState:Show("HEAD")
        owner.AnimState:Hide("HEAD_HAIR")
    end
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    local sound = inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("bushhat")
    anim:SetBuild("greyhat")
    anim:PlayAnimation("anim")
    
    inst:AddTag("sharp")
	inst:AddTag("hat")
        inst:AddTag("hide")
	
    inst:AddComponent("inspectable")
		
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/greyhat.xml"
	inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/bushhat"
    
    inst:AddComponent("equippable")
	inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
	inst.components.equippable:SetOnEquip( onequiphat )
    inst.components.equippable:SetOnUnequip( onunequiphat )
    inst.components.equippable.insulated = true
	inst.components.equippable.dapperness = TUNING.DAPPERNESS_MED
	inst.components.equippable.walkspeedmult = 1.25
		
	--inst:AddComponent("fueled")
    --inst.components.fueled.fueltype = "USAGE"
    --inst.components.fueled:InitializeFuelLevel(9600)
	--inst.components.fueled:SetDepletedFn(onfinish)
	
	inst:AddComponent("insulator")
    inst.components.insulator:SetInsulation(TUNING.INSULATION_LARGE)

	
    return inst
end

return Prefab( "common/inventory/greyhat", fn, assets, prefabs) 