
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wendy.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/haibara.zip" ),
}
local prefabs = {}

local function applyupgrades(inst)

	local max_upgrades = 10
	local upgrades = math.min(inst.level, max_upgrades)

	local hunger_percent = inst.components.hunger:GetPercent()
	local health_percent = inst.components.health:GetPercent()
	local sanity_percent = inst.components.sanity:GetPercent()

	inst.components.hunger.max = math.ceil (100 + upgrades * 5)
	inst.components.sanity.max = math.ceil (150 + upgrades * 15)
	inst.components.health.maxhealth = math.ceil (80 + upgrades * 5)
	inst.components.talker:Say("  Level Up! : ".. (inst.level))
	
	if inst.level >9 then
		inst.components.talker:Say("OTL Level : Max!")
	end

	inst.components.hunger:SetPercent(hunger_percent)
	inst.components.health:SetPercent(health_percent)
	inst.components.sanity:SetPercent(sanity_percent)
end

local function oneat(inst, food)
    if food and food.components.edible.foodtype == "APTX" then
		inst.level = inst.level + 1
		applyupgrades(inst)	
		inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")
		inst.HUD.controls.status.heart:PulseGreen()
		inst.HUD.controls.status.stomach:PulseGreen()
		inst.HUD.controls.status.brain:PulseGreen()
		
		inst.HUD.controls.status.brain:ScaleTo(1.3,1,.7)
		inst.HUD.controls.status.heart:ScaleTo(1.3,1,.7)
		inst.HUD.controls.status.stomach:ScaleTo(1.3,1,.7)
	end
end

local function updatestats(inst)
	if GetClock():IsDay() and not GetWorld():IsCave() then
		inst.components.sanity:DoDelta(-inst.components.sanity.max*0.2)
		inst.components.combat.damagemultiplier = 1
		inst.components.locomotor.walkspeed = TUNING.WILSON_WALK_SPEED*0.8
		inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED*0.8
 	elseif GetClock():IsDusk() and not GetWorld():IsCave() then
		inst.components.combat.damagemultiplier = 1
		inst.components.locomotor.walkspeed = TUNING.WILSON_WALK_SPEED*1.1
		inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED*1.1
	elseif GetClock():IsNight() and not GetWorld():IsCave() then
		inst.components.combat.damagemultiplier = 1
		inst.components.locomotor.walkspeed = TUNING.WILSON_WALK_SPEED*1.2
		inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED*1.2
	end
end

local function onpreload(inst, data)
	if data then
		if data.level then
			inst.level = data.level
			applyupgrades(inst)
			--re-set these from the save data, because of load-order clipping issues
			if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
			if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
			if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
			inst.components.health:DoDelta(0)
			inst.components.hunger:DoDelta(0)
			inst.components.sanity:DoDelta(0)
		end
	end
end

local function onsave(inst, data)
	data.level = inst.level
	data.charge_time = inst.charge_time
end

local fn = function(inst)
	
	-- choose which sounds this character will play
	inst.soundsname = "wendy"

	inst.MiniMapEntity:SetIcon( "haibara.tex" )
	
	inst.level = 0
	table.insert(inst.components.eater.foodprefs, "APTX")
	table.insert(inst.components.eater.ablefoods, "APTX")
	inst.components.eater:SetOnEatFn(oneat)
	applyupgrades(inst)
	inst.components.hunger:SetMax(100)
	inst.components.sanity:SetMax(150)
	inst.components.health:SetMaxHealth(80)
	inst.components.locomotor.walkspeed = TUNING.WILSON_RUN_SPEED
	inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED
	inst.components.combat.damagemultiplier = 1

	inst.components.sanity.night_drain_mult = 1.1
	inst.components.sanity.neg_aura_mult = 1.1
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE)
	
	inst.components.builder.science_bonus = 1

	inst.OnSave = onsave
	inst.OnPreLoad = onpreload
	
	inst:ListenForEvent( "dusktime", function() updatestats(inst) end , GetWorld())
	inst:ListenForEvent( "daytime", function() updatestats(inst) end , GetWorld())
	inst:ListenForEvent( "nighttime", function() updatestats(inst) end , GetWorld())
	updatestats(inst)
	local greyhat = Recipe("greyhat", {Ingredient("deerclops_eyeball", 1), Ingredient("bearger_fur", 1), Ingredient("walrus_tusk", 2)}, RECIPETABS.DRESS, {SCIENCE = 0})
	greyhat.atlas = "images/inventoryimages/greyhat.xml"
	greyhat.sortkey = 1
	
	local aptx = Recipe("aptx", {Ingredient("honey", 5), Ingredient("spidergland", 8), Ingredient("pigskin", 2)}, RECIPETABS.SURVIVAL, {SCIENCE = 0})
	aptx.atlas = "images/inventoryimages/aptx.xml"
	aptx.sortkey = 1
	
	local flow = Recipe("flow", {Ingredient("petals", 10), Ingredient("twigs", 2), Ingredient("rope", 2)}, RECIPETABS.LIGHT, {SCIENCE = 0})
	flow.atlas = "images/inventoryimages/flow.xml"
	flow.sortkey = 1
	
end



return MakePlayerCharacter("haibara", prefabs, assets, fn)
