function MyGetObjectsByLabel(label)
  if label == "Working-age" then
    local ret = {}
    for _, dome in ipairs(UICity.labels.Dome or empty_table) do
      table.append(ret, dome.labels.Youth)
      table.append(ret, dome.labels.Adult)
      table.append(ret, dome.labels["Middle Aged"])
    end
    return ret
  else
    return UICity.labels[label]
  end
end
function Drone:GoRogue()
  if self.rogue or self:GetParent() then
    return
  end
  self.city:AddToLabel("RogueDrones", self)
  UpdateRogueNotification()
  self.rogue = true
  self:SetCarriedResource(false)
  if IsValid(self.command_center) then
    table.remove_entry(self.command_center.drones, self)
    self.command_center = nil
  end
  self:SetMoveAnim("rogueWalk")
  self:SetWaitAnim("rogueIdle")
  local sign = AttachToObject(self, "UnitSignRogue", "Origin")
  sign:SetVisible(true)
  sign:SetScale(const.SignsOverviewCameraScaleDown)
  self.MoveSleep = self.RogueMoveSleep
  RebuildInfopanel(self)
end

function MyDronesRogue()
  local number = 2
  local drones = MyGetObjectsByLabel("Drone")
  if number == -1 or number >= #drones then
    for _, drone in ipairs(drones) do
      drone:SetCommand("GoRogue")
    end
  else
    local affected = {}
    for i = 1, number do
      local r
      repeat
        r = 1 + UICity:Random(#drones)
      until not affected[r]
      affected[r] = true
    end
    for i, _ in pairs(affected) do
      drones[i]:SetCommand("GoRogue")
    end
  end
end

function myDronesNoraml()
 local drones = MyGetObjectsByLabel("Drone")
	for _, drone in ipairs(drones) do
		drone:SetCommand("RogueRevertToNormal")
	end
end
function MyAttack()
	local drones = MyGetObjectsByLabel("AttackRover")
	for _, drone in ipairs(drones) do
	   if not drone.reclaimed
	     then
		drone:SetCommand("Attack", 3)
	   end
	end
end
function TestAttackRover()
    UICity.mystery.can_shoot_rovers = true
     PlaceObject("AttackRover", {
      use_random_pos = true,
      attack_range = 50 * guim,
    })
    -- rover2:SetCommand("Attack", 3)
    MyDronesRogue()
end

function OnMsg.ColonistBorn(colonist, event)
   if colonist:Random(100) < 40 and  UICity.day > 20
     then
      local dome_id = UICity:Random(#UICity.labels.Dome)
      StartBombard(UICity.labels.Dome[dome_id], 500*guim, 20, 2000, 6000)
   end
end

function OnMsg.ColonistArrived(colonist)
  if colonist:Random(100) < 10 and  UICity.day > 30
     then
      TestAttackRover()
      DelayedCall(30000, MyAttack)
      DelayedCall(20000, myDronesNoraml)
   end
end

function OnMsg.NewDay(day)
   if day == 10 then
      MyDronesRogue()
      DelayedCall(20000, myDronesNoraml)
    elseif day == 20 then
      TestAttackRover()
      DelayedCall(60000, myDronesNoraml)
   elseif day == 30 then
      TestAttackRover()
      DelayedCall(30000, MyAttack)
      DelayedCall(60000, myDronesNoraml)
   elseif day == 40 then
      TestAttackRover()
      DelayedCall(30000, MyAttack)
      DelayedCall(60000, myDronesNoraml)
   elseif day == 50 then
      TestAttackRover()
      DelayedCall(30000, MyAttack)
      DelayedCall(120000, myDronesNoraml)
   elseif day == 60 then
      TestAttackRover()
      TestAttackRover()
      DelayedCall(30000, MyAttack)
      DelayedCall(120000, myDronesNoraml)
   elseif day == 120 then
      TestAttackRover()
      TestAttackRover()
      TestAttackRover()
      TestAttackRover()
      TestAttackRover()
      TestAttackRover()
      TestAttackRover()
      DelayedCall(30000, MyAttack)
      DelayedCall(200000, myDronesNoraml)
   end
end