function Colonist:AddTrait(trait_id, init)
  g_HiddenTraits[trait_id] = nil
  local has_trait = self.traits[trait_id]
  self.traits[trait_id] = true
  if IsValid(self.dome) then
    self.dome:AddToLabel(trait_id, self)
  end
  local trait = DataInstances.Trait[trait_id]
  if trait and (not has_trait or init) then
    trait:Apply(self, init)
    Notify(self, "UpdateMorale")
  end
  Msg("ColonistAddTrait", self, trait_id, init)
end


function OnMsg.ColonistArrived(colonist)
  
   if colonist:IsPinned()then
      colonist:TogglePin()
   end
  -- DelayedCall(1000, CheckColonistCountAchievements)
end

-- only while in the Youth age group, Colonists have the custom Trait "Inexperienced"
function OnMsg.ColonistAddTrait(colonist, trait_id)
        if trait_id=="Youth" then
                colonist:AddTrait("Survivor")
                colonist:AddTrait("Genius")
                colonist:AddTrait("Saint")
                colonist:SetModifier("performence", "Performance boost", 30,0)
        elseif trait_id=="Adult" then
                colonist:SetModifier("performence", "Performance boost", 30,0)
        end
end

function OnMsg.ColonistRemoveTrait(colonist, trait_id)
        if trait_id=="Adult" then
                colonist:SetModifier("performence", "Performance boost", 0,0)
        end
end

-- chance for workers with wrong Specialization to cause a malfunction at their workplace
function OnMsg.NewWorkshift(workshift)
        for _, workplace in ipairs(UICity.labels.Workplace or empty_table) do
                for _, worker in ipairs(workplace.workers[workshift] or empty_table) do
                        if worker.specialist~= workplace.specialist and worker:Random(100) < 60 then
                                worker:GetFired()
                                break
                        end
                end
        end
end
const.SchoolTraits = {
  "Nerd",
  "Composed",
  "Enthusiast",
  "Religious",
  "Survivor",
  "Celebrity",
  "Saint",
  "Genius"
}
const.SchoolExtraTraits = {"Workaholic"}
const.SanatoriumTraits = {
  "Alcoholic",
  "Gambler",
  "Glutton",
  "Lazy",
  "ChronicCondition",
  "Melancholic",
  "Idiot",
  "Introvert",
  "Hypochondriac",
  "Whiner",
  "Renegade",
  "Coward" 
}

Sanatorium.max_traits=12
School.max_traits=8
for i = 1, School.max_traits do
  table.insert(School.properties, {
    template = true,
    id = "trait" .. i,
    name = T({
      725,
      "Learn trait <idx>",
      idx = i
    }),
    default = false,
    category = "School",
    editor = "combo",
    items = SchoolTraitsCombo
  })
end
for i = 1, Sanatorium.max_traits do
  table.insert(Sanatorium.properties, {
    template = true,
    id = "trait" .. i,
    name = T({
      724,
      "Cure trait <idx>",
      idx = i
    }),
    default = false,
    category = "Sanatorium",
    editor = "combo",
    items = SanatoriumTraitsCombo
  })
end
Traits.GenerateBuildingTraitLists = function()
g_SchoolTraits = table.copy(const.SchoolTraits)
g_SanatoriumTraits = table.copy(const.SanatoriumTraits)
  for i, trait in ipairs(DataInstances.Trait) do
    local name = trait.name    
      if trait.school_trait then
        table.insert(g_SchoolTraits, name)
      end
      if trait.sanatorium_trait then
        table.insert(g_SanatoriumTraits, name)
      end
  end
end

