function OnMsg.GameTimeStart()
    AutoGatherInstallThread()
end

function OnMsg.LoadGame()
    AutoGatherInstallThread()
end

function AutoGatherInstallThread()
    CreateGameTimeThread(function()
        while true do
            Sleep(300)
            AutoGatherHandleTransports() 
        end
    end)
end

function AutoGatherHandleTransports()
    ForEach { class = "RCTransport", exec = function(rover)
        -- Enabled via the InfoPanel UI section "Auto Gather"
        if rover.auto_gather then
            -- Idle transporters only
            if rover.command == "Idle" then
                if rover.battery_current > rover.battery_max * 0.6 then

                    -- if inventory is empty, search for a resource
                    if rover:GetStoredAmount() == 0 then
                        AutoGatherFindDeposit(rover)
                    else
                        AutoGatherUnloadContent(rover)
                    end
                else
                    AutoGatherGoRecharge(rover)
                end
            end

            if rover.command == "LoadingComplete" then
                if rover.battery_current > rover.battery_max * 0.2 then
                    AutoGatherUnloadContent(rover)
                else
                    AutoGatherGoRecharge(rover)
                end
            end
        end
    end }
end

function AutoGatherFindDeposit(rover)
    local showNotifications = AutoGatherConfigShowNotification()

    local obj, distance = FindNearest({ 
        classes = "SurfaceDepositMetals,SurfaceDepositConcrete,SurfaceDepositPolymers"
    }, rover)

    if obj then
        if showNotifications == "all" then
            AddCustomOnScreenNotification(
                "AutoGatherTransportGather", 
                T{rover.name}, 
                T{"开始收集资源"}, 
                "UI/Icons/Notifications/research_2.tga",
                false,
                {
                    expiration = 15000
                }
            )
        end

        rover:InteractWithObject(obj, "load")
    end
end

function AutoGatherUnloadContent(rover)
    local showNotifications = AutoGatherConfigShowNotification()

    local obj, distance = FindNearest({ 
        class = "UniversalStorageDepot",
        filter = function(o)
            return not IsKindOf(o, "SupplyRocket")
        end
    }, rover)

    if obj then
        if showNotifications == "all" then
            AddCustomOnScreenNotification(
                "AutoGatherTransportDump", 
                T{rover.name}, 
                T{"正在卸载资源"}, 
                "UI/Icons/Notifications/research_2.tga",
                false,
                {
                    expiration = 15000
                }
            )
        end
        -- This brings up the select resource dialog and needs user interaction
        -- rover:InteractWithObject(obj, "unload")
        rover:SetCommand("DumpCargo", obj:GetPos(), "all")
    else
        if showNotifications == "all" or showNotifications == "problems" then
            AddCustomOnScreenNotification(
                "AutoGatherTransportDumpError", 
                T{rover.name}, 
                T{"找不到可使用的通用仓库"}, 
                "UI/Icons/Notifications/research_2.tga",
                false,
                {
                    expiration = 15000
                }
            )
        end
    end
end

function AutoGatherGoRecharge(rover)
    local showNotifications = AutoGatherConfigShowNotification()

    -- otherwise find the nearest power cable to recharge
    local obj, distance = FindNearest ({ class = "ElectricityGridElement",
        filter = function(obj, ...)
            return not IsKindOf(obj, "ConstructionSite")
        end
    }, rover)

    if obj then
        if showNotifications == "all" then
            AddCustomOnScreenNotification(
                "AutoGatherTransportRecharge", 
                T{rover.name}, 
                T{"准备前去充电"}, 
                "UI/Icons/Notifications/research_2.tga",
                false,
                {
                    expiration = 15000
                }
            )
        end
        rover:InteractWithObject(obj, "recharge")
    else
        if showNotifications == "all" or showNotifications == "problems" then
            AddCustomOnScreenNotification(
                "AutoGatherTransportNoRecharge", 
                T{rover.name}, 
                T{"找不到可以充电的地点"}, 
                "UI/Icons/Notifications/research_2.tga",
                false,
                {
                    expiration = 15000
                }
            )
        end
    end
end

function OnMsg.ClassesBuilt()
    AutoGatherAddInfoSection()
end

function AutoGatherAddInfoSection()
    table.insert(XTemplates.ipRover[1], 
        PlaceObj("XTemplateTemplate", {
            "__context_of_kind", "RCTransport",
            "__template", "InfopanelActiveSection",
            "Icon", "UI/Icons/Upgrades/factory_ai_02.tga",
            "Title", T{"自动收集"},
            "RolloverText", T{"开启/关闭该运输车是否自动收集地表矿藏。<newline><newline>(自动收集和运输Mod)"},
            "RolloverTitle", T{"自动收集"},
            "RolloverHint",  T{"<left_click> 切换设置"},
            "OnContextUpdate",
				function(self, context)
                    if context.auto_gather then
                        self:SetTitle(T{"自动收集 (开启)"})
                        self:SetIcon("UI/Icons/Upgrades/factory_ai_02.tga")
					else
                        self:SetTitle(T{"自动收集 (关闭)"})
                        self:SetIcon("UI/Icons/Upgrades/factory_ai_01.tga")
					end
                end,
        }, {
            PlaceObj("XTemplateFunc", {
                "name", "OnActivate(self, context)", 
                "parent", function(parent, context)
                        return parent.parent
                    end,
                "func", function(self, context)
                        context.auto_gather = not context.auto_gather
                        ObjModified(context)
                    end
            })
        })
    )
end


-- See if ModConfig is installed and that notifications are enabled
function AutoGatherConfigShowNotification()
    if rawget(_G, "ModConfig") then
        return ModConfig:Get("AutoGatherTransport", "Notifications")
    end
    return "all"
end

-- ModConfig signals "ModConfigReady" when it can be manipulated
function OnMsg.ModConfigReady()

    ModConfig:RegisterMod("AutoGatherTransport", -- ID
        T{"自动收集和运输"}, -- Optional display name, defaults to ID
        T{"运输车会自动收集地面的矿藏以及自动充电,并把它们运送到通用仓库内"} -- Optional description
    ) 

    ModConfig:RegisterOption("AutoGatherTransport", "Notifications", {
        name = T{"通知"},
        desc = T{"开启/关闭漫游者自动探索通知."},
        type = "enum",
        values = {
            {value = "all", label = T{"全部"}},
            {value = "problems", label = T{"仅问题"}},
            {value = "off", label = T{"关闭"}}
        },
        default = "all" 
    })
    
end