local assets =
{
    Asset("ANIM", "anim/nightmarefuel.zip"),
}

local function _Make(name , makebuild)
    local function onbuilt( inst , builder )
    	local item = SpawnPrefab(makebuild)
    	if item ~= nil then
            if item.components.inventoryitem ~= nil then
        	   builder.components.inventory:GiveItem(item)
            else
                item.Transform:SetPosition(builder.Transform:GetWorldPosition())
            end
        end
        if builder.components.level then 
            builder.components.level:ExpDoDelta(1)
        end
        inst:Remove()
    end

    local function fn()
        local inst = CreateEntity()
        inst.entity:AddTransform()
    
        inst.OnBuilt = onbuilt 
     
        return inst
    end

    return Prefab(name, fn)
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("nightmarefuel")
    inst.AnimState:SetBuild("nightmarefuel")
    inst.AnimState:PlayAnimation("idle_loop", true)
    inst.AnimState:SetMultColour(1, 1, 1, 0.5)

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM    
    inst:AddComponent("inspectable") 

    MakeHauntableLaunch(inst)

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages.xml"
    inst.components.inventoryitem.imagename = "nightmarefuel"

    return inst
end

return _Make("_redgem" , "redgem"), 
    _Make("_bluegem" , "bluegem"), 
    _Make("_purplegem" , "purplegem"), 
    _Make("_yellowgem" , "yellowgem"), 
    _Make("_greengem" , "greengem"), 
    _Make("_orangegem" , "orangegem"), 
    _Make("_tallbirdnest" , "tallbirdnest"),
    MakePlacer("_tallbirdnest_placer", "egg", "tallbird_egg", "eggnest"),
    Prefab("_nightmarefuel", fn, assets)
