local MakeMagicgirlPlayerCharacter = require "prefabs/magicgirl_common"

local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
}

local prefabs = {

}

-- Custom starting items
local start_inv = {

}

local function aurafn( inst , observer )
	if not inst:HasTag("playerghost") and observer.prefab == "madoka" then
		return inst.components.sanityaura.aura 
	end
	return 0
end

local function levelupfn( inst )
	--inst.components.mana:SetMaxMana(100 + inst.components.level.currentlevel * 2 / 3)
	--inst.components.mana.manarecovery = inst.components.mana.manarecovery + inst.components.level.currentlevel * .01
	inst.components.health.maxhealth = 101 + inst.components.level.currentlevel * 1
	inst.components.sanity.max = 120 + inst.components.level.currentlevel * 2
	inst.components.hunger.max = 120 + inst.components.level.currentlevel * 1
end

local function homurasanitytaskfn( inst )
	if inst:HasTag("playerghost") then return end
	local x, y, z = inst.Transform:GetWorldPosition()
	local players = FindPlayersInRange(x, y, z,10)
	for k,v in pairs(players) do
	    if v.prefab == "madoka" or v:HasTag("madokaspecific") then  -- v:HasTag("madoka")
	    	inst.components.sanity.dapperness = 0
	    	inst.components.sanity.rate_modifier = .55 - inst.components.level.currentlevel * .01
			inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * (.55 - inst.components.level.currentlevel * .01))
			if v:HasTag("playerghost") then
				v:PushEvent("respawnfromghost", { source = inst, user = inst })
				inst.components.sanity:DoDelta(-100)
				--if inst.components.health.currenthealth > 100 then
				--	inst.components.health:DoDelta(-100,nil,"madoka")
				--else -- if inst.components.mana.currentmana > 10 then
				--	inst.components.health:DoDelta(-inst.components.health.currenthealth + 1,nil,"madoka")
				--	--inst.components.mana:DoDelta(inst.components.health.currenthealth - 101)
				--	inst.components.sanity:DoDelta(-(100 - inst.components.health.currenthealth))
				--end
			end
			return 
		end
    end
    inst.components.sanity.rate_modifier = 1
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE)
    inst.components.sanity.dapperness = -TUNING.DAPPERNESS_LARGE / 5  -- (inst.components.level.currentlevel / 3)
end

local function getexptask( inst , target )
	--local target = data.victim
	local exp = 0.01
	if target then 
		--exp = exp + inst.damage / math.min(target.components.health.maxhealth , inst.components.health.maxhealth )
		--inst.damage = 0
		--target.health / (math.abs(target.health - 50 * level) + TUNING.GRUEDAMAGE)
		--math.abs(target.health - TUNING.GRUEDAMAGE * level / 2) / (target.health + TUNING.GRUEDAMAGE + math.abs(target.health - 50 * level)) 
		--.01 * target.health / (math.abs(target.health - TUNING.GRUEDAMAGE * level) + 1)
		exp = exp * target.components.health.maxhealth / (math.abs(target.components.health.maxhealth - TUNING.GRUEDAMAGE * inst.components.level.currentlevel) + 1)
	end
	inst.components.level:ExpDoDelta(math.clamp(exp , 1 , exp))
	inst._currentexp:set(inst.components.level.currentexp)
end

local function stopattacttask( inst )
    if inst.attacktask ~= nil then
        inst.attacktask:Cancel()
        inst.attacktask = nil
    end
    inst.targets = {}
end

local function attacktaskfn( inst )
	for k,v in pairs(inst.targets) do
		if v.components.health and v.components.health:IsDead() then
			getexptask(inst,v) 
			table.remove(inst.targets,k)
		end
	end
	if #inst.targets <= 0 then
		stopattacttask(inst)
	end
	if GetTime() - inst.lastattacttime > 5 then
		stopattacttask(inst)
	end
end

local function onattackother( inst , data )
	-- data = { target = targ, weapon = weapon, projectile = projectile, stimuli = stimuli }
	inst.lastattacttime = GetTime()
	local target = data.target
	if inst.attacktask ~= nil then
		inst:DoPeriodicTask(1, attacktaskfn)
	end
	local keeptarget = true
	if target ~= nil then
		for k,v in pairs(inst.targets) do
			if v == target then
				keeptarget = false
				break
			end
		end
		if keeptarget then
			table.insert(inst.targets,target)
		end
	end
end

local function OnKilled( inst , data )
	local target = data.victim
	if target then 
		attacktaskfn( inst )
	--	if target:HasTag("epic") then 
	--		for i = 1 , math.ceil(target.components.health.maxhealth / 10000) do
	--			local item = SpawnPrefab("_nightmarefuel")
	--			if item ~= nil then
	--				if item.components.lootdropper then
	--					item.components.lootdropper:DropLoot(target.Transform:GetWorldPosition())
	--				elseif item.components.inventory then
	--					item.components.inventory:DropItem(item , nil , nil , target.Transform:GetWorldPosition())
	--				else
	--					item.Transform:SetPosition(target.Transform:GetWorldPosition())
	--				end
	--			end
	--		end
	--	end
	end
end

local function onsave(inst, data)

end

local function onNewSpawn( inst )
	local item = SpawnPrefab("homuragolfclub")
	if item ~= nil then
		if item.components.customize then
			item.components.customize:SetName(inst.name)			
			item.components.customize:SetPrefab(inst.prefab)
		end
		inst.components.inventory:GiveItem(item)
	end
	local item2 = SpawnPrefab("homurarosebow")
	if item2 ~= nil then
		if item2.components.customize then
			item2.components.customize:SetName(inst.name) 		
			item2.components.customize:SetPrefab(inst.prefab)
		end
		inst.components.inventory:GiveItem(item2)
	end
	local item3 = SpawnPrefab("homuragun")
	if item3 ~= nil then
		if item3.components.customize then		
			item3.components.customize:SetPrefab(inst.prefab)
		end
		inst.components.inventory:GiveItem(item3)
	end	
end

local function OnDeath(inst)
	stopattacttask( inst )
end

local function common_magicgirlpostinit(inst) 

	inst.MiniMapEntity:SetIcon( "homura.tex" )
	inst:AddTag("homura")
	inst:AddTag("homura_build")

	inst:AddComponent("sanityaura")
	inst.components.sanityaura.aura = TUNING.SANITYAURA_MED
	inst.components.sanityaura.aurafn = aurafn
end

local function master_magicgirlpostinit(inst)

	inst:ListenForEvent("killed", OnKilled)
	inst:ListenForEvent("onattackother", onattackother)
	inst:ListenForEvent("death", OnDeath)

	inst.homurasanitytask = inst:DoPeriodicTask(1, homurasanitytaskfn)

	inst.lastattacttime = 0
	inst.targets = {}

	inst.OnNewSpawn = onNewSpawn 
end 

return MakeMagicgirlPlayerCharacter("homura", prefabs, assets,  common_magicgirlpostinit, master_magicgirlpostinit, start_inv , levelupfn )
