local magicgirlweapon_comm = require "prefabs/magicgirlweapon_comm"

local assets =
{
    Asset("ANIM", "anim/homuraweapon.zip"),
    Asset("ANIM", "anim/swap_homuraweapon.zip"),

    Asset( "IMAGE", "images/inventoryimages/inv_homuragolfclub.tex" ),
    Asset( "ATLAS", "images/inventoryimages/inv_homuragolfclub.xml" ),
}

local prefabs =
{

}

local function droptask( inst , owner )
    owner.components.inventory:DropItem(inst,true,true)
    inst.components.talker:Say("This is Homura's "..inst.prefab.." !")
end

local function workingfn( owner , data )
    -- data = { target = self.inst } 
    owner.components.combat:GetWeapon().components.level:ExpDoDelta(1)
end

local function onequip(inst, owner)
    if not (inst.components.customize:IsName(owner.name) and inst.components.customize:IsPrefab(owner.prefab)) then
        inst:DoTaskInTime(0 , droptask , owner)
        return
    end 
    owner.AnimState:OverrideSymbol("swap_object", "swap_homuraweapon", "swap_homuragolfclub")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")  
    inst:ListenForEvent("working", workingfn , owner)

    inst.components.talker:Say(string.format("level : %d\nexp : %d / %d",inst.components.level.currentlevel , inst.components.level.currentexp , inst.components.level.levelupexp ) )
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")  
    inst:RemoveEventCallback("working", workingfn , owner)
end

local function levelupfn( inst )
	local dam = 7.5 + 2.5 / 30 * inst.components.level.currentlevel 
    inst.components.weapon:SetDamage(dam)
    inst.components.tool.actions[ACTIONS.CHOP] = .5 + .15 * inst.components.level.currentlevel
    inst.components.tool.actions[ACTIONS.MINE] = .5 + .15 * inst.components.level.currentlevel
end

local function onattack( inst, owner , target )
    inst.components.level:ExpDoDelta(1)
end

local function commonweapon_postinit( inst )
	
    inst.AnimState:SetBank("homuragolfclub")
    inst.AnimState:SetBuild("homuraweapon")
    inst.AnimState:PlayAnimation("idle")
end

local function masterweapon_postinit( inst )

    inst.components.weapon:SetDamage(7.5)
    inst.components.weapon:SetRange(2,2.2)
    inst.components.weapon:SetOnAttack(onattack)

    inst.components.inventoryitem.atlasname = "images/inventoryimages/inv_homuragolfclub.xml"
    inst.components.inventoryitem.imagename = "inv_homuragolfclub"

    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.CHOP, .5)
    inst.components.tool:SetAction(ACTIONS.MINE, .5)
   
end

return magicgirlweapon_comm("homuragolfclub", commonweapon_postinit,masterweapon_postinit, assets, prefabs, levelupfn)
