local assets =
{
    Asset("ANIM", "anim/homuraweapon.zip"),
    Asset("ANIM", "anim/swap_homuraweapon.zip"),

    Asset( "IMAGE", "images/inventoryimages/inv_homuragun.tex" ),
    Asset( "ATLAS", "images/inventoryimages/inv_homuragun.xml" ),
}

local function droptask( inst , owner )
    owner.components.inventory:DropItem(inst,true,true)
    inst.components.talker:Say("This is Homura's "..inst.prefab.." !")
end

local function onhitotherfn( owner, target, damage, stimuli )
    if stimuli == "homuragun" then return end
    local level = owner.components.level.currentlevel
    local losthealth = target.components.health.maxhealth - target.components.health.currenthealth
    damage = level + math.floor(level / 10) * homuratuning.gunbonusdamagepercent * losthealth
    target.components.combat:GetAttacked(owner, damage, owner.components.combat:GetWeapon(), "homuragun")
    if owner._onhitotherfn ~= nil then
        owner._onhitotherfn( owner, target, damage, stimuli ) 
    end
end

local function onownerlevelup( owner , data , inst)
    if owner.components.level == nil then return end
    inst = inst or owner.components.combat:GetWeapon()
    owner.components.combat:SetAttackPeriod(homuratuning.rangeattackperiod - owner.components.level.currentlevel * .25 / 30)
    if owner.components.level.currentlevel >= homuratuning.gunbonusdamagelevel then 
        owner.components.combat.onhitotherfn = onhitotherfn
    end
end

local function givetask( inst , owner )
    owner.components.inventory:GiveItem(inst)
    owner.components.combat:SetAttackPeriod(TUNING.WILSON_ATTACK_PERIOD)
end

local function onequip( inst , owner )
    if not inst.components.customize:IsPrefab(owner.prefab) then
        inst:DoTaskInTime(0 , droptask , owner)
        return
    end 
    if owner.components.health.currenthealth < 5 then
        inst:DoTaskInTime(0 , givetask , owner)
        return
    end
    owner.AnimState:OverrideSymbol("swap_object" , "swap_homuraweapon" , "swap_homuragun")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")

    owner._onhitotherfn = owner.components.combat.onhitotherfn
    onownerlevelup( owner , nil ,  inst)
    inst:ListenForEvent("level", onownerlevelup , owner) 
end

local function onunequip( inst , owner )
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")

    owner.components.combat.onhitotherfn = owner._onhitotherfn
    owner._onhitotherfn = nil 
    inst:RemoveEventCallback("level", onownerlevelup , owner)
    owner.components.combat:SetAttackPeriod(TUNING.WILSON_ATTACK_PERIOD)
end

local function onpickup( inst , owner )
    if inst.components.customize:IsPrefab(owner.prefab) then
        return false
    end
    owner.components.inventory:DropItem(inst,true,true)
    inst.components.talker:Say("This is Homura's "..inst.prefab.." !")
    return true
end

local function gunattackfn( inst , owner , target )
    if owner.components.health then 
        owner.components.health:DoDelta( -homuratuning.gunpenaltyhealth )
    end
    if owner.components.sanity then 
        owner.components.sanity:DoDelta( homuratuning.gunbonussanity )
    end
    if target.components.health.maxhealth < TUNING.GRUEDAMAGE / 2 then  
        owner.components.combat:GetAttacked(target , math.clamp((TUNING.GRUEDAMAGE / 2 - target.components.health.maxhealth) / 2 , homuratuning.attackpenaltyminhealth , homuratuning.attackpenaltyminhealth))
    end
    if owner.components.health.currenthealth <= homuratuning.attackpenaltyminhealth then
        inst:DoTaskInTime(0 , givetask , owner)
    end
end

local function onload( inst , data )
    if not inst.components.customize:IsPrefab("homura") then
        inst.components.customize:SetPrefab("homura")
    end
end

local function onbuilt( inst , builder )
    inst.components.customize:SetPrefab("homura")
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("homuragun")
    inst.AnimState:SetBuild("homuraweapon")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("guns")
    inst:AddTag("homuraweapon")

    inst:AddComponent("talker")
    inst.components.talker.fontsize = 25
    inst.components.talker.font = TALKINGFONT
    inst.components.talker.colour = Vector3(1, 0.25, 1, 1)
    inst.components.talker.offset = Vector3(200,0,0)

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage( homuratuning.gundamage )
    inst.components.weapon:SetRange( homuratuning.gunrange , homuratuning.gunrange + 2 )
    inst.components.weapon:SetOnAttack(gunattackfn)
    inst.components.weapon:SetProjectile("homura_bowprojectile")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.keepondeath = true
    inst.components.inventoryitem:SetOnPickupFn(onpickup)
    inst.components.inventoryitem.atlasname = "images/inventoryimages/inv_homuragun.xml"
    inst.components.inventoryitem.imagename = "inv_homuragun"

    inst:AddComponent("inspectable")

    inst:AddComponent("customize")
    
    inst:AddComponent("equippable")
    inst.components.inventoryitem.keepondeath = true
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip(onunequip)

    MakeHauntableLaunch(inst)

    inst.OnLoad = onload
    inst.OnBuilt = onbuilt

    return inst
end

return Prefab("homuragun" , fn , assets)
