local magicgirlweapon_comm = require "prefabs/magicgirlweapon_comm"

local assets =
{
    Asset("ANIM", "anim/homuraweapon.zip"),
    Asset("ANIM", "anim/swap_homuraweapon.zip"),

    Asset( "IMAGE", "images/inventoryimages/inv_homurarosebow.tex" ),
    Asset( "ATLAS", "images/inventoryimages/inv_homurarosebow.xml" ),
}

local prefabs =
{

}

local function droptask( inst , owner )
    owner.components.inventory:DropItem(inst,true,true)
    owner.components.combat:SetAttackPeriod(TUNING.WILSON_ATTACK_PERIOD)
    inst.components.talker:Say("This is Homura's "..inst.prefab.." !")
end

local function givetask( inst , owner )
    owner.components.inventory:GiveItem(inst)
    owner.components.combat:SetAttackPeriod(TUNING.WILSON_ATTACK_PERIOD)
end

local function onequip(inst, owner)
    if not (inst.components.customize:IsName(owner.name) and inst.components.customize:IsPrefab(owner.prefab)) then
        inst:DoTaskInTime(0 , droptask , owner)
        return
    end 
    if owner.components.health.currenthealth < 5 then
        inst:DoTaskInTime(0 , givetask , owner)
        return
    end
    owner.AnimState:OverrideSymbol("swap_object", "swap_homuraweapon", "swap_homurarosebow")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal") 
    owner.components.combat:SetAttackPeriod(homuratuning.rangeattackperiod - inst.components.level.currentlevel * .25 / 30)

    inst.components.talker:Say(string.format("level : %d\nexp : %d / %d",inst.components.level.currentlevel , inst.components.level.currentexp , inst.components.level.levelupexp ) )
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
    owner.components.combat:SetAttackPeriod(TUNING.WILSON_ATTACK_PERIOD) 
end

local function onblink(staff, pos, caster)
    if caster.components.sanity ~= nil then
        if caster.components.sanity.current >= TUNING.SANITY_MED then
            staff.components.level:ExpDoDelta(1)
        end
        caster.components.sanity:DoDelta(-TUNING.SANITY_MED)
    end
end

local function levelup( inst )
	local dam = 27.5 + 6.5 / 30 * inst.components.level.currentlevel 
    inst.components.weapon:SetDamage(dam)

    if inst.components.level.currentlevel >= homuratuning.blinklevel and inst.components.blinkstaff == nil then
        inst:AddComponent("blinkstaff")
        inst.components.blinkstaff:SetFX("sand_puff_large_front", "sand_puff_large_back")
        inst.components.blinkstaff.onblinkfn = onblink
    end
end

local function onattack( inst, owner , target )
    inst.components.level:ExpDoDelta(1)
    if target.components.freezable ~= nil then
        target.components.freezable:AddColdness(homuratuning.freezablevalue * inst.components.level.currentlevel)
        target.components.freezable:SpawnShatterFX()
    end
    if owner.components.hunger then 
        owner.components.hunger:DoDelta( -homuratuning.bowpenaltyhunger )
    end
    if owner.components.sanity then 
        owner.components.sanity:DoDelta( homuratuning.bowbonussanity )
    end
    if target.components.health.maxhealth < TUNING.GRUEDAMAGE / 2 then  
        owner.components.combat:GetAttacked(target , math.clamp((TUNING.GRUEDAMAGE / 2 - target.components.health.maxhealth) / 2 , homuratuning.attackpenaltyminhealth , homuratuning.attackpenaltyminhealth))
    end
    if owner.components.health.currenthealth <= homuratuning.attackpenaltyminhealth then
        inst:DoTaskInTime(0 , givetask , owner)
    end
end

local function commonweapon_postinit( inst )
	
    inst.AnimState:SetBank("homurarosebow")
    inst.AnimState:SetBuild("homuraweapon")
    inst.AnimState:PlayAnimation("idle")
end

local function masterweapon_postinit( inst )

    inst.components.weapon:SetDamage(27.5)
    inst.components.weapon:SetRange(8,10)
    inst.components.weapon:SetOnAttack(onattack)
    inst.components.weapon:SetProjectile("homura_bowprojectile")

    inst.components.inventoryitem.atlasname = "images/inventoryimages/inv_homurarosebow.xml"
    inst.components.inventoryitem.imagename = "inv_homurarosebow"

    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)   
end

-------------------------------------------------------------------------------
local function onhit(inst, attacker, target)
    local impactfx = SpawnPrefab("impact")
    if impactfx ~= nil then
        local follower = impactfx.entity:AddFollower() 
        follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0) 
        if attacker ~= nil then
            impactfx:FacePoint(attacker.Transform:GetWorldPosition())
        end
    end
    inst:Remove()
end

local function onthrown(inst, data)
    inst.AnimState:SetOrientation(ANIM_ORIENTATION.OnGround) 
end

local function pipethrown(inst)
    inst.AnimState:PlayAnimation("idle")
    inst:AddTag("NOCLICK") 
    inst.persists = false 
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("homura_bowprojectile")
    inst.AnimState:SetBuild("homuraweapon")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("homura_bowprojectile")

    inst:AddTag("projectile")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(60)
    inst.components.projectile:SetOnHitFn(onhit)
    inst.components.projectile:SetOnThrownFn(pipethrown)    
    inst.components.projectile:SetOnHitFn(inst.Remove)
    inst.components.projectile:SetOnMissFn(inst.Remove)
    inst:ListenForEvent("onthrown", onthrown)

    inst.Transform:SetScale(.5, .5, 1)

    return inst
end

return Prefab("homura_bowprojectile", fn, assets, prefabs),
    magicgirlweapon_comm("homurarosebow", commonweapon_postinit,masterweapon_postinit, assets, prefabs,levelup)
