local MakePlayerCharacter = require "prefabs/player_common"

local function onsave(inst, data)

end

local function OnDeath(inst)

end

local function oncurrentmanadirty(inst) 
    inst.currentmana = inst._currentmana:value()    
end

local function onmaxmanadirty(inst) 
    inst.maxmana = inst._maxmana:value()     
end

local function oncurrentleveldirty(inst) 
    inst.currentlevel = inst._currentlevel:value()     
end

local function oncurrentexpdirty(inst) 
    inst.currentexp = inst._currentexp:value()     
end

local function onlevelupexpdirty(inst) 
    inst.levelupexp = inst._levelupexp:value()     
end

local function MakeMagicgirlPlayerCharacter( name, prefabs, assets, common_magicgirlpostinit, master_magicgirlpostinit, start_inv , levelupfn , becamehuman )

	local function OnLevelUp( inst )
		inst.components.level:SetLevelUpExp(math.pow(inst.components.level.currentlevel , 2) + inst.components.level.currentlevel * 4 + math.floor(math.ceil(inst.components.level.currentlevel / 2) * inst.components.level.currentlevel / 10)) -- + inst.components.level.currentexp)
		
		if levelupfn ~= nil then
			levelupfn(inst)
		end

		inst._currentlevel:set(inst.components.level.currentlevel)
		inst._levelupexp:set(inst.components.level.levelupexp)
		inst._currentexp:set(inst.components.level.currentexp)
	end

	-- When the character is revived from human --复活
	--当角色从人类复活
	local function onbecamehuman(inst, data)
		inst.components.locomotor:SetExternalSpeedMultiplier(inst, inst.prefab.."_speed_mod", 1.4)

		if becamehuman ~= nil then
			becamehuman(inst)
		end

		OnLevelUp(inst)
	end

	local function onbecameghost(inst, data)
		-- Remove speed modifier when becoming a ghost
	   inst.components.locomotor:RemoveExternalSpeedMultiplier(inst, inst.prefab.."_speed_mod")
	end

	local function onload(inst,data )
	    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
	    inst:ListenForEvent("ms_becameghost", onbecameghost)

	    if inst:HasTag("playerghost") then
	        onbecameghost(inst, data)
	    else
	        onbecamehuman(inst, data)
	    end
	end

	-- This initializes for both the server and client. Tags can be added here.
	--这将初始化为服务器和客户端。 标签可以在这里添加。
	local common_postinit = function(inst) 

		inst:AddTag("magicgirl")

		--inst.currentmana = 0
		--inst.maxmana = 0
		inst.currentlevel = 1
		inst.currentexp = 0
		inst.levelupexp = 0

		--inst._currentmana = net_byte(inst.GUID,"currentmana","currentmana_dirty")-- 
		--inst._maxmana = net_byte(inst.GUID,"maxmana","maxmana_dirty")-- 
		inst._currentlevel = net_byte(inst.GUID,"currentlevel","currentlevel_dirty")-- 
		inst._currentexp = net_shortint(inst.GUID,"currentexp","currentexp_dirty")-- 
		inst._levelupexp = net_shortint(inst.GUID,"levelupexp","levelupexp_dirty")-- 

		if not TheWorld.ismastersim then
	        --inst:ListenForEvent("currentmana_dirty",oncurrentmanadirty)
	        --inst:ListenForEvent("maxmana_dirty", onmaxmanadirty )
	        inst:ListenForEvent("currentlevel_dirty", oncurrentleveldirty )
	        inst:ListenForEvent("currentexp_dirty", oncurrentexpdirty )
	        inst:ListenForEvent("levelupexp_dirty", onlevelupexpdirty )
	    end

	    inst:AddComponent("keyhandler")

	    if common_magicgirlpostinit ~= nil then
	    	common_magicgirlpostinit(inst)
	    end
	end

	local master_postinit = function(inst)
		
		inst.soundsname = "willow"
		
		-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
	    -- 如果使用“wathgrithr”（Wigfrid）或“webber”语音，则取消注释
	    --inst.talker_path_override = "dontstarve_DLC001/characters/"
		
		-- Stats	 --统计
		inst:AddComponent("reader")  

		inst:AddComponent("level")
		inst.components.level:SetMaxLevel(30)
		inst.components.level:SetLevelUpFn(OnLevelUp)
		OnLevelUp(inst)
		
		inst.components.locomotor:SetExternalSpeedMultiplier(inst, name.."_speed_mod", 1.4)

		inst.components.combat:SetAttackPeriod(TUNING.WILSON_ATTACK_PERIOD)

		inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
		
		inst.Transform:SetFourFaced() 
		--inst.Transform:SetScale(0.8, 0.8, 0.8) 

		if master_magicgirlpostinit ~= nil then
			master_magicgirlpostinit(inst)
		end

		inst.OnLoad = onload

	end 

	return MakePlayerCharacter(name, prefabs, assets, common_postinit, master_postinit, start_inv)

end

return MakeMagicgirlPlayerCharacter
