local function onpickup( inst , owner )
    if inst.components.customize:IsName(owner.name) and inst.components.customize:IsPrefab(owner.prefab) then
        return false
    end
    owner.components.inventory:DropItem(inst,true,true)
    inst.components.talker:Say("This is "..(inst.components.customize:GetName() or "Homura").."'s "..inst.prefab.." !")
    return true
end

local function magicgirlweapon_comm(name,commonweapon_postinit,masterweapon_postinit,assets, prefabs , levelupfn)

    local function dotalkertask( inst )
        inst.components.talker:Say(string.format("level : %d\nexp : %d / %d",inst.components.level.currentlevel , inst.components.level.currentexp , inst.components.level.levelupexp ) )
    end

    local function onlevelup( inst )
        inst.components.level:SetLevelUpExp(math.ceil((1 + math.sin(math.rad(3 * (inst.components.level.currentlevel + 1) - 90))) * 1000))
        inst:DoTaskInTime(0 , dotalkertask)

        if levelupfn ~= nil then
            levelupfn(inst)
        end
    end

    local function onload( inst , data )
        if not inst.components.customize:IsPrefab("homura") then
            inst.components.customize:SetPrefab("homura")
        end
        onlevelup( inst )
    end

    local function fn(  )
        local inst = CreateEntity()

        inst.entity:AddTransform()
        inst.entity:AddAnimState()
        inst.entity:AddNetwork()

        MakeInventoryPhysics(inst)

        inst:AddTag("sharp")

        inst:AddTag(name)

        inst:AddComponent("talker")
        inst.components.talker.fontsize = 25
        inst.components.talker.font = TALKINGFONT
        inst.components.talker.colour = Vector3(1, 0.25, 1, 1)
        inst.components.talker.offset = Vector3(200,0,0)
        -- Say(script, time, noanim, force, nobroadcast, color) -- 脚本，时间，无动画，强制，无广播，颜色

        inst.entity:SetPristine()

        if commonweapon_postinit ~= nil then
            commonweapon_postinit(inst)
        end

        if not TheWorld.ismastersim then
            return inst
        end

        inst:AddComponent("weapon")
        --inst.components.weapon.attackwear = 0

        inst:AddComponent("level")
        inst.components.level:SetMaxLevel(30)
        inst.components.level:SetLevelUpExp(5)
        inst.components.level:SetLevelUpFn(onlevelup)

        inst:AddComponent("customize")

        inst:AddComponent("inspectable")  

        inst:AddComponent("inventoryitem")
        inst.components.inventoryitem.keepondeath = true
        inst.components.inventoryitem:SetOnPickupFn(onpickup)

        inst:AddComponent("equippable")
        inst.components.inventoryitem.keepondeath = true

        if masterweapon_postinit ~= nil then
            masterweapon_postinit(inst)
        end

        inst.OnLoad = onload

        MakeHauntableLaunch(inst)

        return inst
        
    end

    return Prefab(name, fn, assets, prefabs)

end

return magicgirlweapon_comm
