-- 首先，在文件的头部写上需要加载的Widget类
local Widget = require "widgets/widget" --Widget，所有widget的祖先类
local Text = require "widgets/text" --Text类，文本处理
local Button = require "widgets/button"
local TextButton = require "widgets/textbutton"
local Image = require "widgets/image"

-- 640 360
local width , height = TheSim:GetScreenSize()
local pw = width / 1134
local ph = height / 638
--ph = (height - 360) / (638 - 360)

--local bgw = 750 -- + (width < 1100 and -20 * pw or (1200 > width and 20 * pw  or 0 ))
local bgw = 400 + 340 * math.min(pw,ph)
local bgh = 20 * ph
--width = 1280 / width
--height = 720 / height

local Custwidget = Class(Widget, function(self, owner) -- 这里定义了一个Class，第一个参数是父类，第二个参数是构造函数，函数的参数第一个固定为self，后面的参数可以不写，也可以自定义。
    Widget._ctor(self, "Custwidget") --这一句必须写在构造函数的第一行，否则会报错。
    --这表明调用父类的构造函数（此处是Widget，如果继承Text，则应该写Text._ctor），第一个参数是固定的self，后面的参数同这个父类的构造函数的参数，此处写的是Widget的名字。
    --
    self.owner = owner
    --self.total_w = total_w -- or 800
    self.width , self.height = TheSim:GetScreenSize() -- 1134 , 638
    --self.width = self.width / 1134
    --self.health = self.height / 638 

    self.oldmana = 0

    --self.role = self:AddChild(Widget("Role"))
	--self.role:SetPosition(-400, 0,0)
	--self.role:SetScale(0.8,0.8,0.8)	--缩放比例
	--self.role:MoveToBack() --把它后置  意思就是它会在其他界面的后面显示，其他界面会遮挡它
	--如果是MoveToFront的话，就是让它前置，让它不会被其他界面遮挡
	--self.hello.manatext:SetHAlign(ANCHOR_MIDDLE) --设置居中
    self.leveltext = self:AddChild(Text(BODYTEXTFONT, 20,"level : 30")) --添加一个文本变量，接收Text实例。
	--self.leveltext.leveltext:SetVRegPoint(0)  ----设置对其 0 1 2 居中 上对其 下对其
	--self.leveltext.leveltext:SetHRegPoint(1)	 ----设置对其 0 1 2 居中 左对齐 右对齐
	self.leveltext:SetHAlign(ANCHOR_MIDDLE) --设置居中
	self.leveltext:SetPosition(-100 - bgw / 2, 30 * ph, 0)
	self.leveltext:SetColour( 1 , 1 , .5 ,1)
	self.leveltext:MoveToFront()


	self.imagebgexp = self:AddChild(Image("images/custwidgets/bg2.xml","bg2.tex"))
	self.imagebgexp:SetPosition(-bgw / 2, 30 * ph, 0)
	self.imagebgexp:SetVRegPoint(0)
	self.imagebgexp:SetHRegPoint(1)
	self.imagebgexp:MoveToFront()
	self.imagebgexp:OnEnable()
	self.imagebgexp:SetSize(bgw ,20 * ph)
	--[[
	self.imagebgmana = self:AddChild(Image("images/custwidgets/bg2.xml","bg2.tex"))
	self.imagebgmana:SetPosition(-bgw / 2, 10 * ph, 0)
	self.imagebgmana:SetVRegPoint(0)
	self.imagebgmana:SetHRegPoint(1)
	self.imagebgmana:MoveToFront()
	self.imagebgmana:OnEnable()
	self.imagebgmana:SetSize(bgw,20 * ph)
	]]
	self.imageexp = self:AddChild(Image("images/custwidgets/exp.xml","exp.tex"))
	self.imageexp:SetPosition(-bgw / 2 , 30 * ph, 0)
	self.imageexp:SetVRegPoint(0)
	self.imageexp:SetHRegPoint(1)
	self.imageexp:MoveToFront()
	self.imageexp:OnEnable()
	self.imageexp:SetSize(bgw,15 * ph)
	--[[
	self.imagemana = self:AddChild(Image("images/custwidgets/mana1.xml","mana1.tex"))
	self.imagemana:SetPosition(-bgw / 2 , 10 * ph, 0)
	self.imagemana:SetVRegPoint(0)
	self.imagemana:SetHRegPoint(1)
	self.imagemana:MoveToFront()
	self.imagemana:OnEnable()
	self.imagemana:SetSize(0,15 * ph)

	self.imagemana2 = self:AddChild(Image("images/custwidgets/mana2.xml","mana2.tex"))
	self.imagemana2:SetPosition(-bgw / 2 , 10 * ph, 0)
	self.imagemana2:SetVRegPoint(0)
	self.imagemana2:SetHRegPoint(1)
	self.imagemana2:MoveToFront()
	self.imagemana2:OnEnable()
	self.imagemana2:SetSize(0,15 * ph)
	]]
	self.targettext = self:AddChild(Text(BODYTEXTFONT, 30,"")) --
	self.targettext:SetHAlign(ANCHOR_MIDDLE)
	self.targettext:SetPosition(-395 * pw, 598 * ph, 0)
	self.targettext:SetColour( .8 , .8 , .8 ,1)
	self.targettext:MoveToFront()
	self.targettext:Hide()

	self.exptext = self:AddChild(Text(BODYTEXTFONT, 20,"exp  0 / 0")) --
	self.exptext:SetHAlign(ANCHOR_MIDDLE)
	self.exptext:SetPosition(0, 30 * ph, 0)
	self.exptext:SetColour(1 , 0 , 1 ,1)
	self.exptext:MoveToFront()
	--[[
	self.manatext = self:AddChild(Text(BODYTEXTFONT, 20,"mana  0 / 0")) --
	self.manatext:SetHAlign(ANCHOR_MIDDLE)
	self.manatext:SetPosition(0, 10 * ph, 0)
	self.manatext:SetColour( 1 , 1 , 1 ,1)
	self.manatext:MoveToFront()
	]]
	self:StartUpdating()
end)

local function updatewindow( self , width , height)

	pw = (width - 640) / (1134 - 640)
	ph = height / 638
	bgw = 400 + 340 * math.min(pw,ph)
	bgh = 20 * ph
	self.width = width 
	self.height = height

	self.leveltext:SetPosition(-100 - bgw / 2, 30 * ph, 0)

	self.imagebgexp:SetPosition(-bgw / 2, 30 * ph, 0)
	--self.imagebgmana:SetPosition(-bgw / 2, 10 * ph, 0)
	self.imageexp:SetPosition(-bgw / 2 , 30 * ph, 0)
	--self.imagemana:SetPosition(-bgw / 2 , 10 * ph, 0)
	--self.imagemana2:SetPosition(-bgw / 2 , 10 * ph, 0)

	self.imagebgexp:SetSize(bgw ,20 * ph)
	--self.imageexp:SetSize(bgw,15 * ph)
	self.imagebgmana:SetSize(bgw,20 * ph)
	--self.imagemana:SetSize(bgw,15 * ph)
	--self.imagemana2:SetSize(bgw,15 * ph)

	self.exptext:SetPosition(0, 30 * ph, 0)
	self.manatext:SetPosition(0, 10 * ph, 0)

end

function Custwidget:OnUpdate(dt)

	local currentexp = self.owner.currentexp -- :value() or 0
	local levelupexp = self.owner.levelupexp -- :value() or 0
	--local currentmana = self.owner.currentmana -- :value() or 0
	--local maxmana = self.owner.maxmana -- :value() or 0
	local currentlevel = self.owner.currentlevel -- :value() or 0

	self.leveltext:SetString(string.format("level : %2d",currentlevel))

	local widthexp = math.min(math.ceil(currentexp / levelupexp * bgw) , bgw)
	local expstr = string.format("exp  %3d / %3d",currentexp,levelupexp)
	self.exptext:SetString(expstr)
	if currentlevel < 30 then
		self.imageexp:SetSize(widthexp,10 * ph)
	else
		self.imageexp:SetSize(bgw * pw,10 * ph)
	end
--[[
	local widthmana = math.min(math.ceil(currentmana / maxmana * bgw) , bgw) 
	local manastr = string.format("mana  %3d / %3d",currentmana, maxmana)
	self.manatext:SetString(manastr)
	if self.oldmana > currentmana then
		local widthmana2 = math.min(math.ceil(self.oldmana / maxmana * bgw) , bgw) 
		self.imagemana2:SetSize(widthmana2,10 * ph)
		self.oldmana = self.oldmana - 1 
	else
		self.imagemana2:SetSize(widthmana,10 * ph)
		self.oldmana = currentmana 
	end
	self.imagemana:SetSize(widthmana,10 * ph)
	--print(widthmana,currentmana,bgw,maxmana)
]]
	local width , height = TheSim:GetScreenSize()
	if self.width ~= width then
		updatewindow( self , width , height)
	end
	--print(h,y)

end

return Custwidget
