local Widget = require "widgets/widget" 
local Text = require "widgets/text" 
--local description = require "description"

local width , height = TheSim:GetScreenSize()
local showexplanationtext = true
local showstrnumber = 1
local language = "chinese"
local promptstr = "Use button F6 to show or hide\nUse button L to select the language\nUse button '↑' and '↓' flip page"

local Explanation = Class(Widget, function(self, owner) 
    Widget._ctor(self, "Explanation") 

    self.owner = owner

    self.timetext = self:AddChild(Text(BODYTEXTFONT, 20, os.date("%x", os.time()).."\n"..os.date("%X", os.time()) )) -- "currenttime: 00 00 00"
	self.timetext:SetHAlign(ANCHOR_MIDDLE)
	self.timetext:SetPosition(100, -40, 0)
	self.timetext:SetColour(1 , 0 , 1 ,1)
	self.timetext:MoveToFront()

	self.explanationtext = self:AddChild(Text(BODYTEXTFONT, 20, owner.prefab )) 
	--self.explanationtext:SetHAlign(ANCHOR_MIDDLE)
	self.explanationtext:SetPosition(100, -80, 0)
	self.explanationtext:SetVAlign(0)
	self.explanationtext:SetHAlign(1)
	self.explanationtext:SetColour(1 , .5 , 1 ,1)
	self.explanationtext:MoveToFront()
	self.explanationtext:Hide()

	self.prompttext = self:AddChild(Text(BODYTEXTFONT, 20, promptstr )) 
	self.prompttext:SetPosition(width / 4, -60, 0)
	self.prompttext:SetVAlign(0)
	self.prompttext:SetHAlign(1)
	self.prompttext:SetColour(1 , .5 , 1 ,1)
	self.prompttext:MoveToFront()
	self.prompttext:Hide()

	self:InitKeyDownHandler()

	self:StartUpdating()
end)

function Explanation:InitKeyDownHandler()
	if #STRINGS.description[language] > 0 then
		self.explanationtext:SetString(STRINGS.description[language][showstrnumber])
		self.explanationtext:SetPosition(width / 3.5 , -height / 2, 0)
	end

 	TheInput:AddKeyDownHandler( KEY_F6 ,function( )
											if showexplanationtext then
												self.explanationtext:Show()
												self.prompttext:Show()
												showexplanationtext = false
												return
											end
											self.explanationtext:Hide()
											self.prompttext:Hide()
											showexplanationtext = true 
										end )
 	TheInput:AddKeyDownHandler( KEY_UP ,function( )
											if not showexplanationtext and #STRINGS.description[language] > showstrnumber then
												self.explanationtext:Hide()
												showstrnumber = showstrnumber + 1
												self.explanationtext:SetString(STRINGS.description[language][showstrnumber])
												self.explanationtext:Show()
											end
										end)
 	TheInput:AddKeyDownHandler( KEY_DOWN , function (  )
												if not showexplanationtext and #STRINGS.description[language] > 1 and showstrnumber > 1 then 
													self.explanationtext:Hide()
													showstrnumber = showstrnumber - 1
													self.explanationtext:SetString(STRINGS.description[language][showstrnumber])
													self.explanationtext:Show()
												end
											end )
 	TheInput:AddKeyDownHandler( KEY_L , function (  )
 												if showexplanationtext then return end
												self.explanationtext:Hide()
												if language == "chinese" then 
													language = "english"
												elseif language == "english" then
													language = "japanese"
												elseif language == "japanese" then
													language = "chinese"
												end
												if #STRINGS.description[language] >= showstrnumber then
													self.explanationtext:SetString(STRINGS.description[language][showstrnumber])
												else
													self.explanationtext:SetString(STRINGS.description[language][1])
												end
												self.explanationtext:Show()
											end )
end

function Explanation:OnUpdate(dt)
	self.timetext:SetString( os.date("%x", os.time()).."\n"..os.date("%X", os.time()) )
end

return Explanation
