PrefabFiles = {
	"yan",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/yan.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/yan.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/yan.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/yan.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/yan_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/yan_silho.xml" ),

    Asset( "IMAGE", "bigportraits/yan.tex" ),
    Asset( "ATLAS", "bigportraits/yan.xml" ),
	
	Asset( "IMAGE", "images/map_icons/yan.tex" ),
	Asset( "ATLAS", "images/map_icons/yan.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_yan.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_yan.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_yan.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_yan.xml" ),

}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS
local ACTIONS = GLOBAL.ACTIONS
local ActionHandler = GLOBAL.ActionHandler

-- The character select screen lines
STRINGS.CHARACTER_TITLES.yan = "Fire girl"
STRINGS.CHARACTER_NAMES.yan = "YAN"
STRINGS.CHARACTER_DESCRIPTIONS.yan = "*Not too hot?\n*Rubies heal the fire wand.\n*Eating monster meat does not lose spirit and blood."
STRINGS.CHARACTER_QUOTES.yan = "\",,,\""

-- Custom speech strings
STRINGS.CHARACTERS.YAN = require "speech_yan"

-- The character's name as appears in-game 
STRINGS.NAMES.YAN = "YAN"

-- The default responses of examining the character
STRINGS.CHARACTERS.GENERIC.DESCRIBE.YAN = 
{
	GENERIC = "It's YAN!",
	ATTACKER = "That YAN looks shifty...",
	MURDERER = "Murderer!",
	REVIVER = "YAN, friend of ghosts.",
	GHOST = "YAN could use a heart.",
}


AddMinimapAtlas("images/map_icons/yan.xml")

-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("yan", "FEMALE")

AddPrefabPostInit("redgem", function(inst)
    inst:AddComponent("sewing_staff")
    inst.components.sewing_staff.repair_value = 20
end)

local YANACTION = GLOBAL.Action({ priority=11})
YANACTION.id = "YANACTION"
YANACTION.str = "repair"

YANACTION.fn = function(act)
    local inv = act.invobject
    local tar = act.target
    if inv and inv.components.sewing_staff and tar and  tar.components.finiteuses then
        inv.components.sewing_staff:DoSewing(tar, act.doer)
    return true
	end  		
end
AddAction(YANACTION) 
AddComponentAction("USEITEM", "sewing_staff" , function(inst, doer, target, actions, right) 
	if right and     
	inst.components.sewing_staff and
	target.prefab == "firestaff" and  
    doer.prefab == "yan" then	 
    table.insert(actions, GLOBAL.ACTIONS.YANACTION)
    end
end)

AddStategraphActionHandler("wilson",ActionHandler(ACTIONS.YANACTION, "dolongaction"))
AddStategraphActionHandler("wilson_client",ActionHandler(ACTIONS.YANACTION, "dolongaction"))

