local assets=
{
	Asset("ANIM", "anim/yshanka.zip"),
	Asset("ATLAS", "images/inventoryimages/yshanka.xml")
}

local function onequip(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_hat", "yshanka", "swap_hat")
        owner.AnimState:Show("HAT")
        owner.AnimState:Show("HAT_HAIR")
        owner.AnimState:Hide("HAIR_NOHAT")
        owner.AnimState:Hide("HAIR")
		
		owner.components.inventory:SetOverflow(inst)
		inst.components.container:Open(owner)
end

local function onunequip(inst, owner) 
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")
		
		owner.components.inventory:SetOverflow(nil)
		inst.components.container:Close(owner)
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    inst:AddTag("hat")
    
    anim:SetBank("featherhat")
    anim:SetBuild("yshanka")
    anim:PlayAnimation("anim")    
        
    inst:AddComponent("inspectable")
    
    inst:AddTag("irreplaceable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/yshanka.xml"
    
    inst:AddComponent("dapperness")
    inst.components.dapperness.dapperness = TUNING.DAPPERNESS_MED 
    
	inst:AddComponent("insulator")
    inst.components.insulator.insulation = TUNING.INSULATION_LARGE
	
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	
    
    return inst
end

return Prefab( "common/inventory/yshanka", fn, assets) 
