/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.testin.itestin.util.Utils;
import org.apache.log4j.Logger;

public class BridgeUtils {
    static Logger log = Logger.getLogger(BridgeUtils.class);
    public static AndroidDebugBridge bridge = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IDevice getDevice(String serialno) {
        if (bridge == null) {
            BridgeUtils.getDebugBridge();
        }
        try {
            int deviceNumber;
            IDevice[] devices;
            block9: {
                int count = 0;
                do {
                    if (bridge.hasInitialDeviceList()) {
                        devices = bridge.getDevices();
                        deviceNumber = devices.length;
                        if (deviceNumber == 0) {
                            log.info((Object)"No devices found!");
                            return null;
                        }
                        break block9;
                    }
                    Utils.sleep(500L);
                } while (++count <= 10);
                log.error((Object)"Timeout getting device list!");
                return null;
            }
            int i = 0;
            while (true) {
                if (i >= deviceNumber) {
                    log.info((Object)("Cannot find device " + serialno));
                    return null;
                }
                if (devices[i].toString().equals(serialno)) {
                    return devices[i];
                }
                ++i;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return null;
    }

    public static AndroidDebugBridge getDebugBridge() {
        if (bridge != null) {
            return bridge;
        }
        String adbLocation = "adb";
        try {
            AndroidDebugBridge.init((boolean)false);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        try {
            bridge = AndroidDebugBridge.createBridge((String)adbLocation, (boolean)true);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return bridge;
    }

    public static void closeBridge() {
        if (bridge != null) {
            AndroidDebugBridge.terminate();
        }
    }
}

