/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbCommandRejectedException;
import com.testin.itestin.device.DeviceInfo;
import com.testin.itestin.os.Message;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.log4j.Logger;

public class DeviceConnection {
    static Logger log = Logger.getLogger(DeviceConnection.class);
    private DeviceInfo deviceInfo;
    private static int DEFAULT_VIEW_SERVER_PORT;
    private static int mNextLocalPort;
    private int localPort = mNextLocalPort++;
    private int remotePort = 10321;
    private InetSocketAddress sSocketAddr;

    static {
        mNextLocalPort = DEFAULT_VIEW_SERVER_PORT = 10321;
    }

    public DeviceConnection(DeviceInfo deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public Message createForward() {
        Message mag = new Message();
        try {
            if (this.deviceInfo != null && this.deviceInfo.getDevice() != null) {
                this.deviceInfo.getDevice().createForward(this.localPort, this.remotePort);
                InetAddress addr = InetAddress.getByName("127.0.0.1");
                this.sSocketAddr = new InetSocketAddress(addr, this.localPort);
            }
        }
        catch (Exception e) {
            mag.setStatus(20);
            mag.setContent(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return mag;
    }

    public InetSocketAddress getSocketAddress() {
        return this.sSocketAddr;
    }

    public void removeForward() {
        try {
            if (this.deviceInfo != null && this.deviceInfo.getDevice() != null) {
                this.deviceInfo.getDevice().removeForward(this.localPort, this.remotePort);
            }
        }
        catch (AdbCommandRejectedException e) {
            log.error((Object)"Unable to remove tcp port forward");
        }
        catch (Exception e) {
            log.error((Object)"Unable to remove tcp port forward", (Throwable)e);
        }
    }
}

