/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.testin.itestin.device.DeviceInfo;
import com.testin.itestin.os.Message;
import com.testin.itestin.shell.MultiLineReceiver;
import com.testin.itestin.threadpool.ThreadPool;
import com.testin.itestin.util.Utils;
import org.apache.log4j.Logger;

public class MonkeyRunner
extends MultiLineReceiver {
    static Logger log = Logger.getLogger(MonkeyRunner.class);
    final int SVR_PORT = 10320;
    final int TIME_OUT = 1800000;
    final int CONN_TIME_OUT = 30000;
    private boolean isCancelled;
    private DeviceInfo deviceInfo;
    private StringBuffer buffer = new StringBuffer();
    private MultiLineReceiver outputReceiver;

    public MonkeyRunner(DeviceInfo deviceInfo, MultiLineReceiver outputReceiver) {
        this.deviceInfo = deviceInfo;
        this.outputReceiver = outputReceiver;
    }

    public boolean waitForConnection() {
        Thread t = new Thread("RunMonkey"){

            @Override
            public void run() {
                String command = MonkeyRunner.this.getCommand();
                log.info((Object)String.format("Running monkey with command %s", command));
                MonkeyRunner.this.deviceInfo.getDeviceShell().executeShellCommand(command, MonkeyRunner.this, 1800000);
                Utils.gc();
            }
        };
        ThreadPool.execute(t);
        boolean res = false;
        long st = System.currentTimeMillis();
        while (System.currentTimeMillis() - st < 30000L && !(res = this.isConnected())) {
            Utils.sleep(2000L);
        }
        return res;
    }

    public boolean isConnected() {
        String res;
        String command = "netstat -ano";
        Message msg = this.deviceInfo.getDeviceShell().executeShellCommand(command, 10000);
        String string = res = msg.getContent() == null ? "" : msg.getContent().toString();
        if (msg.getStatus() == 0) {
            String[] strs;
            String[] stringArray = strs = res.split("\r\n");
            int n = strs.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.indexOf(":10320") != -1 && s.indexOf("LISTEN") != -1) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public void disConnection() {
        this.isCancelled = true;
    }

    private String getCommand() {
        int sdkVer = this.deviceInfo.getSdkVer();
        String cmd = null;
        cmd = sdkVer > 7 ? "monkey -v -v --ignore-crashes --ignore-timeouts --ignore-security-exceptions --ignore-native-crashes --port 10320" : "monkey -v -v --ignore-crashes --ignore-timeouts --ignore-security-exceptions --port 10320";
        return cmd;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void processNewLines(String[] arg0) {
        String[] stringArray = arg0;
        int n = arg0.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.buffer.append(s);
            this.buffer.append("\r\n");
            ++n2;
        }
        if (this.outputReceiver != null) {
            this.outputReceiver.processNewLines(arg0);
        }
    }

    public String getMonkeyLog() {
        return this.buffer.toString();
    }
}

