/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.testin.itestin.util.Utils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.apache.log4j.Logger;

public final class TestinAdbHelper {
    static Logger log = Logger.getLogger(TestinAdbHelper.class);
    static final int WAIT_TIME = 5;
    static final String DEFAULT_ENCODING = "utf-8";

    private TestinAdbHelper() {
    }

    static byte[] formAdbRequest(String req) {
        byte[] result;
        String resultStr = String.format("%04X%s", req.length(), req);
        try {
            result = resultStr.getBytes(DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException uee) {
            log.error((Object)uee.getMessage(), (Throwable)uee);
            return null;
        }
        assert (result.length == req.length() + 4);
        return result;
    }

    static boolean isOkay(byte[] reply) {
        return reply[0] == 79 && reply[1] == 75 && reply[2] == 65 && reply[3] == 89;
    }

    static String replyToString(byte[] reply) {
        String result;
        try {
            result = new String(reply, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException uee) {
            log.error((Object)uee.getMessage(), (Throwable)uee);
            result = "";
        }
        return result;
    }

    static void read(SocketChannel chan, byte[] data) throws TimeoutException, IOException {
        TestinAdbHelper.read(chan, data, -1, DdmPreferences.getTimeOut());
    }

    static void read(SocketChannel chan, byte[] data, int length, int timeout) throws TimeoutException, IOException {
        ByteBuffer buf = ByteBuffer.wrap(data, 0, length != -1 ? length : data.length);
        int numWaits = 0;
        while (buf.position() != buf.limit()) {
            int count = chan.read(buf);
            if (count < 0) {
                Log.d((String)"ddms", (String)"read: channel EOF");
                throw new IOException("EOF");
            }
            if (count == 0) {
                if (timeout != 0 && numWaits * 5 > timeout) {
                    Log.d((String)"ddms", (String)"read: timeout");
                    throw new TimeoutException();
                }
                Utils.sleep(5L);
                ++numWaits;
                continue;
            }
            numWaits = 0;
        }
    }

    static void write(SocketChannel chan, byte[] data) throws TimeoutException, IOException {
        TestinAdbHelper.write(chan, data, -1, DdmPreferences.getTimeOut());
    }

    static void write(SocketChannel chan, byte[] data, int length, int timeout) throws TimeoutException, IOException {
        ByteBuffer buf = ByteBuffer.wrap(data, 0, length != -1 ? length : data.length);
        int numWaits = 0;
        while (buf.position() != buf.limit()) {
            int count = chan.write(buf);
            if (count < 0) {
                Log.d((String)"ddms", (String)"write: channel EOF");
                throw new IOException("channel EOF");
            }
            if (count == 0) {
                if (timeout != 0 && numWaits * 5 > timeout) {
                    Log.d((String)"ddms", (String)"write: timeout");
                    throw new TimeoutException();
                }
                Utils.sleep(5L);
                ++numWaits;
                continue;
            }
            numWaits = 0;
        }
    }

    static AdbHelper.AdbResponse readAdbResponse(SocketChannel chan, boolean readDiagString) throws TimeoutException, IOException {
        AdbHelper.AdbResponse resp;
        block6: {
            resp = new AdbHelper.AdbResponse();
            byte[] reply = new byte[4];
            TestinAdbHelper.read(chan, reply);
            if (TestinAdbHelper.isOkay(reply)) {
                resp.okay = true;
            } else {
                readDiagString = true;
                resp.okay = false;
            }
            try {
                int len;
                if (!readDiagString) break block6;
                byte[] lenBuf = new byte[4];
                TestinAdbHelper.read(chan, lenBuf);
                String lenStr = TestinAdbHelper.replyToString(lenBuf);
                try {
                    len = Integer.parseInt(lenStr, 16);
                }
                catch (NumberFormatException nfe) {
                    log.warn((Object)("DDMS Expected digits, got '" + lenStr + "': " + lenBuf[0] + " " + lenBuf[1] + " " + lenBuf[2] + " " + lenBuf[3]));
                    log.warn((Object)("DDMS reply was " + TestinAdbHelper.replyToString(reply)));
                    break block6;
                }
                byte[] msg = new byte[len];
                TestinAdbHelper.read(chan, msg);
                resp.message = TestinAdbHelper.replyToString(msg);
                log.debug((Object)("DDMS Got reply '" + TestinAdbHelper.replyToString(reply) + "', diag='" + resp.message + "'"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return resp;
    }

    public static void executeRemoteCommand(InetSocketAddress adbSockAddr, String command, IDevice device, IShellOutputReceiver rcvr, int maxTimeToOutputResponse) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        log.debug((Object)("DDMS execute: running " + command));
        SocketChannel adbChan = null;
        try {
            try {
                adbChan = SocketChannel.open(adbSockAddr);
                adbChan.configureBlocking(false);
                byte[] request = TestinAdbHelper.formAdbRequest(command);
                TestinAdbHelper.write(adbChan, request);
                AdbHelper.AdbResponse resp = TestinAdbHelper.readAdbResponse(adbChan, false);
                if (!resp.okay) {
                    log.error((Object)("DDMS ADB rejected shell command (" + command + "): " + resp.message));
                    throw new AdbCommandRejectedException(resp.message);
                }
                byte[] data = new byte[524288];
                ByteBuffer buf = ByteBuffer.wrap(data);
                int timeToResponseCount = 0;
                while (true) {
                    if (rcvr != null && rcvr.isCancelled()) {
                        log.debug((Object)"DDMS execute: cancelled");
                        break;
                    }
                    int count = adbChan.read(buf);
                    if (count < 0) {
                        rcvr.flush();
                        log.debug((Object)("DDMS execute '" + command + "' on '" + device + "' : EOF hit. Read: " + count));
                        break;
                    }
                    if (count == 0) {
                        int wait = 25;
                        if (maxTimeToOutputResponse > 0 && (timeToResponseCount += wait) > maxTimeToOutputResponse) {
                            throw new ShellCommandUnresponsiveException();
                        }
                        Utils.sleep(wait);
                        continue;
                    }
                    timeToResponseCount = 0;
                    if (rcvr != null) {
                        rcvr.addOutput(buf.array(), buf.arrayOffset(), buf.position());
                    }
                    buf.rewind();
                }
            }
            catch (IOException e) {
                log.warn((Object)e);
                if (adbChan != null) {
                    adbChan.close();
                }
                log.debug((Object)"DDMS execute: returning");
            }
        }
        finally {
            if (adbChan != null) {
                adbChan.close();
            }
            log.debug((Object)"DDMS execute: returning");
        }
    }
}

