/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.BridgeUtils;
import com.android.ddmlib.DeviceConnection;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.TestinAdbHelper;
import com.testin.itestin.device.DeviceInfo;
import com.testin.itestin.device.DevicesManager;
import com.testin.itestin.os.Message;
import com.testin.itestin.shell.ShellExecutor;
import com.testin.itestin.util.MD5;
import com.testin.itestin.util.Utils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ViewClient {
    static Logger log = Logger.getLogger(ViewClient.class);
    private boolean isCancelled = false;
    private boolean isRunning = false;
    private DeviceInfo deviceInfo = null;
    private DeviceConnection deviceConnection = null;
    private static ViewClient mViewClient = null;
    private static String lastWindowInfo = "";
    private static String lastWindowInfoMD5 = "";
    private static String currentWindowInfo = "";

    public static String getWindowInfoFromDevice() {
        String windowinfo;
        ViewClient viewclient = ViewClient.getViewClient();
        if (viewclient == null) {
            lastWindowInfo = "";
            lastWindowInfoMD5 = "";
            return "";
        }
        lastWindowInfo = windowinfo = viewclient.fetchWindowInfo(lastWindowInfoMD5).getContent();
        if (!windowinfo.equals("0") && StringUtils.isNotEmpty((String)windowinfo)) {
            lastWindowInfoMD5 = MD5.md5(windowinfo);
            currentWindowInfo = windowinfo;
        }
        return windowinfo;
    }

    public static String getLastWindowInfo() {
        return lastWindowInfo;
    }

    public static String getCurrentWindowInfo() {
        return currentWindowInfo;
    }

    public static void removeOldWindowInfo() {
        lastWindowInfo = "";
    }

    public static Message runCommand(String command) {
        ViewClient viewclient = ViewClient.getViewClient();
        if (viewclient == null) {
            return new Message();
        }
        return viewclient.runCmd(command);
    }

    public static boolean stopViewClient() {
        if (mViewClient != null) {
            return mViewClient.stop();
        }
        return true;
    }

    private static ViewClient getViewClient() {
        DeviceInfo device = DevicesManager.getDevice();
        if (device == null || device.getDevice() == null || !device.getDevice().isOnline()) {
            return null;
        }
        if (mViewClient == null) {
            mViewClient = new ViewClient(device);
        }
        if (!mViewClient.isRunning()) {
            mViewClient.start();
        }
        if (mViewClient.isRunning()) {
            return mViewClient;
        }
        return null;
    }

    private ViewClient(DeviceInfo deviceInfo) {
        if (deviceInfo == null) {
            log.error((Object)"Device is null, unable to initialize ViewClient");
            return;
        }
        this.deviceInfo = deviceInfo;
        this.deviceConnection = new DeviceConnection(deviceInfo);
        log.info((Object)("ViewClient initialized for device " + deviceInfo));
    }

    public boolean start() {
        Message msg = this.deviceConnection.createForward();
        boolean bl = this.isRunning = msg.getStatus() == 0;
        if (this.isRunning) {
            log.info((Object)"Start running view client.");
        } else {
            log.info((Object)"View client unable to start.");
        }
        return this.isRunning;
    }

    public boolean isRunning() {
        return this.isRunning && !this.isCancelled;
    }

    public Message runCmd(String command) {
        Message msg = new Message();
        ShellExecutor.DefaultShellOutputReceiver rcvr = new ShellExecutor.DefaultShellOutputReceiver();
        try {
            Base64 base64 = new Base64(2048);
            byte[] data = base64.encode(command.getBytes("utf-8"));
            String cmd = new String(data, "utf-8");
            String runcmd = String.format("runcmd %s", cmd);
            TestinAdbHelper.executeRemoteCommand(this.deviceConnection.getSocketAddress(), runcmd, this.deviceInfo.getDevice(), rcvr, 60000);
            msg.setContent(rcvr.getOutput());
            log.info((Object)String.format("Run CMD Sucessful: %s\nResult: %s", command, msg.getContent()));
        }
        catch (Exception ex) {
            msg.setStatus(20);
            msg.setContent(ex.getMessage());
            log.error((Object)String.format("Run CMD Failed: %s, Error Msg: %s", command, ex.getMessage()), (Throwable)ex);
        }
        return msg;
    }

    public Message fetchWindowInfo() {
        return this.fetchWindowInfo(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Message fetchWindowInfo(String lastWindowInfoMD5) {
        Message message;
        Message msg;
        long t1;
        block10: {
            t1 = System.currentTimeMillis();
            msg = new Message();
            log.debug((Object)("Fetching window info..., current MD5: " + lastWindowInfoMD5));
            if (!Utils.IS_SYNCING_SCREEN) break block10;
            log.debug((Object)"PC Client is syncing screen. Ignore this request.");
            Message message2 = msg;
            long t2 = System.currentTimeMillis();
            log.debug((Object)String.format("fetching window info consumed %s ms", t2 - t1));
            return message2;
        }
        try {
            block12: {
                String command = "viewfetcher";
                if (lastWindowInfoMD5 != null && !lastWindowInfoMD5.equals("")) {
                    command = String.format("%s %s", command, lastWindowInfoMD5);
                }
                ShellExecutor.DefaultShellOutputReceiver rcvr = new ShellExecutor.DefaultShellOutputReceiver();
                try {
                    try {
                        TestinAdbHelper.executeRemoteCommand(this.deviceConnection.getSocketAddress(), command, this.deviceInfo.getDevice(), rcvr, 60000);
                        msg.setContent(rcvr.getOutput());
                        log.debug((Object)String.format("fetch window info successfully, with content size %d", msg.getContent().length()));
                        log.debug((Object)msg.getContent());
                    }
                    catch (Exception ex) {
                        msg.setStatus(20);
                        msg.setContent(ex.getMessage());
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                        rcvr = null;
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    rcvr = null;
                    throw throwable;
                }
                rcvr = null;
            }
            message = msg;
        }
        catch (Exception e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                long t2 = System.currentTimeMillis();
                log.debug((Object)String.format("fetching window info consumed %s ms", t2 - t1));
                throw throwable;
            }
            long t2 = System.currentTimeMillis();
            log.debug((Object)String.format("fetching window info consumed %s ms", t2 - t1));
            return msg;
        }
        long t2 = System.currentTimeMillis();
        log.debug((Object)String.format("fetching window info consumed %s ms", t2 - t1));
        return message;
    }

    public boolean stop() {
        String runcmd = "stopserver";
        ShellExecutor.DefaultShellOutputReceiver rcvr = new ShellExecutor.DefaultShellOutputReceiver();
        try {
            log.info((Object)"stop view server on device.");
            TestinAdbHelper.executeRemoteCommand(this.deviceConnection.getSocketAddress(), runcmd, this.deviceInfo.getDevice(), rcvr, 60000);
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        this.deviceConnection.removeForward();
        this.isCancelled = true;
        return true;
    }

    public static void main(String[] args) {
        String serialno = "R32DA07NC1Z[18D1_4EE2]";
        new DeviceInfo.Factory();
        DeviceInfo deviceinfo = DeviceInfo.Factory.newInstance(serialno);
        IDevice idevice = BridgeUtils.getDevice(serialno);
        log.info((Object)idevice);
        deviceinfo.setDevice(idevice);
        ViewClient viewclient = new ViewClient(deviceinfo);
        viewclient.start();
        Message msg = viewclient.fetchWindowInfo("49fc93db6ccbb3b3491cc3b61511f87c");
        log.info((Object)msg.getContent().toString());
        log.info((Object)MD5.stringToMD5(msg.getContent()));
        BridgeUtils.closeBridge();
    }
}

