/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.api.serviceimp;

import com.alibaba.fastjson.JSONObject;
import com.testin.itestin.api.bean.CloudInfoReq;
import com.testin.itestin.api.bean.CloudInfoRes;
import com.testin.itestin.api.bean.CtFileUploadReq;
import com.testin.itestin.api.bean.CtFileUploadRes;
import com.testin.itestin.api.bean.DispatchInfoReq;
import com.testin.itestin.api.bean.DispatchInfoRes;
import com.testin.itestin.api.bean.LoginReq;
import com.testin.itestin.api.bean.LoginRes;
import com.testin.itestin.api.bean.UserInfoReq;
import com.testin.itestin.api.bean.UserInfoRes;
import com.testin.itestin.api.service.HttpFilterService;
import com.testin.itestin.api.service.JsonProxy;
import com.testin.itestin.api.serviceimp.SdHttpFilterServiceImp;
import com.testin.itestin.api.util.FileUploadObserver;
import com.testin.itestin.api.util.HttpClientUtil;
import com.testin.itestin.api.util.Sig;
import com.testin.itestin.common.Constants;
import java.util.List;
import org.apache.log4j.Logger;

public class SdJsonProxyImp
implements JsonProxy {
    static Logger log = Logger.getLogger(SdJsonProxyImp.class);
    private static HttpFilterService httpFilter = new SdHttpFilterServiceImp();

    private Object postSdJsonData(Class<?> reqBeanClass, Class<?> resBeanClass, Object reqObj, String action, String jsonurl) throws Exception {
        String sig = Sig.getSig(reqObj, Constants.SD_KEY_SECRET);
        try {
            reqBeanClass.getMethod("setSig", String.class).invoke(reqObj, sig);
            String json = JSONObject.toJSONString((Object)reqObj);
            httpFilter.requestChain(json);
            String res = HttpClientUtil.postJsonData(json, action, jsonurl);
            httpFilter.responseChain(res);
            Object resObj = JSONObject.parseObject((String)res, resBeanClass);
            return resObj;
        }
        catch (Exception e) {
            log.error((Object)(String.valueOf(jsonurl) + "postSdJsonData>>>"), (Throwable)e);
            throw new Exception(e);
        }
    }

    @Override
    public Object postJsonData(Class<?> reqBeanClass, Class<?> resBeanClass, Object reqObj, String action) {
        Object resObj = null;
        List<DispatchInfoRes.DispatchesData> dispatches = Constants.getDispatchesData_dis();
        for (DispatchInfoRes.DispatchesData dispatchesData : dispatches) {
            String ip = dispatchesData.externalIp;
            Integer port = dispatchesData.externalPort;
            String https = Constants.HTTP;
            String posturl = String.format("%s://%s:%s/", https, ip, port);
            resObj = this.postData(reqBeanClass, resBeanClass, reqObj, action, posturl);
            if (resObj != null) break;
        }
        return resObj;
    }

    private Object postData(Class<?> reqBeanClass, Class<?> resBeanClass, Object reqObj, String action, String jsonurl) {
        String sig = Sig.getSig(reqObj, Constants.SD_KEY_SECRET);
        try {
            reqBeanClass.getMethod("setSig", String.class).invoke(reqObj, sig);
            String json = JSONObject.toJSONString((Object)reqObj);
            httpFilter.requestChain(json);
            String res = HttpClientUtil.postJsonData(json, action, jsonurl);
            httpFilter.responseChain(res);
            Object resObj = JSONObject.parseObject((String)res, resBeanClass);
            return resObj;
        }
        catch (Exception e) {
            log.error((Object)(String.valueOf(jsonurl) + "postData>>>"), (Throwable)e);
            return null;
        }
    }

    @Override
    public Object postJsonFile(Class<?> reqBeanClass, Class<?> resBeanClass, Object reqObj, String filePath, FileUploadObserver fileUploadObserver, String action) {
        Object resObj = null;
        List<DispatchInfoRes.FsesData> fses = Constants.getFsesData_dis();
        for (DispatchInfoRes.FsesData fsesData : fses) {
            if (fileUploadObserver != null && fileUploadObserver.isCanceled()) break;
            String ip = fsesData.externalIp;
            Integer port = fsesData.externalPort;
            String posturl = String.format("%s://%s:%s/", Constants.HTTP, ip, port);
            resObj = this.postFile(reqBeanClass, resBeanClass, reqObj, filePath, fileUploadObserver, posturl, action);
            if (resObj != null) break;
        }
        return resObj;
    }

    private Object postFile(Class<?> reqBeanClass, Class<?> resBeanClass, Object reqObj, String filePath, FileUploadObserver fileUploadObserver, String jsonurl, String action) {
        String sig = Sig.getSig(reqObj, Constants.SD_KEY_SECRET);
        try {
            reqBeanClass.getMethod("setSig", String.class).invoke(reqObj, sig);
            String json = JSONObject.toJSONString((Object)reqObj);
            httpFilter.requestChain(json);
            String res = HttpClientUtil.postJsonFile(json, filePath, fileUploadObserver, jsonurl, action);
            httpFilter.responseChain(res);
            Object resObj = JSONObject.parseObject((String)res, resBeanClass);
            return resObj;
        }
        catch (Exception e) {
            log.error((Object)(String.valueOf(jsonurl) + "postFile>>>"), (Throwable)e);
            return null;
        }
    }

    @Override
    public LoginRes login(LoginReq loginReq) throws Exception {
        loginReq.apikey = Constants.SD_KEY_API;
        loginReq.op = Constants.SD_OP_USER_LOGIN;
        LoginRes resObj = (LoginRes)this.postSdJsonData(LoginReq.class, LoginRes.class, loginReq, Constants.SD_ACTION_LOGIN, Constants.SD_JSON_URL);
        return resObj;
    }

    @Override
    public CloudInfoRes CloudInfo(String name) throws Exception {
        CloudInfoReq cloudInfoReq = new CloudInfoReq();
        cloudInfoReq.name = name;
        CloudInfoRes resObj = (CloudInfoRes)this.postJsonData(CloudInfoReq.class, CloudInfoRes.class, cloudInfoReq, Constants.CC_ACTION_USER);
        return resObj;
    }

    @Override
    public UserInfoRes userInfo(String email) throws Exception {
        UserInfoReq userInfoReq = new UserInfoReq();
        userInfoReq.apikey = Constants.SD_KEY_API;
        userInfoReq.op = Constants.SD_OP_CLOUD_ID;
        userInfoReq.email = email;
        UserInfoRes resObj = (UserInfoRes)this.postJsonData(UserInfoReq.class, UserInfoRes.class, userInfoReq, Constants.CI_ACTION_USER);
        return resObj;
    }

    @Override
    public CtFileUploadRes fileUpload(CtFileUploadReq ctFileUploadReq, String filePath, FileUploadObserver fileUploadObserver) {
        ctFileUploadReq.apikey = Constants.SD_KEY_API;
        ctFileUploadReq.op = Constants.SD_OP_CT_FILE_UPLOAD;
        CtFileUploadRes res = (CtFileUploadRes)this.postJsonFile(CtFileUploadReq.class, CtFileUploadRes.class, ctFileUploadReq, filePath, fileUploadObserver, Constants.SD_ACTON_CT_FILE);
        return res;
    }

    @Override
    public DispatchInfoRes dispatchList(DispatchInfoReq dispatchInfoReq) throws Exception {
        dispatchInfoReq.apikey = Constants.SD_KEY_API;
        dispatchInfoReq.op = Constants.SD_OP_DISPATCH_LIST;
        DispatchInfoRes resObj = (DispatchInfoRes)this.postSdJsonData(DispatchInfoReq.class, DispatchInfoRes.class, dispatchInfoReq, Constants.SD_ACTION_MCFG, Constants.SD_JSON_URL);
        return resObj;
    }
}

