/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.api.util;

import com.testin.itestin.api.util.FileUploadObserver;
import com.testin.itestin.common.Proxy;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.log4j.Logger;

public class HttpClientUtil {
    static Logger log = Logger.getLogger(HttpClientUtil.class);
    private static int ConnectTimeout = 300000;
    private static int ReadTimeout = 300000;
    private static TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }};

    public static String postJsonData(String json, String action, String jsonurl) throws HttpException, IOException {
        Proxy.setProxy();
        StringBuffer buffer = new StringBuffer();
        URL url = null;
        String strurl = String.valueOf(jsonurl) + action;
        HttpURLConnection conn = null;
        try {
            url = new URL(strurl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setConnectTimeout(ConnectTimeout);
            conn.setReadTimeout(ReadTimeout);
            conn.setRequestMethod("POST");
            conn.setUseCaches(false);
            conn.connect();
            PrintWriter outprint = new PrintWriter(new OutputStreamWriter(conn.getOutputStream(), "UTF-8"));
            outprint.write(json);
            outprint.flush();
            outprint.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            String line = "";
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            reader.close();
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return buffer.toString();
    }

    protected static String readByteStream(BufferedInputStream in, String encode) throws IOException {
        byte[] buf;
        int num;
        LinkedList<mybuf> bufList = new LinkedList<mybuf>();
        int size = 0;
        while ((num = in.read(buf = new byte[128])) != -1) {
            size += num;
            bufList.add(new mybuf(buf, num));
        }
        buf = new byte[size];
        int pos = 0;
        ListIterator p = bufList.listIterator();
        while (p.hasNext()) {
            mybuf b = (mybuf)p.next();
            int i = 0;
            while (i < b.size) {
                buf[pos] = b.buf[i];
                ++i;
                ++pos;
            }
        }
        return new String(buf, encode);
    }

    public static String postJsonFile(String json, String filePath, FileUploadObserver fileUploadObserver, String jsonurl, String action) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        if (fileUploadObserver != null && fileUploadObserver.isCanceled()) {
            return null;
        }
        Proxy.setProxy();
        String postUrl = String.valueOf(jsonurl) + action;
        if (postUrl.startsWith("https")) {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        URL url = new URL(postUrl);
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.setConnectTimeout(ConnectTimeout);
        httpConn.setReadTimeout(ReadTimeout);
        httpConn.setDoOutput(true);
        httpConn.setDoInput(true);
        httpConn.setRequestMethod("POST");
        int buffer_size = 0x100000;
        if (Proxy.proxyType == 0) {
            httpConn.setChunkedStreamingMode(buffer_size);
        }
        httpConn.setRequestProperty("UPLOAD-JSON", json);
        httpConn.setRequestProperty("accept", "*/*");
        out = new BufferedOutputStream(httpConn.getOutputStream());
        byte[] buffer = new byte[buffer_size];
        int insize = 0;
        long transferred = 0L;
        FileInputStream fis = null;
        File f = new File(filePath);
        long total = f.length();
        try {
            String result;
            fis = new FileInputStream(filePath);
            while (!(fileUploadObserver != null && fileUploadObserver.isCanceled() || (insize = fis.read(buffer)) == -1)) {
                out.write(buffer, 0, insize);
                transferred += (long)insize;
                if (fileUploadObserver == null) continue;
                fileUploadObserver.transferred(total, transferred);
            }
            fis.close();
            fis = null;
            out.flush();
            out.close();
            out = null;
            in = new BufferedInputStream(httpConn.getInputStream());
            String string = result = HttpClientUtil.readByteStream(in, "UTF-8");
            return string;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private static class mybuf {
        public byte[] buf;
        public int size;

        public mybuf(byte[] b, int s) {
            this.buf = b;
            this.size = s;
        }
    }
}

