/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.bar;

import com.testin.itestin.bar.buildfile.AndroidManifest;
import com.testin.itestin.bar.buildfile.ClassPath;
import com.testin.itestin.bar.buildfile.Prefs;
import com.testin.itestin.bar.buildfile.Project;
import com.testin.itestin.bar.buildfile.ProjectProperties;
import com.testin.itestin.bar.buildfile.Setting;
import com.testin.itestin.bar.buildfile.TestCase;
import com.testin.itestin.bar.buildfile.TestImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ProjectBuilder {
    static Logger log = Logger.getLogger(ProjectBuilder.class);

    public static void main(String[] args) throws IOException {
        TestCase testCase = new TestCase();
        testCase.setTargetPackage("com.example.android.apis");
        testCase.setLauncherActivity("com.example.android.apis.ApiDemos");
        testCase.setPackageName("com.testin.itestin");
        testCase.setClassName("Test_01");
        testCase.setMethodName("test_01");
        testCase.setActions("");
        log.info((Object)testCase.toString());
        Setting setting = new Setting();
        setting.workspace = "f:\\build\\test";
        setting.projectName = "com.testin.android.test";
        setting.packageName = "com.testin.android.test";
        setting.targetPackage = "com.testin.android";
        setting.instrumentation = "com.testin.itestin.TestRunner";
        setting.jars = new String[]{"robotium-solo-5.1.jar", "test.jar"};
        ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        setting.testCases = testCases;
        testCases.add(testCase);
        ProjectBuilder.build(setting);
    }

    public static void build(Setting setting) throws IOException {
        ProjectBuilder.mkdirs(setting.workspace);
        Project project = Project.Factory.newInstance(setting.packageName);
        ProjectBuilder.write(String.valueOf(setting.workspace) + File.separator + project.NAME, project.content);
        ProjectProperties properties = ProjectProperties.Factory.newInstance();
        ProjectBuilder.write(String.valueOf(setting.workspace) + File.separator + properties.NAME, properties.content);
        ClassPath classPath = ClassPath.Factory.newInstance(setting.jars);
        ProjectBuilder.write(String.valueOf(setting.workspace) + File.separator + classPath.NAME, classPath.content);
        AndroidManifest manifest = AndroidManifest.Factory.newInstance(setting.instrumentation, setting.packageName, setting.targetPackage);
        ProjectBuilder.write(String.valueOf(setting.workspace) + File.separator + manifest.NAME, manifest.content);
        Prefs prefs = Prefs.Factory.newInstance();
        ProjectBuilder.write(String.valueOf(setting.workspace) + File.separator + ".settings" + File.separator + prefs.NAME, prefs.content);
        if (setting.testCases != null) {
            for (TestCase testCase : setting.testCases) {
                String pkg = testCase.getPackageName();
                String javapath = pkg.replace(".", File.separator);
                javapath = String.valueOf(setting.workspace) + File.separator + "src" + File.separator + javapath + File.separator + testCase.getClassName() + ".java";
                ProjectBuilder.write(javapath, testCase.toString());
            }
        }
        if (setting.testImages != null) {
            for (TestImage testImage : setting.testImages) {
                String imagepath = String.valueOf(setting.workspace) + File.separator + "pics" + testImage.name;
                ProjectBuilder.write(imagepath, testImage.data);
            }
        }
    }

    private static void mkdirs(String workspace) {
        File res;
        File libs;
        File src;
        File dir = new File(workspace);
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdirs();
        }
        if (!(src = new File(String.valueOf(workspace) + File.separator + "src")).exists() || !src.isDirectory()) {
            src.mkdirs();
        }
        if (!(libs = new File(String.valueOf(workspace) + File.separator + "libs")).exists() || !libs.isDirectory()) {
            libs.mkdirs();
        }
        if (!(res = new File(String.valueOf(workspace) + File.separator + "res")).exists() || !res.isDirectory()) {
            res.mkdirs();
        }
    }

    private static void write(String path, String content) throws IOException {
        byte[] data = content.getBytes("utf-8");
        ProjectBuilder.write(path, data);
    }

    private static void write(String path, byte[] data) throws IOException {
        File dir = new File(path).getParentFile();
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdirs();
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(path);
            fos.write(data);
            fos.flush();
            fos.close();
            fos = null;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                    fos = null;
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

