/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.business;

import com.testin.itestin.business.KeyStore;
import com.testin.itestin.business.SingleTestCase;
import com.testin.itestin.business.TestFileUtils;
import com.testin.itestin.device.tools.ApkTool;
import com.testin.itestin.device.tools.IconUtil;
import com.testin.itestin.entitys.ApplicationInfo;
import com.testin.itestin.os.Message;
import com.testin.javafx.Main;
import com.testin.javafx.ui.control.DetailsDialog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BizUtils {
    public static final String SCRIPT_FOLDER_SUFFIX = "_dir";
    public static final String TESTCASENAME = "testCase.xml";
    static Logger log = Logger.getLogger(BizUtils.class);

    public static void parseApplicationToSTC(ApplicationInfo appInfo) {
        SingleTestCase.getInstance().setActname(appInfo.getStartPath());
        SingleTestCase.getInstance().setAppName(appInfo.getAppName());
        SingleTestCase.getInstance().setPkgname(appInfo.getPackageName());
        SingleTestCase.getInstance().setVersion(appInfo.getVersionName());
        SingleTestCase.getInstance().setPkgPath(appInfo.getFilePath());
    }

    public static void handleWorkFolder(String rootPath, String md5) {
        File file_dir = new File(rootPath);
        if (!file_dir.exists()) {
            file_dir.mkdir();
        } else {
            StringBuffer buffer = new StringBuffer();
            try {
                FileInputStream is = new FileInputStream(TestFileUtils.getAppInfoPath(rootPath));
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    line = reader.readLine();
                }
                reader.close();
                ((InputStream)is).close();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (!buffer.toString().contains(md5)) {
                String[] filelist = file_dir.list();
                int i = 0;
                while (i < filelist.length) {
                    File delfile = new File(String.valueOf(rootPath) + File.separator + filelist[i]);
                    if (!delfile.isDirectory()) {
                        delfile.delete();
                    }
                    ++i;
                }
            }
        }
    }

    public static boolean isMalfunctionApk(ApplicationInfo appInfo) {
        Message appMsg = appInfo.getMsg();
        if (StringUtils.isEmpty((String)appInfo.getPackageName()) || StringUtils.isEmpty((String)appInfo.getStartPath())) {
            if (!"".equals(appMsg.getContent())) {
                if (appMsg.getContent().contains("signature matching")) {
                    DetailsDialog.show(String.format("%s %s", Main.getInternationalString("recordsetcontroller.threadHandler.invalidapp"), Main.getInternationalString("waitfinish.signature.not.match")), appMsg.getContent());
                }
                if (appMsg.getContent().contains("Process crashed")) {
                    DetailsDialog.show(String.format("%s %s", Main.getInternationalString("recordsetcontroller.threadHandler.invalidapp"), Main.getInternationalString("waitfinish.app.crash")), appMsg.getContent());
                }
            } else {
                DetailsDialog.show(Main.getInternationalString("recordsetcontroller.threadHandler.invalidapp"), "Package name or launcher activity is empty.");
            }
            return true;
        }
        return false;
    }

    public static void copyIcon(String rootPath, ApplicationInfo appInfo) {
        try {
            if (StringUtils.isNotEmpty((String)appInfo.getIcon())) {
                String dest = TestFileUtils.getAppIconPath(rootPath);
                File f = new File(dest);
                if (f.exists()) {
                    f.delete();
                }
                IconUtil.extractFileFromApk(appInfo.getFilePath(), appInfo.getIcon(), dest);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void saveAppInfo(String rootPath, ApplicationInfo appInfo) {
        try {
            StringBuffer buff = new StringBuffer();
            buff.append("appname=" + appInfo.getAppName() + "\r\n");
            buff.append("pacname=" + appInfo.getPackageName() + "\r\n");
            buff.append("actname=" + appInfo.getStartPath() + "\r\n");
            buff.append("version=" + appInfo.getVersionName() + "\r\n");
            buff.append("appsize=" + appInfo.getAppSize() + "\r\n");
            buff.append("md5=" + appInfo.getMd5() + "\r\n");
            buff.append("minsdk=" + appInfo.getMinSdkVersion() + "\r\n");
            buff.append("filepath=" + appInfo.getFilePath() + "\r\n");
            File f = new File(TestFileUtils.getAppInfoPath(rootPath));
            FileUtils.write((File)f, (CharSequence)buff.toString());
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static Message copyApp(String rootPath, ApplicationInfo appInfo) {
        Message msg = new Message();
        String oringinPath = TestFileUtils.getAppOringinPath(rootPath);
        File sec = new File(appInfo.getFilePath());
        File f = new File(oringinPath);
        try {
            if (!f.exists()) {
                FileUtils.copyFile((File)sec, (File)f);
                msg.setStatus(0);
            }
        }
        catch (IOException e) {
            msg.setStatus(20);
            log.error((Object)e.getMessage(), (Throwable)e);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            msg.setContent(stringWriter.getBuffer().toString());
        }
        return msg;
    }

    public static Message resignMainApk(String rootPath, ApplicationInfo appInfo, KeyStore keyStore) throws Exception {
        Message msg = new Message();
        String oringinPath = TestFileUtils.getAppOringinPath(rootPath);
        String resignedPath = TestFileUtils.getAppResignedPath(rootPath);
        ApkTool tool = new ApkTool();
        File f = new File(resignedPath);
        if (f.exists()) {
            msg.setStatus(0);
            msg.setContent("");
            if (SingleTestCase.getInstance().isResignSelected()) {
                FileUtils.deleteQuietly((File)f);
                msg = tool.resignApk(oringinPath, resignedPath, keyStore);
            }
        } else {
            msg = tool.resignApk(oringinPath, resignedPath, keyStore);
        }
        return msg;
    }

    public static void changeTestCaseName(String name, String filePath) {
        try {
            File newTC = new File(String.valueOf(filePath) + File.separator + TESTCASENAME);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.parse(newTC);
            FileUtils.deleteQuietly((File)newTC);
            Element root = doc.getDocumentElement();
            root.setAttribute("name", name);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource domSource = new DOMSource(doc);
            FileOutputStream out = new FileOutputStream(newTC);
            StreamResult result = new StreamResult(out);
            transformer.transform(domSource, result);
            out.close();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String[] args) throws IOException {
        String s = "F:\\abc\\";
        System.out.println(new File(s).getParent());
        BizUtils.changeTestCaseName("abcde", s);
    }
}

