/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.business;

import com.testin.itestin.business.ScriptEngine;
import com.testin.itestin.business.ScriptListener;
import com.testin.itestin.business.SingleTestCase;
import com.testin.itestin.business.TestFileUtils;
import com.testin.itestin.business.recorder.RecorderThread;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.device.DeviceInfo;
import com.testin.itestin.device.IDeviceShell;
import com.testin.itestin.os.Message;
import com.testin.itestin.service.DirectoryService;
import com.testin.itestin.util.Utils;
import com.testin.javafx.Main;
import com.testin.javafx.ui.control.ProgressDialog;
import com.testin.javafx.ui.include.RecordActionController;
import java.io.File;
import org.apache.log4j.Logger;

public class CoordScriptRecord
implements ScriptEngine,
IDeviceShell.ILogcatListener {
    static Logger log = Logger.getLogger(CoordScriptRecord.class);
    private boolean isCanceled;
    private boolean stopFlag;
    private String message = Main.getInternationalString("coordscriptrecord.message");
    private IDeviceShell deviceShell;
    private DeviceInfo deviceInfo;
    private ScriptListener listener;
    private String oringinPath;

    public CoordScriptRecord(DeviceInfo deviceInfo) {
        this.deviceShell = deviceInfo.getDeviceShell();
        this.deviceInfo = deviceInfo;
    }

    @Override
    public boolean isStopped() {
        return this.isCanceled || this.stopFlag;
    }

    @Override
    public void stop() {
        this.isCanceled = true;
    }

    @Override
    public void replay(String scriptPath, ScriptListener listener, int times, RecordActionController.CoordReplayThread runningThread) {
    }

    @Override
    public void record(ScriptListener listener, final RecordActionController.CoordRecordThread runningThread) {
        String rootPath = TestFileUtils.getTestRootDir();
        this.listener = listener;
        this.oringinPath = TestFileUtils.getAppOringinPath(rootPath);
        ProgressDialog.CancelListener cancelListener = new ProgressDialog.CancelListener(){

            @Override
            public void canceled() {
                CoordScriptRecord.this.isCanceled = true;
                CoordScriptRecord.this.stopFlag = true;
                runningThread.setStop(true);
                Message msg = new Message();
                msg.setStatus(1539);
                UIController.getRecordActionHandler().sendMessage(msg);
                msg = new Message();
                msg.setStatus(1545);
                UIController.getRecordActionHandler().sendMessage(msg);
            }
        };
        ProgressDialog progressDialog = new ProgressDialog(ProgressDialog.DialogOptions.CANCEL);
        progressDialog.setCancelListener(cancelListener);
        progressDialog.show();
        progressDialog.setMessage(this.message);
        progressDialog.setProgressValue(10);
        if (runningThread.isStop()) {
            return;
        }
        this.installMainApk(runningThread);
        progressDialog.setProgressValue(50);
        if (runningThread.isStop()) {
            return;
        }
        this.installIME(runningThread);
        progressDialog.setProgressValue(70);
        if (runningThread.isStop()) {
            return;
        }
        this.setIME(runningThread);
        progressDialog.setProgressValue(80);
        if (runningThread.isStop()) {
            return;
        }
        this.startLog(runningThread);
        progressDialog.setProgressValue(90);
        if (runningThread.isStop()) {
            return;
        }
        this.startApp(runningThread);
        progressDialog.setProgressValue(100);
        progressDialog.close();
        this.waitFinish(runningThread);
        if (runningThread.isStop()) {
            return;
        }
        progressDialog.close();
        this.stopAgent();
        this.stopLog();
        this.uninstallApp();
    }

    private boolean isNewVersion4IME() {
        boolean bRet = false;
        try {
            String imPkg = "com.android.im";
            String im = String.valueOf(DirectoryService.getToolsDir()) + File.separator + "AndroidIM.apk";
            File fi = new File(im);
            long localSize = fi.length();
            long remoteSzie = this.deviceShell.getRomotePackageSize(imPkg);
            if (remoteSzie > 0L && localSize > 0L && remoteSzie == localSize) {
                bRet = true;
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return bRet;
    }

    private void installIME(RecordActionController.CoordRecordThread runningThread) {
        if (this.isStopped() || runningThread.isStop()) {
            return;
        }
        boolean b = this.isNewVersion4IME();
        if (!b) {
            String res;
            this.deviceShell.uninstallApp("com.android.im");
            String im = String.valueOf(DirectoryService.getToolsDir()) + File.separator + "AndroidIM.apk";
            Message msg = this.deviceShell.installApp(im, 300000);
            String string = res = msg.getContent() == null ? "" : msg.getContent().toString();
            if (msg.getStatus() != 0 || !res.contains("Success")) {
                this.stopFlag = true;
                if (!runningThread.isStop()) {
                    this.listener.onTerminated(20, Main.getInternationalString("coordscriptrecord.installime.failure"), res);
                }
            }
        }
    }

    private void setIME(RecordActionController.CoordRecordThread runningThread) {
        if (this.isStopped() || runningThread.isStop()) {
            return;
        }
        String cmd = "ime enable com.android.im/.SoftKeyboard";
        this.deviceShell.executeShellCommand(cmd, 30000);
        cmd = "ime set com.android.im/.SoftKeyboard";
        this.deviceShell.executeShellCommand(cmd, 30000);
    }

    /*
     * Unable to fully structure code
     */
    private void waitFinish(RecordActionController.CoordRecordThread runningThread) {
        if (!this.isStopped() && !runningThread.isStop()) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            Utils.sleep(500L);
lbl4:
            // 2 sources

            ** while (!this.isStopped())
        }
lbl5:
        // 1 sources

        if (this.deviceInfo.getDevice() == null) {
            if (!runningThread.isStop()) {
                this.listener.onTerminated(20, Main.getInternationalString("viewrecordr.waitrecordingactionends.offline"), Main.getInternationalString("viewrecordr.waitrecordingactionends.offline"));
            }
        } else if (!this.isCanceled && !runningThread.isStop()) {
            this.listener.onTerminated(20, Main.getInternationalString("coordscriptrecord.waitfinish.unexpectterminal"), Main.getInternationalString("coordscriptrecord.waitfinish.unexpectterminal"));
        }
    }

    private void stopAgent() {
        this.deviceShell.forceStop(SingleTestCase.getInstance().getPkgname());
    }

    private void startLog(RecordActionController.CoordRecordThread runningThread) {
        if (this.isStopped() || runningThread.isStop()) {
            return;
        }
        this.deviceShell.clearMainLog();
        this.deviceShell.startMainLog(IDeviceShell.LogcatLevel.INFO, "iTestin", this);
    }

    private void stopLog() {
        this.deviceShell.stopMainLog();
    }

    private void uninstallApp() {
        this.deviceShell.uninstallApp("com.testin.itestin.tester");
        if (SingleTestCase.getInstance().isSettingUninstall()) {
            this.deviceShell.uninstallApp(SingleTestCase.getInstance().getPkgname());
        }
    }

    private void installMainApk(RecordActionController.CoordRecordThread runningThread) {
        if (this.isStopped() || runningThread.isStop()) {
            return;
        }
        boolean toinstall = true;
        boolean installed = this.deviceShell.checkAppIsInstalled(SingleTestCase.getInstance().getPkgname());
        toinstall = SingleTestCase.getInstance().isSettingUninstall() ? true : !installed;
        if (toinstall) {
            String res;
            this.deviceShell.uninstallApp(SingleTestCase.getInstance().getPkgname());
            Message msg = this.deviceShell.installApp(this.oringinPath, 300000);
            String string = res = msg.getContent() == null ? "" : msg.getContent().toString();
            if (res.contains("pkg: /data/local/tmp/oringin.apk") && res.contains("Failure [INSTALL_FAILED_INVALID_URI]") && res.contains("rm failed for /data/local/tmp/oringin.apk, No such file or directory") && !runningThread.isStop()) {
                msg = this.deviceShell.installApp(this.oringinPath, 300000);
                res = msg.getContent();
            }
            if (msg.getStatus() != 0 || !res.contains("Success")) {
                this.stopFlag = true;
                if (!runningThread.isStop()) {
                    this.listener.onTerminated(20, Main.getInternationalString("coordscriptreplay.installmainapk.installfailure"), res);
                }
            }
        }
    }

    private void startApp(RecordActionController.CoordRecordThread runningThread) {
        if (this.isStopped() || runningThread.isStop()) {
            return;
        }
        Message msg = this.deviceShell.startApp(SingleTestCase.getInstance().getPkgname(), SingleTestCase.getInstance().getActname(), 30000);
        if (msg.getStatus() != 0) {
            this.stopFlag = true;
            if (!runningThread.isStop()) {
                this.listener.onTerminated(20, Main.getInternationalString("coordscriptreplay.startapp.failure"), msg.getContent());
            }
        } else {
            this.listener.onAppStarted();
        }
    }

    @Override
    public void mainLog(String log) {
    }

    @Override
    public void onMainLogExit(int exitValue) {
        this.stopFlag = true;
    }

    @Override
    public void eventLog(String log) {
    }

    @Override
    public void onEventLogExit(int exitValue) {
    }

    @Override
    public void record(ScriptListener listener, RecorderThread runningThread) {
    }

    @Override
    public void replay(ScriptListener listener, int times, RecordActionController.ReplayThread runningThread) {
    }
}

