/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.business;

import com.testin.itestin.business.OneCoordReplay;
import com.testin.itestin.business.ScriptEngine;
import com.testin.itestin.business.ScriptListener;
import com.testin.itestin.business.SingleTestCase;
import com.testin.itestin.business.TestFileUtils;
import com.testin.itestin.business.recorder.RecorderThread;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.device.DeviceInfo;
import com.testin.itestin.device.IDeviceShell;
import com.testin.itestin.device.tools.ApkParser;
import com.testin.itestin.entitys.ApplicationInfo;
import com.testin.itestin.os.Message;
import com.testin.itestin.service.DirectoryService;
import com.testin.javafx.Main;
import com.testin.javafx.ui.control.ProgressDialog;
import com.testin.javafx.ui.include.RecordActionController;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CoordScriptReplay
implements ScriptEngine {
    static Logger log = Logger.getLogger(CoordScriptReplay.class);
    private boolean isCanceled;
    private boolean stopFlag = false;
    private String message = Main.getInternationalString("coordscriptrecord.message");
    private DeviceInfo deviceInfo;
    private IDeviceShell deviceShell;
    private ApplicationInfo applicationInfo;
    private ScriptListener listener;
    private String scriptPath;
    private String oringinPath;
    private OneCoordReplay oneCoordReplay;

    public CoordScriptReplay(DeviceInfo deviceInfo) {
        this.deviceInfo = deviceInfo;
        this.deviceShell = deviceInfo.getDeviceShell();
    }

    @Override
    public boolean isStopped() {
        return this.isCanceled || this.stopFlag;
    }

    @Override
    public void stop() {
        this.isCanceled = true;
        if (this.oneCoordReplay != null) {
            this.oneCoordReplay.stop();
        }
    }

    @Override
    public void replay(ScriptListener listener, int times, RecordActionController.ReplayThread runningThread) {
        log.info((Object)"testcase");
    }

    @Override
    public void replay(String scriptPath, ScriptListener listener, int times, final RecordActionController.CoordReplayThread runningThread) {
        listener.onTestTimes(1);
        this.scriptPath = TestFileUtils.getRealCoordScriptPath(scriptPath);
        this.listener = listener;
        File f = new File(this.scriptPath);
        if (f.exists()) {
            String dir = f.getParentFile().getParentFile().getAbsolutePath();
            this.oringinPath = String.valueOf(dir) + File.separator + "oringin.apk";
        }
        ProgressDialog.CancelListener cancelListener = new ProgressDialog.CancelListener(){

            @Override
            public void canceled() {
                CoordScriptReplay.this.isCanceled = true;
                CoordScriptReplay.this.stopFlag = true;
                runningThread.setStop(true);
                Message msg = new Message();
                msg.setStatus(1539);
                UIController.getRecordActionHandler().sendMessage(msg);
            }
        };
        ProgressDialog progressDialog = new ProgressDialog(ProgressDialog.DialogOptions.CANCEL);
        progressDialog.show();
        progressDialog.setCancelListener(cancelListener);
        progressDialog.setMessage(this.message);
        progressDialog.setProgressValue(10);
        if (runningThread.isStop()) {
            return;
        }
        this.parseApp(runningThread);
        progressDialog.setProgressValue(30);
        if (runningThread.isStop()) {
            return;
        }
        if (SingleTestCase.getInstance().isUninstallInReplay()) {
            this.installMainApk(runningThread);
            progressDialog.setProgressValue(50);
        } else {
            try {
                if (!this.deviceShell.checkAppIsInstalled(this.applicationInfo.getPackageName())) {
                    this.installMainApk(runningThread);
                    progressDialog.setProgressValue(70);
                } else {
                    Thread.sleep(100L);
                    progressDialog.setProgressValue(70);
                }
            }
            catch (InterruptedException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (runningThread.isStop()) {
            return;
        }
        this.installIME(runningThread);
        progressDialog.setProgressValue(70);
        if (runningThread.isStop()) {
            return;
        }
        this.setIME(runningThread);
        progressDialog.setProgressValue(100);
        progressDialog.close();
        if (runningThread.isStop()) {
            return;
        }
        this.coordReplay(times, runningThread);
        if (SingleTestCase.getInstance().isUninstallInReplay()) {
            this.uninstallApp();
        }
    }

    private void coordReplay(int times, RecordActionController.CoordReplayThread runningThread) {
        int i = 0;
        while (i < times) {
            if (this.isStopped() || runningThread.isStop()) break;
            this.listener.onTestTimes(i + 1);
            this.oneCoordReplay = new OneCoordReplay(this.deviceInfo, this.scriptPath, this.applicationInfo, this.listener);
            this.oneCoordReplay.start();
            if (!this.oneCoordReplay.isSuccess()) break;
            ++i;
        }
        if (this.oneCoordReplay != null) {
            this.coordNotifyListener(i + 1, this.oneCoordReplay.isSuccess(), this.oneCoordReplay.getErrorMsg());
        }
    }

    private void coordNotifyListener(int times, boolean success, String errorMsg) {
        if (this.isCanceled) {
            return;
        }
        if (success) {
            this.listener.onTerminated(0, Main.getInternationalString("coordscriptreplay.waitfinish.runsuccess"), "");
        } else {
            String msg = StringUtils.isEmpty((String)errorMsg) ? String.valueOf(Main.getInternationalString("scriptmanagercontroller.createcase.replay")) + String.valueOf(times) + ": " + Main.getInternationalString("coordscriptreplay.waitfinish.unexpectterminal") : errorMsg;
            this.listener.onTerminated(20, msg, "");
        }
    }

    private boolean isNewVersion4IME() {
        boolean bRet = false;
        try {
            String imPkg = "com.android.im";
            String im = String.valueOf(DirectoryService.getToolsDir()) + File.separator + "AndroidIM.apk";
            File fi = new File(im);
            long localSize = fi.length();
            long remoteSzie = this.deviceShell.getRomotePackageSize(imPkg);
            if (remoteSzie > 0L && localSize > 0L && remoteSzie == localSize) {
                bRet = true;
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return bRet;
    }

    private void installIME(RecordActionController.CoordReplayThread runningThread) {
        if (this.isStopped() || runningThread.isStop()) {
            return;
        }
        boolean b = this.isNewVersion4IME();
        if (!b) {
            String res;
            this.deviceShell.uninstallApp("com.android.im");
            String im = String.format("\"%s\"%s%s", DirectoryService.getToolsDir(), File.separator, "AndroidIM.apk");
            Message msg = this.deviceShell.installApp(im, 300000);
            String string = res = msg.getContent() == null ? "" : msg.getContent();
            if (msg.getStatus() != 0 || !res.contains("Success")) {
                this.stopFlag = true;
                if (!runningThread.isStop()) {
                    this.listener.onTerminated(20, Main.getInternationalString("coordscriptrecord.installime.failure"), res);
                }
            }
        }
    }

    private void setIME(RecordActionController.CoordReplayThread runningThread) {
        if (this.isStopped() || runningThread.isStop()) {
            return;
        }
        String cmd = "ime enable com.android.im/.SoftKeyboard";
        this.deviceShell.executeShellCommand(cmd, 30000);
        cmd = "ime set com.android.im/.SoftKeyboard";
        this.deviceShell.executeShellCommand(cmd, 30000);
    }

    private void parseApp(RecordActionController.CoordReplayThread runningThread) {
        if (this.isStopped() || runningThread.isStop()) {
            return;
        }
        this.applicationInfo = new ApkParser().parse(this.oringinPath);
    }

    private void uninstallApp() {
        this.deviceShell.uninstallApp("com.testin.itestin.tester");
        this.deviceShell.uninstallApp(this.applicationInfo.getPackageName());
    }

    private void installMainApk(RecordActionController.CoordReplayThread runningThread) {
        String res;
        if (this.isStopped() || runningThread.isStop()) {
            return;
        }
        this.deviceShell.uninstallApp(this.applicationInfo.getPackageName());
        Message msg = this.deviceShell.installApp(this.oringinPath, 300000);
        String string = res = msg.getContent() == null ? "" : msg.getContent().toString();
        if (res.contains("pkg: /data/local/tmp/oringin.apk") && res.contains("Failure [INSTALL_FAILED_INVALID_URI]") && res.contains("rm failed for /data/local/tmp/oringin.apk, No such file or directory") && !runningThread.isStop()) {
            msg = this.deviceShell.installApp(this.oringinPath, 300000);
            res = msg.getContent();
        }
        if (msg.getStatus() != 0 || !res.contains("Success")) {
            this.stopFlag = true;
            if (!runningThread.isStop()) {
                this.listener.onTerminated(20, Main.getInternationalString("coordscriptreplay.installmainapk.installfailure"), res);
            }
        }
    }

    @Override
    public void record(ScriptListener listener, RecorderThread runningThread) {
    }

    @Override
    public void record(ScriptListener listener, RecordActionController.CoordRecordThread runningThread) {
    }
}

