/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.business;

import com.alibaba.fastjson.JSONObject;
import com.testin.itestin.business.CoordScriptHandler;
import com.testin.itestin.business.ScriptListener;
import com.testin.itestin.business.SingleTestCase;
import com.testin.itestin.device.DeviceInfo;
import com.testin.itestin.device.IDeviceShell;
import com.testin.itestin.entitys.ApplicationInfo;
import com.testin.itestin.os.Message;
import com.testin.itestin.util.Utils;
import com.testin.javafx.Main;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class OneCoordReplay
implements IDeviceShell.ILogcatListener {
    static Logger log = Logger.getLogger(OneCoordReplay.class);
    private DeviceInfo deviceInfo;
    private IDeviceShell deviceShell;
    private List<String> scripts;
    private String scriptPath;
    private ScriptListener listener;
    private ApplicationInfo applicationInfo;
    private String testinGameLogRegex = ".*T\\-I\\-S\\-Event.*: (.*)\\s*$";
    private Pattern testinGameLogPattern;
    private boolean isCanceled;
    private boolean deviceDisconnect;
    private boolean success = false;
    private String errorMsg;
    private List<String> mAssertList = new ArrayList<String>();

    public OneCoordReplay(DeviceInfo deviceInfo, String scriptPath, ApplicationInfo applicationInfo, ScriptListener listener) {
        this.deviceInfo = deviceInfo;
        this.deviceShell = deviceInfo.getDeviceShell();
        this.scriptPath = scriptPath;
        this.listener = listener;
        this.applicationInfo = applicationInfo;
        this.testinGameLogPattern = Pattern.compile(this.testinGameLogRegex);
    }

    public void start() {
        this.startLog();
        this.readScript();
        this.startApp();
        this.waitFinish();
        this.stopApp();
        this.stopLog();
    }

    public void stop() {
        this.isCanceled = true;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    private void startLog() {
        if (this.isCanceled) {
            return;
        }
        this.deviceShell.clearMainLog();
        this.deviceShell.startMainLog(IDeviceShell.LogcatLevel.INFO, "iTestin", this);
    }

    private void stopLog() {
        this.deviceShell.stopMainLog();
    }

    private void startApp() {
        if (this.isCanceled) {
            return;
        }
        Message msg = this.deviceShell.startApp(this.applicationInfo.getPackageName(), this.applicationInfo.getStartPath(), 30000);
        if (msg.getStatus() != 0) {
            this.listener.onTerminated(20, Main.getInternationalString("coordscriptreplay.startapp.failure"), msg.getContent());
        } else {
            this.listener.onAppStarted();
        }
    }

    private void stopApp() {
        if (this.applicationInfo != null) {
            this.deviceShell.forceStop(this.applicationInfo.getPackageName());
            if (SingleTestCase.getInstance().isUninstallInReplay()) {
                this.deviceShell.executeShellCommand("pm clear " + this.applicationInfo.getPackageName(), 2000);
            }
        }
    }

    private void readScript() {
        block14: {
            if (this.isCanceled) {
                return;
            }
            this.scripts = new ArrayList<String>();
            InputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(new File(this.scriptPath));
                    BufferedReader input = new BufferedReader(new InputStreamReader(fis));
                    String line = null;
                    while ((line = input.readLine()) != null) {
                        this.scripts.add(line);
                    }
                    fis.close();
                    fis = null;
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    e.printStackTrace(printWriter);
                    this.listener.onTerminated(20, Main.getInternationalString("coordscriptreplay.readscript.failure"), stringWriter.getBuffer().toString());
                    if (fis == null) break block14;
                    try {
                        fis.close();
                    }
                    catch (IOException e2) {
                        log.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                    fis = null;
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    fis = null;
                }
            }
        }
    }

    private void waitFinish() {
        if (this.isCanceled) {
            return;
        }
        int step = 0;
        boolean res = true;
        for (String s : this.scripts) {
            if (this.isCanceled || this.deviceDisconnect) break;
            if (StringUtils.isEmpty((String)s)) continue;
            this.listener.onTestAction(++step);
            res = this.processScript(s);
            if (res) continue;
            this.errorMsg = String.valueOf(Main.getInternationalString("coordscriptreplay.waitfinish.step")) + step + Main.getInternationalString("coordscriptreplay.waitfinish.commondfailure");
            break;
        }
        if (!this.isCanceled && res) {
            if (this.deviceDisconnect) {
                this.errorMsg = Main.getInternationalString("coordscriptreplay.waitfinish.unexpectterminal");
            } else {
                this.errorMsg = Main.getInternationalString("coordscriptreplay.waitfinish.runsuccess");
                this.success = true;
            }
        }
    }

    private boolean processScript(String action) {
        Pattern p = Pattern.compile("^(\\w+):(.*?)$");
        Matcher m = p.matcher(action);
        if (m.find()) {
            String act = m.group(1);
            String data = m.group(2);
            if (act.equals("assert")) {
                Pattern p1 = Pattern.compile("^(\\d+):(.*)\\s*$");
                m = p1.matcher(data);
                if (m.find()) {
                    String value = m.group(2);
                    int timeout = Integer.parseInt(m.group(1));
                    return this.execAssert(value, timeout);
                }
            } else {
                if (act.equals("screen")) {
                    this.listener.onScreenshot(null);
                    Utils.sleep(3000L);
                    return true;
                }
                return CoordScriptHandler.runCmd(this.deviceInfo, act, data).getStatus() == 0;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAssert(String tag) {
        List<String> list = this.mAssertList;
        synchronized (list) {
            this.mAssertList.add(tag);
        }
    }

    private String testinGameLogFilter(String input) {
        Matcher m = this.testinGameLogPattern.matcher(input);
        if (m.find()) {
            String s1 = m.group(1);
            s1 = s1.trim();
            return s1;
        }
        return "";
    }

    private boolean execAssert(String tag, int timeout) {
        boolean res = false;
        long st = System.currentTimeMillis();
        while (this.isCanceled) {
            if (this.findmAssert(tag) != -1) {
                log.info((Object)"event assertion success!");
                res = true;
                break;
            }
            long et = System.currentTimeMillis();
            if (et - st >= (long)(timeout * 1000)) {
                log.info((Object)"event assertion faill!");
                break;
            }
            Utils.sleep(10L);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findmAssert(String tag) {
        int index = -1;
        List<String> list = this.mAssertList;
        synchronized (list) {
            index = this.mAssertList.indexOf(tag);
            if (index != -1) {
                List<String> sub = this.mAssertList.subList(0, index + 1);
                this.mAssertList.removeAll(sub);
            }
        }
        return index;
    }

    @Override
    public void mainLog(String log) {
        JSONObject event;
        String info = "";
        info = this.testinGameLogFilter(log);
        if (StringUtils.isNotEmpty((String)info) && (event = JSONObject.parseObject((String)info)).containsKey((Object)"type") && event.getString("type").equals("assert")) {
            String tag = event.getString("tag");
            this.onAssert(tag);
        }
    }

    @Override
    public void onMainLogExit(int exitValue) {
        this.deviceDisconnect = true;
    }

    @Override
    public void eventLog(String log) {
    }

    @Override
    public void onEventLogExit(int exitValue) {
    }
}

