/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.business;

import com.testin.itestin.business.ScriptListener;
import com.testin.itestin.business.SingleTestCase;
import com.testin.itestin.business.actions.TestAction;
import com.testin.itestin.device.IDeviceShell;
import com.testin.itestin.shell.MultiLineReceiver;
import com.testin.javafx.Main;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class OneReplay
implements IDeviceShell.ILogcatListener {
    static Logger log = Logger.getLogger(OneReplay.class);
    private ScriptListener listener;
    private IDeviceShell deviceShell;
    private String actname;
    private String pacname;
    private boolean isCanceled;
    private String testinRobotiumLogRegex = ".*?T-E-S-T-IN-ROBOTIUM:(.+)";
    private Pattern testinRobotiumLogPattern;
    private int runIndex = 0;
    private StringBuffer junitLogs = new StringBuffer();
    private String errorMsg;
    private boolean success = false;

    public OneReplay(IDeviceShell deviceShell, ScriptListener listener) {
        this.deviceShell = deviceShell;
        this.listener = listener;
        this.actname = SingleTestCase.getInstance().getActname();
        this.pacname = SingleTestCase.getInstance().getPkgname();
        this.testinRobotiumLogPattern = Pattern.compile(this.testinRobotiumLogRegex);
    }

    public void start() {
        this.startLog();
        this.startApp();
        this.stopApp();
        this.stopLog();
    }

    public void stop() {
        this.isCanceled = true;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String getJunitLogs() {
        return this.junitLogs.toString();
    }

    private void startLog() {
        if (this.isCanceled) {
            return;
        }
        this.deviceShell.clearMainLog();
        this.deviceShell.startMainLog(IDeviceShell.LogcatLevel.INFO, "iTestin", this);
    }

    private void stopLog() {
        this.deviceShell.stopMainLog();
    }

    private void startApp() {
        if (this.isCanceled) {
            return;
        }
        String launch = this.actname;
        launch = launch.substring(launch.lastIndexOf("/") + 1, launch.length());
        String cmd = String.format("am instrument -e testin-pkg %s -e testin-act %s -r -e class %s -w %s", this.pacname, launch, "com.testin.itestin.exec.MyTest#testExec", "com.testin.itestin.tester/com.testin.itestin.TestRunner");
        TestOutputReceiver rcvr = new TestOutputReceiver();
        this.deviceShell.executeShellCommand(cmd, rcvr, 1800000);
    }

    private void stopApp() {
        if (this.pacname != null) {
            this.deviceShell.forceStop(this.pacname);
            if (SingleTestCase.getInstance().isUninstallInReplay()) {
                this.deviceShell.executeShellCommand("pm clear " + this.pacname, 2000);
            }
        }
    }

    @Override
    public void mainLog(String log) {
        String info = null;
        info = this.testinRobotiumLogFilter(log);
        if (info != null) {
            this.testinRobotiumLog(info);
        }
    }

    @Override
    public void onMainLogExit(int exitValue) {
    }

    @Override
    public void eventLog(String log) {
    }

    @Override
    public void onEventLogExit(int exitValue) {
    }

    public String testinRobotiumLogFilter(String log) {
        Matcher m = this.testinRobotiumLogPattern.matcher(log);
        if (m.find()) {
            String s1 = m.group(1);
            s1 = s1.trim();
            return s1;
        }
        return null;
    }

    private void showBlock(int index) {
        ArrayList<TestAction> act = SingleTestCase.getInstance().getActions();
        --index;
        if (act != null && act.size() > 0) {
            String message;
            String name = act.get(index).getActionName();
            String show = act.get(index).show();
            this.errorMsg = message = String.valueOf(Main.getInternationalString("coordscriptreplay.waitfinish.step")) + this.runIndex + "\uff1a" + name + "'" + show + "'" + Main.getInternationalString("coordscriptreplay.waitfinish.commondfailure");
            this.success = false;
        }
    }

    public void testinRobotiumLog(String log) {
        if (log.startsWith("iTestin test start")) {
            this.runIndex = 0;
            this.listener.onAppStarted();
        } else if (log.startsWith("TakeSnapshot")) {
            this.listener.onWindowChange("");
        } else if (log.startsWith("TestAction")) {
            ++this.runIndex;
            String[] str = log.split(" ");
            String index = str[1];
            int step = Integer.valueOf(index);
            this.listener.onTestAction(step);
        } else if (log.startsWith("Block")) {
            this.showBlock(this.runIndex);
        } else if (!log.startsWith("Assert S")) {
            if (log.startsWith("Assert F")) {
                this.showBlock(this.runIndex);
            } else if (log.startsWith("Assert E")) {
                this.showBlock(this.runIndex);
            } else if (log.startsWith("iTestin test success")) {
                this.success = true;
            }
        }
    }

    private class TestOutputReceiver
    extends MultiLineReceiver {
        private TestOutputReceiver() {
        }

        @Override
        public boolean isCancelled() {
            return OneReplay.this.isCanceled;
        }

        @Override
        public void processNewLines(String[] arg0) {
            int i = 0;
            while (i < arg0.length) {
                String line = arg0[i];
                if (line.length() > 0) {
                    OneReplay.this.junitLogs.append(String.valueOf(line) + "\r\n");
                    log.info((Object)("test>>>" + line));
                }
                ++i;
            }
        }
    }
}

