/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.business;

import com.android.ddmlib.MonkeyRunner;
import com.testin.itestin.business.KeyStore;
import com.testin.itestin.business.OneReplay;
import com.testin.itestin.business.ScriptEngine;
import com.testin.itestin.business.ScriptListener;
import com.testin.itestin.business.SingleTestCase;
import com.testin.itestin.business.TestFileUtils;
import com.testin.itestin.business.actions.TestAction;
import com.testin.itestin.business.recorder.RecorderThread;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.device.DeviceInfo;
import com.testin.itestin.device.IDeviceShell;
import com.testin.itestin.device.tools.ApkTool;
import com.testin.itestin.os.Message;
import com.testin.itestin.service.DirectoryService;
import com.testin.itestin.shell.MultiLineReceiver;
import com.testin.javafx.Main;
import com.testin.javafx.ui.control.ProgressDialog;
import com.testin.javafx.ui.include.RecordActionController;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ScriptReplay
implements ScriptEngine {
    static Logger log = Logger.getLogger(ScriptReplay.class);
    private boolean isCancelled;
    private boolean stopFlag;
    private String message = Main.getInternationalString("scriptreplay.message");
    private IDeviceShell deviceShell;
    private ScriptListener listener;
    private String basePath;
    private String resignedPath;
    private String replayPath;
    private String tmpPath;
    private String pacname;
    private OneReplay oneReplay;
    private MonkeyRunner monkeyRunner;
    private DeviceInfo deviceInfo;

    public ScriptReplay(DeviceInfo deviceInfo) {
        this.deviceShell = deviceInfo.getDeviceShell();
        this.deviceInfo = deviceInfo;
    }

    @Override
    public void replay(String scriptPath, ScriptListener listener, int times, RecordActionController.CoordReplayThread runningThread) {
    }

    @Override
    public void replay(ScriptListener listener, int times, final RecordActionController.ReplayThread runningThread) {
        listener.onTestTimes(1);
        this.listener = listener;
        this.pacname = SingleTestCase.getInstance().getPkgname();
        String casePath = SingleTestCase.getInstance().getCasePath();
        File f = new File(casePath);
        this.basePath = f.getParentFile().getAbsolutePath();
        this.resignedPath = String.valueOf(this.basePath) + File.separator + "resigned.apk";
        this.replayPath = String.valueOf(casePath) + File.separator + "replay.apk";
        ProgressDialog.CancelListener cancelListener = new ProgressDialog.CancelListener(){

            @Override
            public void canceled() {
                ScriptReplay.this.isCancelled = true;
                ScriptReplay.this.stopFlag = true;
                runningThread.setStop(true);
                Message msg = new Message();
                msg.setStatus(1539);
                UIController.getRecordActionHandler().sendMessage(msg);
                UIController.sendReplayStopMsg();
            }
        };
        ProgressDialog progressDialog = new ProgressDialog(ProgressDialog.DialogOptions.CANCEL);
        progressDialog.show();
        progressDialog.setCancelListener(cancelListener);
        progressDialog.setMessage(this.message);
        progressDialog.setProgressValue(30);
        if (runningThread.isStop()) {
            return;
        }
        this.resignReplayApk(runningThread);
        progressDialog.setProgressValue(50);
        if (runningThread.isStop()) {
            return;
        }
        if (SingleTestCase.getInstance().isUninstallInReplay()) {
            this.installMainApk(runningThread);
            progressDialog.setProgressValue(70);
        } else {
            try {
                if (!this.deviceShell.checkAppIsInstalled(this.pacname)) {
                    this.installMainApk(runningThread);
                    progressDialog.setProgressValue(70);
                } else {
                    Thread.sleep(100L);
                    progressDialog.setProgressValue(70);
                }
            }
            catch (InterruptedException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (runningThread.isStop()) {
            return;
        }
        this.installReplayApk(runningThread);
        progressDialog.setProgressValue(100);
        if (runningThread.isStop()) {
            return;
        }
        progressDialog.close();
        if (runningThread.isStop()) {
            return;
        }
        this.startMonkeyRunner(runningThread);
        if (runningThread.isStop()) {
            return;
        }
        this.replay(times, runningThread);
        if (SingleTestCase.getInstance().isUninstallInReplay()) {
            this.uninstallApp();
        }
        this.stopMonkeyRunner();
    }

    private void startMonkeyRunner(RecordActionController.ReplayThread runningThread) {
        if (this.isStopped() || runningThread.isStop()) {
            return;
        }
        this.deviceShell.kill("monkey");
        this.monkeyRunner = new MonkeyRunner(this.deviceInfo, new MonkeyOutputReceier());
        boolean b = this.monkeyRunner.waitForConnection();
        log.info((Object)("MonkeyRunner state:" + b));
    }

    private void stopMonkeyRunner() {
        if (this.monkeyRunner != null) {
            this.monkeyRunner.disConnection();
        }
    }

    private void replay(int times, RecordActionController.ReplayThread runningThread) {
        int i = 0;
        while (i < times) {
            if (this.isStopped() || runningThread.isStop()) break;
            this.listener.onTestTimes(i + 1);
            this.oneReplay = new OneReplay(this.deviceShell, this.listener);
            this.oneReplay.start();
            if (!this.oneReplay.isSuccess()) break;
            ++i;
        }
        if (this.oneReplay != null) {
            this.notifyListener(i + 1, this.oneReplay.isSuccess(), this.oneReplay.getErrorMsg(), this.oneReplay.getJunitLogs());
        }
    }

    private void notifyListener(int times, boolean success, String errorMsg, String detailMsg) {
        if (this.isCancelled) {
            return;
        }
        if (success) {
            this.listener.onTerminated(0, Main.getInternationalString("coordscriptreplay.waitfinish.runsuccess"), "");
        } else {
            String msg = StringUtils.isEmpty((String)errorMsg) ? String.valueOf(Main.getInternationalString("scriptmanagercontroller.createcase.replay")) + String.valueOf(times) + ": " + Main.getInternationalString("coordscriptreplay.waitfinish.unexpectterminal") : errorMsg;
            this.listener.onTerminated(20, msg, detailMsg);
        }
    }

    @Override
    public boolean isStopped() {
        return this.isCancelled || this.stopFlag;
    }

    @Override
    public void stop() {
        this.isCancelled = true;
        if (this.oneReplay != null) {
            this.oneReplay.stop();
        }
    }

    private void resignReplayApk(RecordActionController.ReplayThread runningThread) {
        block9: {
            File f;
            if (this.isStopped() || runningThread.isStop()) {
                return;
            }
            KeyStore localKeyStore = TestFileUtils.getKeystore(this.basePath);
            KeyStore tmp = localKeyStore == null ? ApkTool.TestinKeyStore : localKeyStore;
            this.tmpPath = this.replayPath;
            if (this.replayPath.startsWith("script")) {
                this.replayPath = String.valueOf(DirectoryService.getApplicationPath()) + File.separator + this.replayPath;
            }
            if ((f = new File(this.replayPath)).exists()) {
                f.delete();
            }
            ArrayList<TestAction> act = SingleTestCase.getInstance().getActions();
            StringBuffer sb = new StringBuffer();
            for (TestAction a : act) {
                if (a == null) {
                    log.error((Object)"Action is Null");
                    continue;
                }
                String expr = a.expr();
                sb.append(expr);
                sb.append("\n");
            }
            String jsString = sb.toString();
            ApkTool tool = new ApkTool();
            try {
                Message msg = tool.resignTestinReplayApk(this.pacname, this.replayPath, jsString, tmp);
                if (msg.getStatus() != 0) {
                    this.stopFlag = true;
                    String errorMsg = Main.getInternationalString("scriptreplay.resignreplayapk.failure");
                    String detailMsg = msg.getContent();
                    if (!runningThread.isStop()) {
                        this.listener.onTerminated(20, errorMsg, detailMsg);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                e.printStackTrace(printWriter);
                this.stopFlag = true;
                String errorMsg = Main.getInternationalString("scriptreplay.resignreplayapk.failure");
                String detailMsg = stringWriter.getBuffer().toString();
                if (runningThread.isStop()) break block9;
                this.listener.onTerminated(20, errorMsg, detailMsg);
            }
        }
    }

    private void installMainApk(RecordActionController.ReplayThread runningThread) {
        if (this.isStopped() || runningThread.isStop()) {
            return;
        }
        this.deviceShell.uninstallApp(this.pacname);
        Message msg = this.deviceShell.installApp(this.resignedPath, 300000);
        String res = msg.getContent();
        if (res.contains("pkg: /data/local/tmp/resigned.apk") && res.contains("Failure [INSTALL_FAILED_INVALID_URI]") && res.contains("rm failed for /data/local/tmp/resigned.apk, No such file or directory") && !runningThread.isStop()) {
            msg = this.deviceShell.installApp(this.resignedPath, 300000);
            res = msg.getContent();
        }
        if (msg.getStatus() != 0 || !res.contains("Success")) {
            this.stopFlag = true;
            String errorMsg = Main.getInternationalString("coordscriptreplay.installmainapk.installfailure");
            String detailMsg = msg.getContent();
            if (!runningThread.isStop()) {
                this.listener.onTerminated(20, errorMsg, detailMsg);
            }
        }
    }

    private void installReplayApk(RecordActionController.ReplayThread runningThread) {
        if (this.isStopped() || runningThread.isStop()) {
            return;
        }
        this.deviceShell.uninstallApp("com.testin.itestin.tester");
        Message msg = this.deviceShell.installApp(this.replayPath, 300000);
        String res = msg.getContent();
        if (msg.getStatus() != 0 || !res.contains("Success")) {
            this.stopFlag = true;
            String errorMsg = Main.getInternationalString("scriptreplay.installreplayapk.failure");
            String detailMsg = msg.getContent();
            if (!runningThread.isStop()) {
                this.listener.onTerminated(20, errorMsg, detailMsg);
            }
        }
        this.replayPath = this.tmpPath;
    }

    private void uninstallApp() {
        this.deviceShell.uninstallApp("com.testin.itestin.tester");
        this.deviceShell.uninstallApp(this.pacname);
    }

    @Override
    public void record(ScriptListener listener, RecorderThread runningThread) {
    }

    @Override
    public void record(ScriptListener listener, RecordActionController.CoordRecordThread runningThread) {
    }

    private class MonkeyOutputReceier
    extends MultiLineReceiver {
        private MonkeyOutputReceier() {
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public void processNewLines(String[] lines) {
        }
    }
}

