/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.business;

import com.alibaba.fastjson.JSONObject;
import com.testin.itestin.business.actions.TestAction;
import com.testin.javafx.TestinStage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SingleTestCase {
    static Logger log = Logger.getLogger(SingleTestCase.class);
    private boolean isRecording;
    private boolean isEditing;
    private boolean isSaved;
    private boolean isResignSelected;
    private boolean uninstallInSetting;
    private boolean uninstallInReplay;
    private boolean autoShot;
    private int recordStyle;
    private int runType;
    private String pkgPath;
    private String pkgname;
    private String actname;
    private String version;
    private String appName;
    private String caseName;
    private String casePath;
    private String runResult;
    private String createTime;
    private String coordScript;
    private String coordPixel;
    private ArrayList<TestAction> actions = new ArrayList();

    private SingleTestCase() {
    }

    public static final SingleTestCase getInstance() {
        return SingleTestCaseHolder.INSTANCE;
    }

    public void addTestAction(TestAction action) {
        this.actions.add(action);
    }

    public void removeTestAction(TestAction action) {
        this.actions.remove(action);
    }

    public void removeAction(int index) {
        this.actions.remove(index);
    }

    public void removeAllAction() {
        this.actions.clear();
    }

    public void insertTestAction(TestAction action, int index) {
        if (index == -1) {
            this.addTestAction(action);
        } else {
            this.actions.add(index, action);
        }
    }

    public void alterTestAction(TestAction action, int index) {
        this.actions.set(index, action);
    }

    public TestAction getTestAction(int index) {
        if (index < this.actions.size() && index > -1) {
            return this.actions.get(index);
        }
        return null;
    }

    public String getPkgname() {
        return this.pkgname;
    }

    public void setPkgname(String pkgname) {
        this.pkgname = pkgname;
    }

    public String getActname() {
        return this.actname;
    }

    public void setActname(String actname) {
        this.actname = actname;
    }

    public String getName() {
        return this.caseName;
    }

    public void setName(String caseName) {
        this.caseName = caseName;
    }

    public ArrayList<TestAction> getActions() {
        return this.actions;
    }

    public void setCasePath(String casePath) {
        this.casePath = casePath;
    }

    public String getCasePath() {
        return this.casePath;
    }

    public String getPkgPath() {
        return this.pkgPath;
    }

    public void setPkgPath(String pkgPath) {
        this.pkgPath = pkgPath;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getSafeAppName() {
        if (StringUtils.isEmpty((String)this.appName)) {
            return "";
        }
        return this.appName.replaceAll("[\\\\|\\/|\\:|\\*|\\?|\\\"|\\<|\\>]", "");
    }

    public int getRecordStyle() {
        return this.recordStyle;
    }

    public void setRecordStyle(int recordStyle) {
        this.recordStyle = recordStyle;
    }

    public int getRunType() {
        return this.runType;
    }

    public void setRunType(int runType) {
        this.runType = runType;
    }

    public String getRunResult() {
        return this.runResult;
    }

    public void setRunResult(String runResult) {
        this.runResult = runResult;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public void setRecording(boolean isRecording) {
        this.isRecording = isRecording;
    }

    public boolean isEditing() {
        return this.isEditing;
    }

    public void setEditing(boolean isEditing) {
        this.isEditing = isEditing;
    }

    public boolean isSettingUninstall() {
        return this.uninstallInSetting;
    }

    public void setSettingUninstall(boolean uninstall) {
        this.uninstallInSetting = uninstall;
    }

    public boolean isUninstallInReplay() {
        return this.uninstallInReplay;
    }

    public void setUninstallInReplay(boolean uninstallInReplay) {
        this.uninstallInReplay = uninstallInReplay;
    }

    public boolean isAutoShot() {
        return this.autoShot;
    }

    public void setAutoShot(boolean autoShot) {
        this.autoShot = autoShot;
    }

    public String getCoordScriptPath() {
        return this.coordScript;
    }

    public void setCoordScriptPath(String coordScript) {
        this.coordScript = coordScript;
    }

    public String getCoordPixel() {
        return this.coordPixel;
    }

    public void setCoordPixel(String coordPixel) {
        this.coordPixel = coordPixel;
    }

    public boolean isSaved() {
        return this.isSaved;
    }

    public void setSaved(boolean isSaved) {
        this.isSaved = isSaved;
    }

    public boolean isResignSelected() {
        return this.isResignSelected;
    }

    public void setResignSelected(boolean isResignSelected) {
        this.isResignSelected = isResignSelected;
    }

    public String getPixelByScriptPath() {
        if (this.getCoordScriptPath() == null) {
            return "";
        }
        try {
            String[] strs = this.getCoordScriptPath().split("\\\\");
            return strs[strs.length - 1].split("_")[0];
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public String toString() {
        JSONObject json = new JSONObject();
        json.put("pkgPath", (Object)this.getPkgPath());
        json.put("pkgName", (Object)this.getPkgname());
        json.put("actName", (Object)this.getActname());
        json.put("version", (Object)this.getVersion());
        json.put("appName", (Object)this.getAppName());
        json.put("caseName", (Object)this.getName());
        json.put("casePath", (Object)this.getCasePath());
        json.put("recordStyle", (Object)this.getRecordStyle());
        json.put("runResult", (Object)this.getRunResult());
        json.put("createTime", (Object)this.getCreateTime());
        json.put("actions", this.getActions());
        return json.toString();
    }

    public String actionsToString() {
        String actstr = "";
        for (TestAction act : this.getActions()) {
            actstr = String.valueOf(actstr) + act.expr() + "\r\n";
        }
        return actstr;
    }

    public String toWholeString() {
        JSONObject json = new JSONObject();
        json.put("isSave", (Object)this.isSaved());
        json.put("isEditing", (Object)this.isEditing());
        json.put("isRecording", (Object)this.isRecording());
        json.put("recordStyle", (Object)this.getRecordStyle());
        json.put("runType", (Object)this.getRunType());
        json.put("casePath", (Object)this.getCasePath());
        json.put("recordStyle", (Object)this.getRecordStyle());
        json.put("runResult", (Object)this.getRunResult());
        json.put("pkgPath", (Object)this.getPkgPath());
        json.put("pkgName", (Object)this.getPkgname());
        json.put("actName", (Object)this.getActname());
        json.put("version", (Object)this.getVersion());
        json.put("appName", (Object)this.getAppName());
        json.put("caseName", (Object)this.getName());
        json.put("createTime", (Object)this.getCreateTime());
        json.put("actions", this.getActions());
        json.put("coordScript", (Object)this.getCoordScriptPath());
        return json.toString();
    }

    public void saveScript() {
        log.info((Object)String.format("Save Script: %s", SingleTestCase.getInstance().toString()));
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement("TestCase");
            root.setAttribute("name", SingleTestCase.getInstance().getName());
            doc.appendChild(root);
            Element info = doc.createElement("Info");
            Element createTime = doc.createElement("createtime");
            createTime.setTextContent(SingleTestCase.getInstance().getCreateTime());
            info.appendChild(createTime);
            Element recordType = doc.createElement("recordtype");
            recordType.setTextContent(String.valueOf(SingleTestCase.getInstance().getRecordStyle()));
            info.appendChild(recordType);
            Element runResult = doc.createElement("runresult");
            runResult.setTextContent(SingleTestCase.getInstance().getRunResult());
            info.appendChild(runResult);
            root.appendChild(info);
            Element testActions = doc.createElement("TestActions");
            if (SingleTestCase.getInstance().getActions() != null && SingleTestCase.getInstance().getActions().size() > 0) {
                for (TestAction act : SingleTestCase.getInstance().getActions()) {
                    Element testAction = doc.createElement("TestAction");
                    testAction.setAttribute("action", act.getActionName());
                    testAction.setAttribute("show", act.show());
                    testAction.setAttribute("expr", act.expr());
                    testActions.appendChild(testAction);
                }
            }
            root.appendChild(testActions);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource domSource = new DOMSource(doc);
            File f = new File(SingleTestCase.getInstance().getCasePath());
            if (!f.exists()) {
                f.mkdirs();
            }
            FileOutputStream out = new FileOutputStream(String.valueOf(SingleTestCase.getInstance().getCasePath()) + File.separator + "testCase.xml");
            StreamResult result = new StreamResult(out);
            transformer.transform(domSource, result);
            out.close();
            if (TestinStage.getRecordController() != null) {
                TestinStage.getRecordController().setSaveScript(false);
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /* synthetic */ SingleTestCase(SingleTestCase singleTestCase) {
        this();
    }

    private static class SingleTestCaseHolder {
        private static final SingleTestCase INSTANCE = new SingleTestCase(null);

        private SingleTestCaseHolder() {
        }
    }
}

