/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.business;

import com.testin.itestin.business.KeyStore;
import com.testin.itestin.business.SingleTestCase;
import com.testin.itestin.device.DeviceInfo;
import com.testin.itestin.device.DevicesManager;
import com.testin.itestin.entitys.ApplicationInfo;
import com.testin.itestin.service.DirectoryService;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TestFileUtils {
    static Logger log = Logger.getLogger(TestFileUtils.class);

    public static String getTestRootDir(String scriptPath) {
        if (scriptPath == null) {
            return null;
        }
        File f = new File(scriptPath);
        String dir = f.getParentFile().getParentFile().getAbsolutePath();
        return dir;
    }

    public static String getTestRootDir() {
        String pkg = SingleTestCase.getInstance().getPkgname();
        String ver = SingleTestCase.getInstance().getVersion();
        String dir_fn = String.format("%s_%s_dir", pkg, ver);
        String path = String.valueOf(DirectoryService.getScriptDir()) + File.separator + dir_fn + File.separator;
        return path;
    }

    public static String stringFilter(String str) throws PatternSyntaxException {
        if (str == null || StringUtils.isEmpty((String)str)) {
            return str;
        }
        String regEx = "[`~!@#$%^&*()+=|{}':;',\\[\\]<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim().replaceAll(" ", "");
    }

    public static String getTestRelativeDir() {
        String pkg = SingleTestCase.getInstance().getPkgname();
        String ver = SingleTestCase.getInstance().getVersion();
        String dir_fn = String.format("%s_%s_dir", pkg, ver);
        String path = "script" + File.separator + dir_fn + File.separator;
        return path;
    }

    public static List<String> getScriptsDir(String rootPath) {
        if (rootPath == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        File f = new File(rootPath);
        File[] dirs = f.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.getName().endsWith("_dir");
            }
        });
        if (dirs != null) {
            File[] fileArray = dirs;
            int n = dirs.length;
            int n2 = 0;
            while (n2 < n) {
                File dir = fileArray[n2];
                list.add(dir.getAbsolutePath());
                ++n2;
            }
        }
        return list;
    }

    public static String getScriptDir(String rootPath, String scriptName) {
        if (rootPath == null) {
            return null;
        }
        String fn = String.format("%s_dir", scriptName);
        String path = String.valueOf(rootPath) + fn + File.separator;
        return path;
    }

    public static String getRealCoordScriptPath(String coordScriptPath) {
        String scriptPath = coordScriptPath;
        File f = new File(coordScriptPath);
        String scriptName = f.getName();
        scriptName = scriptName.substring(0, scriptName.length() - "_2.script".length());
        String path0 = String.valueOf(f.getParentFile().getAbsolutePath()) + File.separator + String.format("%s_0.script", scriptName);
        String path1 = String.valueOf(f.getParentFile().getAbsolutePath()) + File.separator + String.format("%s_1.script", scriptName);
        String path2 = String.valueOf(f.getParentFile().getAbsolutePath()) + File.separator + String.format("%s_2.script", scriptName);
        if (new File(path0).exists()) {
            scriptPath = path0;
        } else if (new File(path1).exists()) {
            scriptPath = path1;
        } else if (new File(path2).exists()) {
            scriptPath = path2;
        }
        return scriptPath;
    }

    public static String getAppIconPath(String rootPath) {
        if (rootPath == null) {
            return null;
        }
        String fn = "icon.png";
        String path = String.valueOf(rootPath) + fn;
        return path;
    }

    public static String getAppOringinPath(String rootPath) {
        if (rootPath == null) {
            return null;
        }
        String fn = "oringin.apk";
        String path = String.valueOf(rootPath) + fn;
        return path;
    }

    public static String getAppResignedPath(String rootPath) {
        if (rootPath == null) {
            return null;
        }
        String fn = "resigned.apk";
        String path = String.valueOf(rootPath) + fn;
        return path;
    }

    public static String getAppRecordPath(String rootPath) {
        if (rootPath == null) {
            return null;
        }
        String fn = "record.apk";
        String path = String.valueOf(rootPath) + fn;
        return path;
    }

    public static String getAppInfoPath(String rootPath) {
        if (rootPath == null) {
            return null;
        }
        String fn = "app.dat";
        String path = String.valueOf(rootPath) + File.separator + fn;
        return path;
    }

    public static ApplicationInfo getAppInfo(String rootPath) {
        if (rootPath == null) {
            return null;
        }
        ApplicationInfo appInfo = null;
        String dataPath = TestFileUtils.getAppInfoPath(rootPath);
        File f = new File(dataPath);
        if (!f.exists()) {
            return null;
        }
        try {
            String[] lines;
            appInfo = new ApplicationInfo();
            String dat = FileUtils.readFileToString((File)f, (String)"utf-8");
            String[] stringArray = lines = dat.split("\r\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String size;
                String line = stringArray[n2];
                if (line.startsWith("appname=")) {
                    appInfo.setAppName(line.substring("appname=".length()));
                } else if (line.startsWith("pacname=")) {
                    appInfo.setPackageName(line.substring("pacname=".length()));
                } else if (line.startsWith("actname=")) {
                    appInfo.setStartPath(line.substring("actname=".length()));
                } else if (line.startsWith("version=")) {
                    String ver = line.substring("version=".length());
                    if ("null".equals(ver)) {
                        appInfo.setVersionName(null);
                    } else {
                        appInfo.setVersionName(line.substring("version=".length()));
                    }
                } else if (line.startsWith("appsize=")) {
                    try {
                        size = line.substring("appsize=".length());
                        long l = Long.parseLong(size);
                        appInfo.setAppSize(l);
                    }
                    catch (Exception ex) {
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                } else if (line.startsWith("md5=")) {
                    appInfo.setMd5(line.substring("md5=".length()));
                } else if (line.startsWith("minsdk=")) {
                    try {
                        size = line.substring("minsdk=".length());
                        int l = Integer.parseInt(size);
                        appInfo.setMinSdkVersion(l);
                    }
                    catch (Exception ex) {
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                } else if (line.startsWith("filepath=")) {
                    appInfo.setFilePath(line.substring("filepath=".length()));
                }
                ++n2;
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return appInfo;
    }

    public static String getKeystorePath(String rootPath) {
        if (rootPath == null) {
            return null;
        }
        String fn = "test.keystore";
        String path = String.valueOf(rootPath) + File.separator + fn;
        return path;
    }

    public static String getKeystoreInfoPath(String rootPath) {
        if (rootPath == null) {
            return null;
        }
        String fn = "keystore.dat";
        String path = String.valueOf(rootPath) + File.separator + fn;
        return path;
    }

    public static KeyStore getKeystore(String rootPath) {
        if (rootPath == null) {
            return null;
        }
        KeyStore keyStore = null;
        String storePath = TestFileUtils.getKeystorePath(rootPath);
        String dataPath = TestFileUtils.getKeystoreInfoPath(rootPath);
        File f1 = new File(storePath);
        if (!f1.exists()) {
            return null;
        }
        File f2 = new File(dataPath);
        if (!f2.exists()) {
            return null;
        }
        try {
            String[] lines;
            keyStore = new KeyStore();
            keyStore.setKeystore(storePath);
            String dat = FileUtils.readFileToString((File)f2, (String)"utf-8");
            String[] stringArray = lines = dat.split("\r\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (line.startsWith("alias=")) {
                    keyStore.setAlias(line.substring("alias=".length()));
                } else if (line.startsWith("storepass=")) {
                    keyStore.setStorepass(line.substring("storepass=".length()));
                } else if (line.startsWith("aliaspass=")) {
                    keyStore.setKeypass(line.substring("aliaspass=".length()));
                }
                ++n2;
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return keyStore;
    }

    public static String getPixel() {
        DeviceInfo dev = DevicesManager.getDevice();
        if (dev == null) {
            return "";
        }
        return dev.getPixel();
    }

    public static File[] getFilterList(String dir, final String filter) {
        File[] files = new File(dir).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(filter);
            }
        });
        return files;
    }
}

