/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.business;

import com.testin.itestin.api.bean.CtFileUploadReq;
import com.testin.itestin.api.bean.CtFileUploadRes;
import com.testin.itestin.api.serviceimp.SdCtFileUploadServiceImp;
import com.testin.itestin.api.util.FileUploadObserver;
import com.testin.itestin.business.KeyStore;
import com.testin.itestin.business.SingleTestCase;
import com.testin.itestin.business.TestFileUtils;
import com.testin.itestin.business.actions.TestAction;
import com.testin.itestin.common.Constants;
import com.testin.itestin.device.tools.ApkParser;
import com.testin.itestin.device.tools.ApkTool;
import com.testin.itestin.entitys.ApplicationInfo;
import com.testin.itestin.os.Message;
import com.testin.itestin.service.DirectoryService;
import com.testin.itestin.util.ZipUtil;
import com.testin.javafx.Main;
import com.testin.javafx.ui.control.ProgressDialog;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class UploadScript {
    static Logger log = Logger.getLogger(UploadScript.class);

    public static void upload(UploadCallback callback) {
        String resignedPath;
        ProgressDialog progressDialog;
        String iconUrl;
        String scriptUrl;
        String appUrl;
        String errorMsg;
        boolean res;
        block14: {
            res = false;
            errorMsg = null;
            appUrl = null;
            scriptUrl = null;
            iconUrl = null;
            final StringBuffer fileType = new StringBuffer();
            progressDialog = new ProgressDialog(ProgressDialog.DialogOptions.CANCEL);
            final FileUploadObserver uploadObserver = new FileUploadObserver(){
                private boolean cancel;

                @Override
                public void transferred(long total, long transferred) {
                    if (StringUtils.isNotEmpty((String)fileType.toString())) {
                        double d = (double)transferred / (double)total;
                        DecimalFormat df = new DecimalFormat("#.00");
                        d = Double.parseDouble(df.format(d));
                        int i = (int)(d * 100.0);
                        String show = String.valueOf(i) + "%";
                        String msg = String.format(String.valueOf(Main.getInternationalString("uploadscript.uploadobserver.uploadmessage1")) + "(%s %s)" + Main.getInternationalString("uploadscript.uploadobserver.uploadmessage2"), fileType.toString(), show);
                        progressDialog.setMessage(msg);
                    }
                }

                @Override
                public boolean isCanceled() {
                    return this.cancel;
                }

                @Override
                public void cancel() {
                    this.cancel = true;
                }
            };
            ProgressDialog.CancelListener cancelListener = new ProgressDialog.CancelListener(){

                @Override
                public void canceled() {
                    uploadObserver.cancel();
                }
            };
            progressDialog.setCancelListener(cancelListener);
            progressDialog.show();
            progressDialog.setMessage(String.valueOf(Main.getInternationalString("uploadscript.uploadobserver.uploadmessage1")) + Main.getInternationalString("uploadscript.uploadobserver.uploadmessage2"));
            progressDialog.setProgressValue(10);
            String casePath = SingleTestCase.getInstance().getCasePath();
            File f = new File(casePath);
            String rootPath = f.getParentFile().getAbsolutePath();
            String iconPath = String.valueOf(rootPath) + File.separator + "icon.png";
            resignedPath = String.valueOf(rootPath) + File.separator + "resigned.apk";
            String replayPath = String.valueOf(casePath) + File.separator + "replay.apk";
            String testtypeIni = String.valueOf(casePath) + File.separator + "testtype.ini";
            String targetZipFile = String.valueOf(casePath) + File.separator + f.getName() + ".zip";
            try {
                res = UploadScript.resignReplayApk(rootPath);
                if (!res) break block14;
                res = UploadScript.newIni(testtypeIni, "11");
                File[] zipFiles = new File[]{new File(replayPath), new File(testtypeIni)};
                try {
                    ZipUtil.compressedFiles(zipFiles, targetZipFile);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    errorMsg = Main.getInternationalString("uploadscript.upload.zipfailure");
                    res = false;
                }
                progressDialog.setProgressValue(30);
                if (res && !progressDialog.isCanceled() && res && !progressDialog.isCanceled()) {
                    fileType.delete(0, fileType.length());
                    fileType.append("app");
                    appUrl = UploadScript.uploadFile(uploadObserver, resignedPath, "testin", "apk");
                    progressDialog.setProgressValue(70);
                    res = StringUtils.isNotEmpty((String)appUrl);
                    String string = errorMsg = res ? "" : Main.getInternationalString("uploadscript.upload.uploadappfailure");
                    if (res && !progressDialog.isCanceled()) {
                        fileType.delete(0, fileType.length());
                        fileType.append("script");
                        scriptUrl = UploadScript.uploadFile(uploadObserver, targetZipFile, "testin", "zip");
                        progressDialog.setProgressValue(90);
                        res = StringUtils.isNotEmpty((String)scriptUrl);
                        String string2 = errorMsg = res ? "" : Main.getInternationalString("uploadscript.upload.uploadscriptfailure");
                        if (res && !progressDialog.isCanceled()) {
                            File icon = new File(iconPath);
                            if (icon.exists() && !progressDialog.isCanceled()) {
                                fileType.delete(0, fileType.length());
                                fileType.append("icon");
                                iconUrl = UploadScript.uploadFile(uploadObserver, iconPath, "testin", "png");
                            }
                            progressDialog.setProgressValue(100);
                            if (!progressDialog.isCanceled()) {
                                res = true;
                            }
                        }
                    }
                }
            }
            finally {
                if (!progressDialog.isCanceled()) {
                    progressDialog.close();
                }
            }
        }
        if (res && !progressDialog.isCanceled()) {
            ApplicationInfo appInfo = new ApkParser().parse(resignedPath);
            callback.succeeded(appInfo, appUrl, scriptUrl, iconUrl);
        } else if (!progressDialog.isCanceled()) {
            errorMsg = StringUtils.isNotEmpty(errorMsg) ? errorMsg : Main.getInternationalString("uploadscript.upload.uploadscriptsfailure");
            callback.failed(20, errorMsg);
        }
    }

    private static boolean resignReplayApk(String basePath) {
        try {
            File f;
            KeyStore localKeyStore = TestFileUtils.getKeystore(basePath);
            KeyStore tmp = localKeyStore == null ? ApkTool.TestinKeyStore : localKeyStore;
            String replayPath = String.valueOf(SingleTestCase.getInstance().getCasePath()) + File.separator + "replay.apk";
            if (replayPath.startsWith("script")) {
                replayPath = String.valueOf(DirectoryService.getApplicationPath()) + File.separator + replayPath;
            }
            if ((f = new File(replayPath)).exists()) {
                f.delete();
            }
            ArrayList<TestAction> act = SingleTestCase.getInstance().getActions();
            StringBuffer sb = new StringBuffer();
            for (TestAction a : act) {
                String expr = a.expr();
                sb.append(expr);
                sb.append("\n");
            }
            String jsString = sb.toString();
            ApkTool tool = new ApkTool();
            Message msg = tool.resignTestinReplayApk(SingleTestCase.getInstance().getPkgname(), replayPath, jsString, tmp);
            if (msg.getStatus() != 0) {
                log.error((Object)("resignReplayApk>>>" + msg.getContent()));
            }
            return msg.getStatus() == 0;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static String uploadFile(FileUploadObserver uploadObserver, String filePath, String tag, String suffix) {
        String url = null;
        try {
            SdCtFileUploadServiceImp fus = new SdCtFileUploadServiceImp();
            CtFileUploadReq fileUploadReq = new CtFileUploadReq();
            Integer uid = Constants.uid_dis;
            if (uid == null) {
                uid = new Integer(0);
            }
            fileUploadReq.setUid(uid);
            fileUploadReq.setTag(tag);
            fileUploadReq.setSuffix(suffix);
            CtFileUploadRes resObj = fus.fileUpload(fileUploadReq, filePath, uploadObserver);
            if (resObj != null && resObj.getCode() == 0 && resObj.getData() != null && resObj.getData().getFileinfo() != null) {
                url = resObj.getData().getFileinfo().getFileUrl();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return url;
    }

    private static boolean newIni(String path, String text) {
        boolean b = false;
        try {
            File f = new File(path);
            if (f.exists()) {
                f.delete();
            }
            if (StringUtils.isNotEmpty((String)text)) {
                FileUtils.writeStringToFile((File)f, (String)text);
            } else {
                FileUtils.writeStringToFile((File)f, (String)"");
            }
            b = true;
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return b;
    }

    public static void upload(String scriptPath, UploadCallback callback) {
        block22: {
            ProgressDialog progressDialog;
            String errorMsg;
            block21: {
                String rootPath;
                String iconUrl;
                String scriptUrl;
                String appUrl;
                boolean res;
                block20: {
                    res = false;
                    errorMsg = null;
                    appUrl = null;
                    scriptUrl = null;
                    iconUrl = null;
                    final StringBuffer fileType = new StringBuffer();
                    progressDialog = new ProgressDialog(ProgressDialog.DialogOptions.CANCEL);
                    final FileUploadObserver uploadObserver = new FileUploadObserver(){
                        private boolean cancel;

                        @Override
                        public void transferred(long total, long transferred) {
                            if (StringUtils.isNotEmpty((String)fileType.toString())) {
                                double d = (double)transferred / (double)total;
                                DecimalFormat df = new DecimalFormat("#.00");
                                d = Double.parseDouble(df.format(d));
                                int i = (int)(d * 100.0);
                                String show = String.valueOf(i) + "%";
                                String msg = String.format(String.valueOf(Main.getInternationalString("uploadscript.uploadobserver.uploadmessage1")) + "(%s %s)" + Main.getInternationalString("uploadscript.uploadobserver.uploadmessage2"), fileType.toString(), show);
                                progressDialog.setMessage(msg);
                            }
                        }

                        @Override
                        public boolean isCanceled() {
                            return this.cancel;
                        }

                        @Override
                        public void cancel() {
                            this.cancel = true;
                        }
                    };
                    ProgressDialog.CancelListener cancelListener = new ProgressDialog.CancelListener(){

                        @Override
                        public void canceled() {
                            uploadObserver.cancel();
                        }
                    };
                    progressDialog.setCancelListener(cancelListener);
                    progressDialog.show();
                    progressDialog.setMessage(String.valueOf(Main.getInternationalString("uploadscript.uploadobserver.uploadmessage1")) + Main.getInternationalString("uploadscript.uploadobserver.uploadmessage2"));
                    progressDialog.setProgressValue(10);
                    String casePath = scriptPath;
                    File f = new File(casePath);
                    rootPath = f.getParentFile().getAbsolutePath();
                    try {
                        String iconPath = String.valueOf(rootPath) + File.separator + "icon.png";
                        String oringinPath = String.valueOf(rootPath) + File.separator + "oringin.apk";
                        String testtypeIni = String.valueOf(casePath) + File.separator + "testtype.ini";
                        String targetZipFile = String.valueOf(casePath) + File.separator + f.getName() + ".zip";
                        File[] scripts = f.listFiles(new FilenameFilter(){

                            @Override
                            public boolean accept(File dir, String name) {
                                return name.endsWith("_1.script");
                            }
                        });
                        res = scripts.length > 0;
                        String string = errorMsg = res ? "" : Main.getInternationalString("uploadscript.upload.scriptlistisempty");
                        if (res) {
                            res = UploadScript.newIni(testtypeIni, "10");
                            File[] zipFiles = new File[scripts.length + 1];
                            zipFiles[0] = new File(testtypeIni);
                            String sdir = String.valueOf(DirectoryService.getTempDir()) + File.separator + "export";
                            File dir = new File(sdir);
                            if (dir.exists()) {
                                FileUtils.deleteDirectory((File)dir);
                                dir.mkdirs();
                            } else {
                                dir.mkdirs();
                            }
                            File[] scriptsFiles = new File[scripts.length];
                            int i = 0;
                            while (i < scripts.length) {
                                File destFile;
                                File sourFile = scripts[i];
                                String tmp = sourFile.getName().split("_")[0];
                                String destFileName = String.valueOf(tmp) + "_" + System.currentTimeMillis() + "_1.script";
                                String newPath = String.valueOf(sdir) + File.separator + destFileName;
                                UploadScript.Copy(sourFile, newPath);
                                scriptsFiles[i] = destFile = new File(newPath);
                                ++i;
                            }
                            System.arraycopy(scriptsFiles, 0, zipFiles, 1, scripts.length);
                            ZipUtil.compressedFiles(zipFiles, targetZipFile);
                            progressDialog.setProgressValue(30);
                            if (res && !progressDialog.isCanceled() && res && !progressDialog.isCanceled()) {
                                fileType.delete(0, fileType.length());
                                fileType.append("app");
                                appUrl = UploadScript.uploadFile(uploadObserver, oringinPath, "testinApp", "apk");
                                progressDialog.setProgressValue(70);
                                res = StringUtils.isNotEmpty((String)appUrl);
                                String string2 = errorMsg = res ? "" : Main.getInternationalString("uploadscript.upload.uploadappfailure");
                                if (res && !progressDialog.isCanceled()) {
                                    fileType.delete(0, fileType.length());
                                    fileType.append("script");
                                    scriptUrl = UploadScript.uploadFile(uploadObserver, targetZipFile, "testinApp", "zip");
                                    progressDialog.setProgressValue(90);
                                    res = StringUtils.isNotEmpty((String)scriptUrl);
                                    String string3 = errorMsg = res ? "" : Main.getInternationalString("uploadscript.upload.uploadscriptfailure");
                                    if (res && !progressDialog.isCanceled()) {
                                        File icon = new File(iconPath);
                                        if (icon.exists() && !progressDialog.isCanceled()) {
                                            fileType.delete(0, fileType.length());
                                            fileType.append("icon");
                                            iconUrl = UploadScript.uploadFile(uploadObserver, iconPath, "testinApp", "png");
                                        }
                                        progressDialog.setProgressValue(100);
                                        if (!progressDialog.isCanceled()) {
                                            res = true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        res = false;
                        errorMsg = Main.getInternationalString("uploadscript.upload.zipfailure");
                        log.error((Object)e.getMessage(), (Throwable)e);
                        if (!progressDialog.isCanceled()) {
                            progressDialog.close();
                        }
                        break block20;
                    }
                    catch (Exception e) {
                        try {
                            res = false;
                            errorMsg = Main.getInternationalString("uploadscript.upload.zipfailure");
                            log.error((Object)e.getMessage(), (Throwable)e);
                            break block20;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (!progressDialog.isCanceled()) {
                                progressDialog.close();
                            }
                        }
                    }
                    if (!progressDialog.isCanceled()) {
                        progressDialog.close();
                    }
                }
                if (!res || progressDialog.isCanceled()) break block21;
                ApplicationInfo appInfo = TestFileUtils.getAppInfo(rootPath);
                callback.succeeded(appInfo, appUrl, scriptUrl, iconUrl);
                break block22;
            }
            if (!progressDialog.isCanceled()) {
                errorMsg = StringUtils.isNotEmpty((String)errorMsg) ? errorMsg : Main.getInternationalString("uploadscript.upload.uploadscriptsfailure");
                callback.failed(20, errorMsg);
            }
        }
    }

    private static void Copy(File oldfile, String newPath) {
        try {
            FileUtils.copyFile((File)oldfile, (File)new File(newPath));
        }
        catch (IOException e1) {
            log.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    public static interface UploadCallback {
        public void failed(int var1, String var2);

        public void succeeded(ApplicationInfo var1, String var2, String var3, String var4);
    }
}

