/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.business;

import com.android.ddmlib.MonkeyRunner;
import com.android.ddmlib.ViewClient;
import com.testin.itestin.business.ScriptEngine;
import com.testin.itestin.business.ScriptListener;
import com.testin.itestin.business.SingleTestCase;
import com.testin.itestin.business.TestFileUtils;
import com.testin.itestin.business.recorder.RecorderThread;
import com.testin.itestin.business.utils.StatusMgt;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.device.DeviceInfo;
import com.testin.itestin.device.IDeviceShell;
import com.testin.itestin.os.Message;
import com.testin.itestin.shell.MultiLineReceiver;
import com.testin.itestin.threadpool.ThreadPool;
import com.testin.itestin.util.Utils;
import com.testin.javafx.Main;
import com.testin.javafx.ui.control.ProgressDialog;
import com.testin.javafx.ui.include.RecordActionController;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ViewRecorder
implements ScriptEngine {
    static Logger log = Logger.getLogger(ViewRecorder.class);
    private boolean stopFlag;
    private boolean offline;
    private String message = Main.getInternationalString("coordscriptrecord.message");
    private DeviceInfo deviceInfo;
    private IDeviceShell deviceShell;
    private ScriptListener listener;
    private String resignedPath;
    private String recordPath;
    private ViewClient viewClient;
    private MonkeyRunner monkeyRunner;
    private StringBuilder errorDetails = new StringBuilder();
    long lastWindowChange = 0L;
    private String lastWindowInfo = "";

    public ViewRecorder(DeviceInfo deviceInfo) {
        this.deviceInfo = deviceInfo;
        this.deviceShell = deviceInfo.getDeviceShell();
        StatusMgt.setViewRecorderStop(false);
    }

    @Override
    public boolean isStopped() {
        return StatusMgt.isViewRecorderStop() || this.isStopFlag();
    }

    @Override
    public void stop() {
        StatusMgt.setViewRecorderStop(true);
    }

    @Override
    public void record(ScriptListener listener, final RecorderThread runningThread) {
        log.info((Object)"Start recording.");
        String rootPath = TestFileUtils.getTestRootDir();
        this.listener = listener;
        this.resignedPath = TestFileUtils.getAppResignedPath(rootPath);
        this.recordPath = TestFileUtils.getAppRecordPath(rootPath);
        ProgressDialog.CancelListener cancelListener = new ProgressDialog.CancelListener(){

            @Override
            public void canceled() {
                StatusMgt.setViewRecorderStop(true);
                ViewRecorder.this.setStopFlag(true);
                runningThread.setStop(true);
                Message msg = new Message();
                SingleTestCase.getInstance().setRecording(false);
                msg.setStatus(1539);
                UIController.getRecordActionHandler().sendMessage(msg);
                msg = new Message();
                msg.setStatus(1545);
                UIController.getRecordActionHandler().sendMessage(msg);
            }
        };
        ProgressDialog progressDialog = new ProgressDialog(ProgressDialog.DialogOptions.CANCEL);
        progressDialog.setCancelListener(cancelListener);
        progressDialog.show();
        progressDialog.setMessage(this.message);
        progressDialog.setProgressValue(10);
        if (runningThread.isStop()) {
            return;
        }
        this.installMainApk(runningThread);
        progressDialog.setProgressValue(60);
        if (runningThread.isStop()) {
            return;
        }
        this.installRecordApk(runningThread);
        progressDialog.setProgressValue(70);
        if (runningThread.isStop()) {
            return;
        }
        this.startMonkeyRunner(runningThread);
        progressDialog.setProgressValue(90);
        if (runningThread.isStop()) {
            return;
        }
        this.launchApp(runningThread);
        progressDialog.setProgressValue(100);
        progressDialog.close();
        if (runningThread.isStop()) {
            return;
        }
        this.waitRecordingActionEnds(runningThread);
        if (runningThread.isStop()) {
            return;
        }
        progressDialog.close();
        this.stopAgent();
        this.stopMonkeyRunner();
        this.uninstallApp();
    }

    private void waitRecordingActionEnds(RecorderThread runningThead) {
        if (this.isStopped() || runningThead.isStop()) {
            return;
        }
        boolean timeout = false;
        int unsuccessful_count = 0;
        int unsuccessful_limit = 30;
        UIController.startScreenEventListener();
        while (!this.isStopped()) {
            log.debug((Object)"iTestin is performing record action.");
            if (Utils.autoFetchWindowInfo) {
                if (this.tryUpdateScrreen()) {
                    unsuccessful_count = 0;
                } else {
                    boolean bl = timeout = ++unsuccessful_count >= unsuccessful_limit;
                    if (timeout) {
                        log.warn((Object)String.format("Get window info unsuccessful hits limit(%s), end recording.", unsuccessful_limit));
                        break;
                    }
                }
            } else {
                this.manualUpdateWindowInfo();
            }
            Utils.sleep(Utils.WINDOW_INFO_FETCH_INTERVAL);
        }
        UIController.endScreenEventListener();
        if (this.offline) {
            this.listener.onTerminated(20, Main.getInternationalString("viewrecordr.waitrecordingactionends.offline"), this.errorDetails.toString());
            this.offline = false;
        } else if (timeout) {
            log.warn((Object)String.format("Unable to get window info continuously for %s times, terminate recording action.", unsuccessful_limit));
            this.listener.onTerminated(20, "\u64cd\u4f5c\u8d85\u65f6, " + Main.getInternationalString("coordscriptrecord.waitfinish.timeout"), this.errorDetails.toString());
        } else if (this.isContainingError(this.errorDetails.toString())) {
            log.warn((Object)"Recording action ends unexpectedly. Unknown error.");
            this.listener.onTerminated(1, Main.getInternationalString("coordscriptrecord.waitfinish.unexpectterminal"), this.errorDetails.toString());
        } else {
            this.listener.onTerminated(0, "", this.errorDetails.toString());
            log.info((Object)"Recording action is cancelled.");
        }
        this.errorDetails.delete(0, this.errorDetails.length());
    }

    private boolean isWindownInfoChanged(String newWindowInfo) {
        if (StringUtils.isNotEmpty((String)newWindowInfo)) {
            boolean changed;
            if (newWindowInfo.equals("0")) {
                return false;
            }
            boolean bl = changed = !newWindowInfo.equals(this.lastWindowInfo);
            if (changed) {
                this.lastWindowInfo = newWindowInfo;
            }
            return changed;
        }
        return false;
    }

    private void manualUpdateWindowInfo() {
        String newWindowInfo = ViewClient.getLastWindowInfo();
        if (this.isWindownInfoChanged(newWindowInfo)) {
            this.lastWindowChange = System.currentTimeMillis();
            this.listener.onWindowChange(newWindowInfo);
        }
    }

    private boolean isContainingError(String errorDetails) {
        return errorDetails.contentEquals("signature matching") || errorDetails.contains("Process crashed");
    }

    private boolean tryUpdateScrreen() {
        String windowContent;
        if (Utils.IS_SYNCING_SCREEN) {
            log.debug((Object)"it is syncing screen right, ignore this update-screen request.");
            return false;
        }
        this.lastWindowInfo = windowContent = ViewClient.getWindowInfoFromDevice();
        if (StringUtils.isNotEmpty((String)windowContent) && !windowContent.equals("0") && !windowContent.equals("null")) {
            this.lastWindowChange = System.currentTimeMillis();
            this.listener.onWindowChange(windowContent);
        }
        return StringUtils.isNotEmpty((String)windowContent);
    }

    private void stopAgent() {
        if (this.viewClient != null) {
            this.viewClient.stop();
        }
        if (SingleTestCase.getInstance() != null) {
            this.deviceShell.forceStop(SingleTestCase.getInstance().getPkgname());
        }
    }

    private void uninstallApp() {
        this.deviceShell.uninstallApp("com.testin.itestin.tester");
        if (SingleTestCase.getInstance().isSettingUninstall()) {
            this.deviceShell.uninstallApp(SingleTestCase.getInstance().getPkgname());
        }
    }

    private void installMainApk(RecorderThread runningThread) {
        if (this.isStopped() || runningThread.isStop()) {
            return;
        }
        log.info((Object)String.format("Install main app: %s", this.resignedPath));
        boolean toinstall = true;
        boolean installed = this.deviceShell.checkAppIsInstalled(SingleTestCase.getInstance().getPkgname());
        toinstall = SingleTestCase.getInstance().isSettingUninstall() ? true : !installed;
        if (toinstall) {
            this.deviceShell.uninstallApp(SingleTestCase.getInstance().getPkgname());
            Message msg = this.deviceShell.installApp(this.resignedPath, 300000);
            String res = msg.getContent();
            if (res.contains("pkg: /data/local/tmp/resigned.apk") && res.contains("Failure [INSTALL_FAILED_INVALID_URI]") && res.contains("rm failed for /data/local/tmp/resigned.apk, No such file or directory") && !runningThread.isStop()) {
                msg = this.deviceShell.installApp(this.resignedPath, 300000);
                res = msg.getContent();
            }
            if (msg.getStatus() != 0 || !res.contains("Success")) {
                this.setStopFlag(true);
                if (!runningThread.isStop()) {
                    this.listener.onTerminated(20, Main.getInternationalString("coordscriptreplay.installmainapk.installfailure"), res);
                }
            }
            this.errorDetails.delete(0, this.errorDetails.length());
        }
    }

    private void installRecordApk(RecorderThread runningThread) {
        if (this.isStopped() || runningThread.isStop()) {
            return;
        }
        this.deviceShell.uninstallApp("com.testin.itestin.tester");
        Message msg = this.deviceShell.installApp(this.recordPath, 180000);
        String res = msg.getContent();
        if (res.contains("pkg: /data/local/tmp/record.apk") && res.contains("Failure [INSTALL_FAILED_INVALID_URI]") && res.contains("rm failed for /data/local/tmp/record.apk, No such file or directory") && !runningThread.isStop()) {
            msg = this.deviceShell.installApp(this.recordPath, 180000);
            res = msg.getContent();
        }
        if (msg.getStatus() != 0 || !res.contains("Success")) {
            this.setStopFlag(true);
            if (!runningThread.isStop()) {
                this.listener.onTerminated(20, Main.getInternationalString("scriptrecord.installrecordapp.installfailure"), res);
            }
        }
        this.errorDetails.delete(0, this.errorDetails.length());
    }

    private void startMonkeyRunner(RecorderThread runningThread) {
        if (this.isStopped() || runningThread.isStop()) {
            return;
        }
        this.deviceShell.kill("monkey");
        this.monkeyRunner = new MonkeyRunner(this.deviceInfo, new MonkeyOutputReceier());
        boolean b = this.monkeyRunner.waitForConnection();
        log.info((Object)("MonkeyRunner state: " + b));
    }

    private void stopMonkeyRunner() {
        if (this.monkeyRunner != null) {
            this.monkeyRunner.disConnection();
        }
    }

    private void launchApp(RecorderThread runningThread) {
        if (this.isStopped() || runningThread.isStop()) {
            return;
        }
        Thread t = new Thread("AppRunner"){

            @Override
            public void run() {
                String launch = SingleTestCase.getInstance().getActname();
                launch = launch.substring(launch.lastIndexOf("/") + 1, launch.length());
                String cmd = String.format("am instrument -e testin-pkg %s -e testin-act %s -r -e class %s -w %s", SingleTestCase.getInstance().getPkgname(), launch, "com.testin.itestin.rec.TestCaseRecorder#testRecord", "com.testin.itestin.tester/com.testin.itestin.TestRunner");
                TestOutputReceiver rcvr = new TestOutputReceiver();
                ViewRecorder.this.deviceShell.executeShellCommand(cmd, rcvr, 1800000);
                if (ViewRecorder.this.deviceInfo.getDevice() == null) {
                    ViewRecorder.this.offline = true;
                }
                ViewRecorder.this.setStopFlag(true);
                Utils.gc();
            }
        };
        ThreadPool.execute(t);
    }

    public static void main(String[] args) {
        String str = "ssativityResuming(studio.watermoon.app.livewallpaper.bbqne2)";
        String regex = "activityResuming\\((\\S+)\\)$|in\\spackage\\s(\\S+)$";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(str);
        if (m.find()) {
            log.info((Object)(String.valueOf(m.groupCount()) + "====" + m.group(0)));
        }
    }

    private void checkPackage(String packageName) {
        boolean main = packageName.equals(SingleTestCase.getInstance().getPkgname());
        if (this.listener != null) {
            this.listener.onPackageChanged(main, packageName);
            if (Utils.autoFetchWindowInfo) {
                Utils.sleep(500L);
                this.tryUpdateScrreen();
            }
        }
    }

    @Override
    public void record(ScriptListener listener, RecordActionController.CoordRecordThread runningThread) {
    }

    @Override
    public void replay(String scriptPath, ScriptListener listener, int times, RecordActionController.CoordReplayThread runningThread) {
    }

    @Override
    public void replay(ScriptListener listener, int times, RecordActionController.ReplayThread runningThread) {
    }

    public boolean isStopFlag() {
        return this.stopFlag;
    }

    public void setStopFlag(boolean stopFlag) {
        if (stopFlag) {
            StatusMgt.setViewRecorderStop(true);
        }
        this.stopFlag = stopFlag;
    }

    private class MonkeyOutputReceier
    extends MultiLineReceiver {
        String regex = "activityResuming\\((\\S+)\\)$|in\\spackage\\s(\\S+)$";
        Pattern pattern = Pattern.compile(this.regex);

        private MonkeyOutputReceier() {
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public void processNewLines(String[] lines) {
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                Matcher m = this.pattern.matcher(s);
                if (m.find()) {
                    String g1 = m.group(1);
                    String g2 = m.group(2);
                    if (StringUtils.isNotEmpty((String)g1)) {
                        ViewRecorder.this.checkPackage(g1);
                    } else if (StringUtils.isNotEmpty((String)g2)) {
                        ViewRecorder.this.checkPackage(g2);
                    }
                }
                ++n2;
            }
        }
    }

    private class TestOutputReceiver
    extends MultiLineReceiver {
        int i = 0;

        private TestOutputReceiver() {
        }

        @Override
        public boolean isCancelled() {
            return StatusMgt.isViewRecorderStop();
        }

        @Override
        public void processNewLines(String[] arg0) {
            if (this.i == 0) {
                ViewRecorder.this.listener.onAppStarted();
                ++this.i;
            }
            int i = 0;
            while (i < arg0.length) {
                String line = arg0[i];
                if (line.length() > 0) {
                    ViewRecorder.this.errorDetails.append(String.valueOf(line) + "\r\n");
                }
                log.debug((Object)String.format("INSTRUMENT LOG: %s", line));
                ++i;
            }
        }
    }
}

